/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class StdIOCapture {
    private final List<String> stdout = new CopyOnWriteArrayList<String>();
    private final List<String> stderr = new CopyOnWriteArrayList<String>();

    public AutoCloseable capture() {
        PrintStream originalStdOut = System.out;
        PrintStream originalStdErr = System.err;
        ByteArrayOutputStream capturedStdOut = new ByteArrayOutputStream();
        ByteArrayOutputStream capturedStdErr = new ByteArrayOutputStream();
        System.setOut(new PrintStream(capturedStdOut));
        System.setErr(new PrintStream(capturedStdErr));
        return () -> {
            System.setOut(originalStdOut);
            System.setErr(originalStdErr);
            this.stdout.addAll(Arrays.asList(capturedStdOut.toString("UTF-8").split(System.lineSeparator())));
            this.stderr.addAll(Arrays.asList(capturedStdErr.toString("UTF-8").split(System.lineSeparator())));
        };
    }

    public List<String> stdout() {
        return this.stdout;
    }

    public List<String> stderr() {
        return this.stderr;
    }
}

