/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util;

public final class ProcessEnvConfigurator {
    private static final String JAVA_HOME = "JAVA_HOME";
    private static final String NEO4J_JAVA = "NEO4J_JAVA";
    private static final String BOLTKIT_LOCAL_PACKAGE = "NEOCTRL_LOCAL_PACKAGE";

    private ProcessEnvConfigurator() {
    }

    public static void configure(ProcessBuilder processBuilder) {
        processBuilder.environment().put(JAVA_HOME, ProcessEnvConfigurator.determineJavaHome());
        String localPackage = ProcessEnvConfigurator.determineLocalPackage();
        if (localPackage != null) {
            processBuilder.environment().put(BOLTKIT_LOCAL_PACKAGE, localPackage);
        }
    }

    private static String determineJavaHome() {
        return System.getenv().getOrDefault(NEO4J_JAVA, System.getProperties().getProperty("java.home"));
    }

    private static String determineLocalPackage() {
        String value = System.getenv().getOrDefault(BOLTKIT_LOCAL_PACKAGE, "").trim();
        return value.isEmpty() ? null : value;
    }
}

