/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.util.FileTools;

class FileToolsTest {
    FileToolsTest() {
    }

    @Test
    void shouldBeAbleToCreateTemporaryFile() throws Throwable {
        File file = FileTools.tempFile("test");
        try {
            MatcherAssert.assertThat((Object)file.exists(), (Matcher)CoreMatchers.equalTo((Object)true));
        }
        finally {
            MatcherAssert.assertThat((Object)FileTools.deleteFile(file), (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldAddPropertyAtBottom() throws IOException {
        File propertyFile = this.createPropertyFile();
        FileTools.updateProperty(propertyFile, "cat.name", "mimi");
        try (Scanner in = new Scanner(propertyFile);){
            Assertions.assertEquals((Object)"#Wow wow", (Object)in.nextLine());
            Assertions.assertEquals((Object)"Meow meow", (Object)in.nextLine());
            Assertions.assertEquals((Object)"color=black", (Object)in.nextLine());
            Assertions.assertEquals((Object)"cat.age=3", (Object)in.nextLine());
            Assertions.assertEquals((Object)"cat.name=mimi", (Object)in.nextLine());
            Assertions.assertFalse((boolean)in.hasNextLine());
        }
        finally {
            MatcherAssert.assertThat((Object)FileTools.deleteFile(propertyFile), (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldResetPropertyAtTheSameLine() throws IOException {
        File propertyFile = this.createPropertyFile();
        FileTools.updateProperty(propertyFile, "color", "white");
        try (Scanner in = new Scanner(propertyFile);){
            Assertions.assertEquals((Object)"#Wow wow", (Object)in.nextLine());
            Assertions.assertEquals((Object)"Meow meow", (Object)in.nextLine());
            Assertions.assertEquals((Object)"color=white", (Object)in.nextLine());
            Assertions.assertEquals((Object)"cat.age=3", (Object)in.nextLine());
            Assertions.assertFalse((boolean)in.hasNextLine());
        }
        finally {
            MatcherAssert.assertThat((Object)FileTools.deleteFile(propertyFile), (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    private File createPropertyFile() throws FileNotFoundException {
        File propFile = new File("Cat");
        PrintWriter out = new PrintWriter(propFile);
        out.println("#Wow wow");
        out.println("Meow meow");
        out.println("color=black");
        out.println("cat.age=3");
        out.close();
        return propFile;
    }
}

