/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalNode;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.internal.InternalRelationship;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.internal.value.PathValue;
import org.neo4j.driver.internal.value.RelationshipValue;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;
import org.neo4j.driver.types.Type;

class TypeSystemTest {
    private final InternalNode node = new InternalNode(42L);
    private final InternalRelationship relationship = new InternalRelationship(42L, 42L, 43L, "T");
    private Value integerValue = Values.value((int)13);
    private Value floatValue = Values.value((double)13.1);
    private Value stringValue = Values.value((String)"Lalala ");
    private Value nodeValue = new NodeValue((Node)this.node);
    private Value relationshipValue = new RelationshipValue((Relationship)this.relationship);
    private Value mapValue = Values.value(Collections.singletonMap("type", "r"));
    private Value pathValue = new PathValue((Path)new InternalPath(Arrays.asList(this.node, this.relationship, this.node)));
    private Value booleanValue = Values.value((boolean)true);
    private Value listValue = Values.value(Arrays.asList(1, 2, 3));
    private Value nullValue = Values.value(null);
    private InternalTypeSystem typeSystem = InternalTypeSystem.TYPE_SYSTEM;

    TypeSystemTest() {
    }

    private TypeVerifier newTypeVerifierFor(Type type) {
        HashSet<Value> allValues = new HashSet<Value>();
        allValues.add(this.integerValue);
        allValues.add(this.stringValue);
        allValues.add(this.floatValue);
        allValues.add(this.nodeValue);
        allValues.add(this.relationshipValue);
        allValues.add(this.mapValue);
        allValues.add(this.pathValue);
        allValues.add(this.booleanValue);
        allValues.add(this.nullValue);
        allValues.add(this.listValue);
        return new TypeVerifier(type, allValues);
    }

    @Test
    void shouldNameTypeCorrectly() {
        MatcherAssert.assertThat((Object)InternalTypeSystem.TYPE_SYSTEM.ANY().name(), (Matcher)Is.is((Object)"ANY"));
        MatcherAssert.assertThat((Object)InternalTypeSystem.TYPE_SYSTEM.BOOLEAN().name(), (Matcher)Is.is((Object)"BOOLEAN"));
        MatcherAssert.assertThat((Object)InternalTypeSystem.TYPE_SYSTEM.STRING().name(), (Matcher)Is.is((Object)"STRING"));
        MatcherAssert.assertThat((Object)InternalTypeSystem.TYPE_SYSTEM.NUMBER().name(), (Matcher)Is.is((Object)"NUMBER"));
        MatcherAssert.assertThat((Object)InternalTypeSystem.TYPE_SYSTEM.INTEGER().name(), (Matcher)Is.is((Object)"INTEGER"));
        MatcherAssert.assertThat((Object)InternalTypeSystem.TYPE_SYSTEM.FLOAT().name(), (Matcher)Is.is((Object)"FLOAT"));
        MatcherAssert.assertThat((Object)InternalTypeSystem.TYPE_SYSTEM.LIST().name(), (Matcher)Is.is((Object)"LIST OF ANY?"));
        MatcherAssert.assertThat((Object)InternalTypeSystem.TYPE_SYSTEM.MAP().name(), (Matcher)Is.is((Object)"MAP"));
        MatcherAssert.assertThat((Object)InternalTypeSystem.TYPE_SYSTEM.NODE().name(), (Matcher)Is.is((Object)"NODE"));
        MatcherAssert.assertThat((Object)InternalTypeSystem.TYPE_SYSTEM.RELATIONSHIP().name(), (Matcher)Is.is((Object)"RELATIONSHIP"));
        MatcherAssert.assertThat((Object)InternalTypeSystem.TYPE_SYSTEM.PATH().name(), (Matcher)Is.is((Object)"PATH"));
        MatcherAssert.assertThat((Object)InternalTypeSystem.TYPE_SYSTEM.NULL().name(), (Matcher)Is.is((Object)"NULL"));
    }

    @Test
    void shouldInferAnyTypeCorrectly() {
        try (TypeVerifier verifier = this.newTypeVerifierFor(InternalTypeSystem.TYPE_SYSTEM.ANY());){
            verifier.assertIncludes(this.booleanValue);
            verifier.assertIncludes(this.stringValue);
            verifier.assertIncludes(this.integerValue);
            verifier.assertIncludes(this.floatValue);
            verifier.assertIncludes(this.listValue);
            verifier.assertIncludes(this.mapValue);
            verifier.assertIncludes(this.nodeValue);
            verifier.assertIncludes(this.relationshipValue);
            verifier.assertIncludes(this.pathValue);
        }
    }

    @Test
    void shouldInferNumberTypeCorrectly() {
        try (TypeVerifier verifier = this.newTypeVerifierFor(InternalTypeSystem.TYPE_SYSTEM.NUMBER());){
            verifier.assertIncludes(this.integerValue);
            verifier.assertIncludes(this.floatValue);
        }
    }

    @Test
    void shouldInferNodesTypeCorrectly() {
        try (TypeVerifier verifier = this.newTypeVerifierFor(InternalTypeSystem.TYPE_SYSTEM.NODE());){
            verifier.assertIncludes(this.nodeValue);
        }
    }

    @Test
    void shouldInferRelTypeCorrectly() {
        try (TypeVerifier verifier = this.newTypeVerifierFor(InternalTypeSystem.TYPE_SYSTEM.RELATIONSHIP());){
            verifier.assertIncludes(this.relationshipValue);
        }
    }

    @Test
    void shouldInferStringTypeCorrectly() {
        try (TypeVerifier verifier = this.newTypeVerifierFor(InternalTypeSystem.TYPE_SYSTEM.STRING());){
            verifier.assertIncludes(this.stringValue);
        }
    }

    @Test
    void shouldInferMapTypeCorrectly() {
        try (TypeVerifier verifier = this.newTypeVerifierFor(InternalTypeSystem.TYPE_SYSTEM.MAP());){
            verifier.assertIncludes(this.nodeValue);
            verifier.assertIncludes(this.relationshipValue);
            verifier.assertIncludes(this.mapValue);
        }
    }

    @Test
    void shouldInferPathTypeCorrectly() {
        try (TypeVerifier verifier = this.newTypeVerifierFor(InternalTypeSystem.TYPE_SYSTEM.PATH());){
            verifier.assertIncludes(this.pathValue);
        }
    }

    @Test
    void shouldInferNullCorrectly() {
        try (TypeVerifier verifier = this.newTypeVerifierFor(InternalTypeSystem.TYPE_SYSTEM.NULL());){
            verifier.assertIncludes(this.nullValue);
        }
    }

    @Test
    void shouldInferBooleanTypeCorrectly() {
        try (TypeVerifier verifier = this.newTypeVerifierFor(InternalTypeSystem.TYPE_SYSTEM.BOOLEAN());){
            verifier.assertIncludes(this.booleanValue);
        }
    }

    @Test
    void shouldIntegerTypeCorrectly() {
        try (TypeVerifier verifier = this.newTypeVerifierFor(InternalTypeSystem.TYPE_SYSTEM.INTEGER());){
            verifier.assertIncludes(this.integerValue);
        }
    }

    @Test
    void shouldInferFloatTypeCorrectly() {
        try (TypeVerifier verifier = this.newTypeVerifierFor(InternalTypeSystem.TYPE_SYSTEM.FLOAT());){
            verifier.assertIncludes(this.floatValue);
        }
    }

    @Test
    void shouldInferListTypeCorrectly() {
        try (TypeVerifier verifier = this.newTypeVerifierFor(this.typeSystem.LIST());){
            verifier.assertIncludes(this.listValue);
        }
    }

    @Test
    void shouldDetermineTypeCorrectly() {
        MatcherAssert.assertThat((Object)this.integerValue, this.hasType(InternalTypeSystem.TYPE_SYSTEM.INTEGER()));
        MatcherAssert.assertThat((Object)this.floatValue, this.hasType(InternalTypeSystem.TYPE_SYSTEM.FLOAT()));
        MatcherAssert.assertThat((Object)this.stringValue, this.hasType(InternalTypeSystem.TYPE_SYSTEM.STRING()));
        MatcherAssert.assertThat((Object)this.booleanValue, this.hasType(InternalTypeSystem.TYPE_SYSTEM.BOOLEAN()));
        MatcherAssert.assertThat((Object)this.listValue, this.hasType(InternalTypeSystem.TYPE_SYSTEM.LIST()));
        MatcherAssert.assertThat((Object)this.mapValue, this.hasType(InternalTypeSystem.TYPE_SYSTEM.MAP()));
        MatcherAssert.assertThat((Object)this.nodeValue, this.hasType(InternalTypeSystem.TYPE_SYSTEM.NODE()));
        MatcherAssert.assertThat((Object)this.relationshipValue, this.hasType(InternalTypeSystem.TYPE_SYSTEM.RELATIONSHIP()));
        MatcherAssert.assertThat((Object)this.pathValue, this.hasType(InternalTypeSystem.TYPE_SYSTEM.PATH()));
        MatcherAssert.assertThat((Object)this.nullValue, this.hasType(InternalTypeSystem.TYPE_SYSTEM.NULL()));
    }

    private Matcher<? super Value> hasType(final Type type) {
        return new BaseMatcher<Value>(){

            public boolean matches(Object o) {
                return (o instanceof Value || o == null) && type.isTypeOf((Value)o);
            }

            public void describeTo(Description description) {
                description.appendText(type.name());
            }
        };
    }

    private class TypeVerifier
    implements AutoCloseable {
        private final Type type;
        private final Set<Value> values;

        TypeVerifier(Type type, Set<Value> values) {
            this.type = type;
            this.values = values;
        }

        void assertIncludes(Value value) {
            MatcherAssert.assertThat((Object)value, (Matcher)TypeSystemTest.this.hasType(this.type));
            this.values.remove(value);
        }

        @Override
        public void close() {
            for (Value value : this.values) {
                MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.not((Matcher)TypeSystemTest.this.hasType(this.type)));
            }
        }
    }
}

