/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.stress.AbstractRxQuery;
import org.neo4j.driver.stress.AbstractStressTestBase;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RxWriteQuery<C extends AbstractContext>
extends AbstractRxQuery<C> {
    private AbstractStressTestBase<C> stressTest;

    public RxWriteQuery(AbstractStressTestBase<C> stressTest, Driver driver, boolean useBookmark) {
        super(driver, useBookmark);
        this.stressTest = stressTest;
    }

    @Override
    public CompletionStage<Void> execute(C context) {
        CompletableFuture<Void> queryFinished = new CompletableFuture<Void>();
        Flux.usingWhen((Publisher)Mono.fromSupplier(() -> this.newSession(AccessMode.WRITE, context)), session -> Flux.from((Publisher)session.run("CREATE ()").consume()).doOnComplete(() -> context.setBookmark(session.lastBookmark())), RxSession::close).subscribe(summary -> {
            Assertions.assertEquals((int)1, (int)summary.counters().nodesCreated());
            context.nodeCreated();
            queryFinished.complete(null);
        }, error -> this.handleError(Futures.completionExceptionCause((Throwable)error), context, queryFinished));
        return queryFinished;
    }

    private void handleError(Throwable error, C context, CompletableFuture<Void> queryFinished) {
        if (!this.stressTest.handleWriteFailure(error, context)) {
            queryFinished.completeExceptionally(error);
        } else {
            queryFinished.complete(null);
        }
    }
}

