/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.reactive.RxTransaction;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.stress.AbstractRxQuery;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class RxFailingQueryInTx<C extends AbstractContext>
extends AbstractRxQuery<C> {
    public RxFailingQueryInTx(Driver driver) {
        super(driver, false);
    }

    @Override
    public CompletionStage<Void> execute(C context) {
        CompletableFuture<Void> queryFinished = new CompletableFuture<Void>();
        RxSession session = this.newSession(AccessMode.READ, context);
        Flux.usingWhen((Publisher)session.beginTransaction(), tx -> tx.run("UNWIND [10, 5, 0] AS x RETURN 10 / x").records(), RxTransaction::commit, (tx, error) -> tx.rollback(), null).subscribe(record -> MatcherAssert.assertThat((Object)record.get(0).asInt(), (Matcher)Matchers.either((Matcher)Matchers.equalTo((Object)1)).or(Matchers.equalTo((Object)2))), error -> {
            Throwable cause = Futures.completionExceptionCause((Throwable)error);
            MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.is(org.neo4j.driver.internal.util.Matchers.arithmeticError()));
            queryFinished.complete(null);
        });
        return queryFinished;
    }
}

