/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.stress.AbstractStressTestBase;
import org.neo4j.driver.stress.BlockingCommand;
import org.neo4j.driver.stress.BlockingWriteQueryUsingReadSessionWithRetries;
import org.neo4j.driver.util.cc.LocalOrRemoteClusterExtension;

class CausalClusteringStressIT
extends AbstractStressTestBase<Context> {
    @RegisterExtension
    static final LocalOrRemoteClusterExtension clusterRule = new LocalOrRemoteClusterExtension();

    CausalClusteringStressIT() {
    }

    @Override
    URI databaseUri() {
        return clusterRule.getClusterUri();
    }

    @Override
    AuthToken authToken() {
        return clusterRule.getAuthToken();
    }

    @Override
    Config.ConfigBuilder config(Config.ConfigBuilder builder) {
        return builder;
    }

    @Override
    Context createContext() {
        return new Context();
    }

    @Override
    boolean handleWriteFailure(Throwable error, Context context) {
        boolean isLeaderSwitch;
        if (error instanceof SessionExpiredException && (isLeaderSwitch = error.getMessage().endsWith("no longer accepts writes"))) {
            context.leaderSwitch();
            return true;
        }
        return false;
    }

    @Override
    void printStats(Context context) {
        System.out.println("Nodes read: " + context.getReadNodesCount());
        System.out.println("Nodes created: " + context.getCreatedNodesCount());
        System.out.println("Leader switches: " + context.getLeaderSwitchCount());
        System.out.println("Bookmark failures: " + context.getBookmarkFailures());
    }

    @Override
    void dumpLogs() {
        clusterRule.dumpClusterLogs();
    }

    @Override
    List<BlockingCommand<Context>> createTestSpecificBlockingCommands() {
        return Arrays.asList(new BlockingWriteQueryUsingReadSessionWithRetries((Driver)this.driver, false), new BlockingWriteQueryUsingReadSessionWithRetries((Driver)this.driver, true));
    }

    static class Context
    extends AbstractContext {
        final AtomicInteger leaderSwitches = new AtomicInteger();

        Context() {
        }

        void leaderSwitch() {
            this.leaderSwitches.incrementAndGet();
        }

        int getLeaderSwitchCount() {
            return this.leaderSwitches.get();
        }
    }
}

