/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.net.URI;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.integration.NestedQueries;
import org.neo4j.driver.util.cc.ClusterExtension;

public class CausalClusteringIT
implements NestedQueries {
    @RegisterExtension
    static final ClusterExtension clusterRule = new ClusterExtension();
    private Driver driver;

    @Override
    public Session newSession(AccessMode mode) {
        if (this.driver == null) {
            this.driver = this.createDriver(clusterRule.getCluster().getRoutingUri());
        }
        return this.driver.session(SessionConfig.builder().withDefaultAccessMode(mode).build());
    }

    @AfterEach
    void tearDown() {
        if (this.driver != null) {
            this.driver.close();
        }
    }

    private Driver createDriver(URI boltUri) {
        return this.createDriver(boltUri, CausalClusteringIT.configWithoutLogging());
    }

    private Driver createDriver(URI boltUri, Config config) {
        return GraphDatabase.driver((URI)boltUri, (AuthToken)clusterRule.getDefaultAuthToken(), (Config)config);
    }

    private static Config configWithoutLogging() {
        return Config.builder().withLogging(Logging.none()).build();
    }
}

