/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.stress.AbstractAsyncQuery;
import org.neo4j.driver.stress.AbstractContext;

public class AsyncWrongQueryWithRetries<C extends AbstractContext>
extends AbstractAsyncQuery<C> {
    public AsyncWrongQueryWithRetries(Driver driver) {
        super(driver, false);
    }

    @Override
    public CompletionStage<Void> execute(C context) {
        AsyncSession session = this.newSession(AccessMode.READ, context);
        AtomicReference recordRef = new AtomicReference();
        AtomicReference throwableRef = new AtomicReference();
        CompletionStage txStage = session.readTransactionAsync(tx -> tx.runAsync("RETURN Wrong").thenCompose(cursor -> cursor.nextAsync().thenCompose(record -> {
            recordRef.set(record);
            return cursor.consumeAsync();
        })));
        CompletionStage<Void> resultsProcessingStage = txStage.handle((resultSummary, throwable) -> {
            throwableRef.set(throwable);
            return null;
        }).thenApply(nothing -> {
            Assertions.assertNull(recordRef.get());
            Throwable cause = Futures.completionExceptionCause((Throwable)((Throwable)throwableRef.get()));
            Assertions.assertNotNull((Object)cause);
            MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(ClientException.class));
            MatcherAssert.assertThat((Object)((Neo4jException)cause).code(), (Matcher)Matchers.containsString((String)"SyntaxError"));
            return null;
        });
        return resultsProcessingStage.whenComplete((nothing, throwable) -> session.closeAsync());
    }
}

