/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.util.concurrent.CompletionStage;
import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.AsyncTransaction;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.stress.AbstractAsyncQuery;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.types.Node;

public class AsyncReadQueryInTx<C extends AbstractContext>
extends AbstractAsyncQuery<C> {
    public AsyncReadQueryInTx(Driver driver, boolean useBookmark) {
        super(driver, useBookmark);
    }

    @Override
    public CompletionStage<Void> execute(C ctx) {
        AsyncSession session = this.newSession(AccessMode.READ, ctx);
        CompletionStage<Void> txCommitted = session.beginTransactionAsync().thenCompose(tx -> tx.runAsync("MATCH (n) RETURN n LIMIT 1").thenCompose(cursor -> cursor.nextAsync().thenCompose(record -> this.processRecordAndGetSummary((Record)record, (ResultCursor)cursor).thenCompose(summary -> this.processSummaryAndCommit((ResultSummary)summary, (AsyncTransaction)tx, ctx)))));
        txCommitted.whenComplete((ignore, error) -> session.closeAsync());
        return txCommitted;
    }

    private CompletionStage<ResultSummary> processRecordAndGetSummary(Record record, ResultCursor cursor) {
        if (record != null) {
            Node node = record.get(0).asNode();
            Assertions.assertNotNull((Object)node);
        }
        return cursor.consumeAsync();
    }

    private CompletionStage<Void> processSummaryAndCommit(ResultSummary summary, AsyncTransaction tx, C context) {
        ((AbstractContext)context).readCompleted(summary);
        return tx.commitAsync();
    }
}

