/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.util.concurrent.CompletionStage;
import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.stress.AbstractAsyncQuery;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.types.Node;

public class AsyncReadQuery<C extends AbstractContext>
extends AbstractAsyncQuery<C> {
    public AsyncReadQuery(Driver driver, boolean useBookmark) {
        super(driver, useBookmark);
    }

    @Override
    public CompletionStage<Void> execute(C context) {
        AsyncSession session = this.newSession(AccessMode.READ, context);
        CompletionStage<Void> queryFinished = session.runAsync("MATCH (n) RETURN n LIMIT 1").thenCompose(cursor -> cursor.nextAsync().thenCompose(record -> this.processAndGetSummary((Record)record, (ResultCursor)cursor)));
        queryFinished.whenComplete((summary, error) -> {
            if (summary != null) {
                context.readCompleted((ResultSummary)summary);
            }
            session.closeAsync();
        });
        return queryFinished.thenApply(summary -> null);
    }

    private CompletionStage<ResultSummary> processAndGetSummary(Record record, ResultCursor cursor) {
        if (record != null) {
            Node node = record.get(0).asNode();
            Assertions.assertNotNull((Object)node);
        }
        return cursor.consumeAsync();
    }
}

