/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.stress.BlockingCommand;

public abstract class AbstractBlockingQuery<C extends AbstractContext>
implements BlockingCommand<C> {
    protected final Driver driver;
    protected final boolean useBookmark;

    public AbstractBlockingQuery(Driver driver, boolean useBookmark) {
        this.driver = driver;
        this.useBookmark = useBookmark;
    }

    public Session newSession(AccessMode mode, C context) {
        if (this.useBookmark) {
            return this.driver.session(SessionConfig.builder().withDefaultAccessMode(mode).withBookmarks(new Bookmark[]{((AbstractContext)context).getBookmark()}).build());
        }
        return this.driver.session(SessionConfig.builder().withDefaultAccessMode(mode).build());
    }

    public Transaction beginTransaction(Session session, C context) {
        if (this.useBookmark) {
            while (true) {
                try {
                    return session.beginTransaction();
                }
                catch (TransientException e) {
                    ((AbstractContext)context).bookmarkFailed();
                    continue;
                }
                break;
            }
        }
        return session.beginTransaction();
    }
}

