/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.internal.InternalIsoDuration;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.DurationValue;
import org.neo4j.driver.types.IsoDuration;

class DurationValueTest {
    DurationValueTest() {
    }

    @Test
    void shouldHaveCorrectType() {
        IsoDuration duration = DurationValueTest.newDuration(1L, 2L, 3L, 4);
        DurationValue durationValue = new DurationValue(duration);
        Assertions.assertEquals((Object)InternalTypeSystem.TYPE_SYSTEM.DURATION(), (Object)durationValue.type());
    }

    @Test
    void shouldSupportAsObject() {
        IsoDuration duration = DurationValueTest.newDuration(11L, 22L, 33L, 44);
        DurationValue durationValue = new DurationValue(duration);
        Assertions.assertEquals((Object)duration, (Object)durationValue.asObject());
    }

    @Test
    void shouldSupportAsOffsetTime() {
        IsoDuration duration = DurationValueTest.newDuration(111L, 222L, 333L, 444);
        DurationValue durationValue = new DurationValue(duration);
        Assertions.assertEquals((Object)duration, (Object)durationValue.asIsoDuration());
    }

    @Test
    void shouldNotSupportAsLong() {
        IsoDuration duration = DurationValueTest.newDuration(1111L, 2222L, 3333L, 4444);
        DurationValue durationValue = new DurationValue(duration);
        Assertions.assertThrows(Uncoercible.class, () -> ((DurationValue)durationValue).asLong());
    }

    private static IsoDuration newDuration(long months, long days, long seconds, int nanoseconds) {
        return new InternalIsoDuration(months, days, seconds, nanoseconds);
    }
}

