/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util.messaging;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.neo4j.driver.internal.messaging.AbstractMessageWriter;
import org.neo4j.driver.internal.messaging.MessageEncoder;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.ValuePacker;
import org.neo4j.driver.internal.messaging.common.CommonValuePacker;
import org.neo4j.driver.internal.messaging.encode.DiscardAllMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.PullAllMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.ResetMessageEncoder;
import org.neo4j.driver.internal.messaging.v3.MessageFormatV3;
import org.neo4j.driver.internal.packstream.PackOutput;
import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.internal.util.messaging.FailureMessageEncoder;
import org.neo4j.driver.internal.util.messaging.IgnoredMessageEncoder;
import org.neo4j.driver.internal.util.messaging.RecordMessageEncoder;
import org.neo4j.driver.internal.util.messaging.SuccessMessageEncoder;
import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;

public class KnowledgeableMessageFormat
extends MessageFormatV3 {
    private boolean dateTimeUtcEnabled;

    public MessageFormat.Writer newWriter(PackOutput output) {
        return new KnowledgeableMessageWriter(output, this.dateTimeUtcEnabled);
    }

    public void enableDateTimeUtc() {
        this.dateTimeUtcEnabled = true;
    }

    private static class KnowledgeableValuePacker
    extends CommonValuePacker {
        KnowledgeableValuePacker(PackOutput output, boolean dateTimeUtcEnabled) {
            super(output, dateTimeUtcEnabled);
        }

        protected void packInternalValue(InternalValue value) throws IOException {
            TypeConstructor typeConstructor = value.typeConstructor();
            switch (typeConstructor) {
                case NODE: {
                    Node node = value.asNode();
                    this.packNode(node);
                    break;
                }
                case RELATIONSHIP: {
                    Relationship rel = value.asRelationship();
                    this.packRelationship(rel);
                    break;
                }
                case PATH: {
                    Path path = value.asPath();
                    this.packPath(path);
                    break;
                }
                default: {
                    super.packInternalValue(value);
                }
            }
        }

        private void packPath(Path path) throws IOException {
            this.packer.packStructHeader(3, (byte)80);
            LinkedHashMap nodeIdx = Iterables.newLinkedHashMapWithSize((int)(path.length() + 1));
            for (Node node : path.nodes()) {
                if (nodeIdx.containsKey(node)) continue;
                nodeIdx.put(node, nodeIdx.size());
            }
            this.packer.packListHeader(nodeIdx.size());
            for (Node node : nodeIdx.keySet()) {
                this.packNode(node);
            }
            LinkedHashMap relIdx = Iterables.newLinkedHashMapWithSize((int)path.length());
            for (Relationship rel : path.relationships()) {
                if (relIdx.containsKey(rel)) continue;
                relIdx.put(rel, relIdx.size() + 1);
            }
            this.packer.packListHeader(relIdx.size());
            for (Relationship rel : relIdx.keySet()) {
                this.packer.packStructHeader(3, (byte)114);
                this.packer.pack(rel.id());
                this.packer.pack(rel.type());
                this.packProperties((Entity)rel);
            }
            this.packer.packListHeader(path.length() * 2);
            for (Path.Segment seg : path) {
                long segEndId;
                Relationship rel = seg.relationship();
                long relEndId = rel.endNodeId();
                int size = relEndId == (segEndId = seg.end().id()) ? (Integer)relIdx.get(rel) : -((Integer)relIdx.get(rel)).intValue();
                this.packer.pack((long)size);
                this.packer.pack(nodeIdx.get(seg.end()));
            }
        }

        private void packRelationship(Relationship rel) throws IOException {
            this.packer.packStructHeader(5, (byte)82);
            this.packer.pack(rel.id());
            this.packer.pack(rel.startNodeId());
            this.packer.pack(rel.endNodeId());
            this.packer.pack(rel.type());
            this.packProperties((Entity)rel);
        }

        private void packNode(Node node) throws IOException {
            this.packer.packStructHeader(3, (byte)78);
            this.packer.pack(node.id());
            Iterable labels = node.labels();
            this.packer.packListHeader(Iterables.count((Iterable)labels));
            for (String label : labels) {
                this.packer.pack(label);
            }
            this.packProperties((Entity)node);
        }

        private void packProperties(Entity entity) throws IOException {
            Iterable keys = entity.keys();
            this.packer.packMapHeader(entity.size());
            for (String propKey : keys) {
                this.packer.pack(propKey);
                this.packInternalValue((InternalValue)entity.get(propKey));
            }
        }
    }

    private static class KnowledgeableMessageWriter
    extends AbstractMessageWriter {
        KnowledgeableMessageWriter(PackOutput output, boolean dateTimeUtcEnabled) {
            super((ValuePacker)new KnowledgeableValuePacker(output, dateTimeUtcEnabled), KnowledgeableMessageWriter.buildEncoders());
        }

        static Map<Byte, MessageEncoder> buildEncoders() {
            HashMap result = Iterables.newHashMapWithSize((int)10);
            result.put((byte)47, new DiscardAllMessageEncoder());
            result.put((byte)63, new PullAllMessageEncoder());
            result.put((byte)15, new ResetMessageEncoder());
            result.put((byte)127, new FailureMessageEncoder());
            result.put((byte)126, new IgnoredMessageEncoder());
            result.put((byte)113, new RecordMessageEncoder());
            result.put((byte)112, new SuccessMessageEncoder());
            return result;
        }
    }
}

