/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util.messaging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.mockito.Mockito;
import org.neo4j.driver.internal.async.inbound.ByteBufInput;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.packstream.PackInput;
import org.neo4j.driver.internal.packstream.PackOutput;
import org.neo4j.driver.internal.packstream.PackStream;
import org.neo4j.driver.internal.util.io.ByteBufOutput;

public abstract class AbstractMessageWriterTestBase {
    @TestFactory
    Stream<DynamicNode> shouldWriteSupportedMessages() {
        return this.supportedMessages().map(message -> DynamicTest.dynamicTest((String)message.toString(), () -> this.testSupportedMessageWriting((Message)message)));
    }

    @TestFactory
    Stream<DynamicNode> shouldFailToWriteUnsupportedMessages() {
        return this.unsupportedMessages().map(message -> DynamicTest.dynamicTest((String)message.toString(), () -> this.testUnsupportedMessageWriting((Message)message)));
    }

    protected abstract MessageFormat.Writer newWriter(PackOutput var1);

    protected abstract Stream<Message> supportedMessages();

    protected abstract Stream<Message> unsupportedMessages();

    private void testSupportedMessageWriting(Message message) throws IOException {
        ByteBuf buffer = Unpooled.buffer();
        ByteBufOutput output = new ByteBufOutput(buffer);
        MessageFormat.Writer writer = this.newWriter(output);
        writer.write(message);
        ByteBufInput input = new ByteBufInput();
        input.start(buffer);
        PackStream.Unpacker unpacker = new PackStream.Unpacker((PackInput)input);
        long structHeader = unpacker.unpackStructHeader();
        MatcherAssert.assertThat((Object)structHeader, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        byte structSignature = unpacker.unpackStructSignature();
        Assertions.assertEquals((byte)message.signature(), (byte)structSignature);
    }

    private void testUnsupportedMessageWriting(Message message) {
        MessageFormat.Writer writer = this.newWriter((PackOutput)Mockito.mock(PackOutput.class));
        Assertions.assertThrows(Exception.class, () -> writer.write(message));
    }
}

