/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.driver.Config;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.DefaultDomainNameResolver;
import org.neo4j.driver.internal.DomainNameResolver;
import org.neo4j.driver.internal.DriverFactory;
import org.neo4j.driver.internal.async.connection.ChannelConnector;
import org.neo4j.driver.internal.async.connection.ChannelConnectorImpl;
import org.neo4j.driver.internal.async.connection.ChannelPipelineBuilder;
import org.neo4j.driver.internal.async.connection.ChannelPipelineBuilderImpl;
import org.neo4j.driver.internal.async.outbound.OutboundMessageHandler;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.util.Clock;

public class MessageRecordingDriverFactory
extends DriverFactory {
    private final Map<Channel, List<Message>> messagesByChannel = new ConcurrentHashMap<Channel, List<Message>>();

    public Map<Channel, List<Message>> getMessagesByChannel() {
        return this.messagesByChannel;
    }

    protected ChannelConnector createConnector(ConnectionSettings settings, SecurityPlan securityPlan, Config config, Clock clock, RoutingContext routingContext) {
        MessageRecordingChannelPipelineBuilder pipelineBuilder = new MessageRecordingChannelPipelineBuilder();
        return new ChannelConnectorImpl(settings, securityPlan, (ChannelPipelineBuilder)pipelineBuilder, config.logging(), clock, routingContext, (DomainNameResolver)DefaultDomainNameResolver.getInstance());
    }

    private class MessageRecordingHandler
    extends MessageToMessageEncoder<Message> {
        private MessageRecordingHandler() {
        }

        protected void encode(ChannelHandlerContext ctx, Message msg, List<Object> out) {
            List messages = MessageRecordingDriverFactory.this.messagesByChannel.computeIfAbsent(ctx.channel(), ignore -> new CopyOnWriteArrayList());
            messages.add(msg);
            out.add(msg);
        }
    }

    private class MessageRecordingChannelPipelineBuilder
    extends ChannelPipelineBuilderImpl {
        private MessageRecordingChannelPipelineBuilder() {
        }

        public void build(MessageFormat messageFormat, ChannelPipeline pipeline, Logging logging) {
            super.build(messageFormat, pipeline, logging);
            pipeline.addAfter(OutboundMessageHandler.NAME, MessageRecordingHandler.class.getSimpleName(), (ChannelHandler)new MessageRecordingHandler());
        }
    }
}

