/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.neo4j.driver.Driver;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DirectConnectionProvider;
import org.neo4j.driver.internal.InternalDriver;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.SessionFactoryImpl;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancer;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.summary.ResultSummary;

public final class Matchers {
    private Matchers() {
    }

    public static Matcher<Driver> directDriver() {
        return new TypeSafeMatcher<Driver>(){

            protected boolean matchesSafely(Driver driver) {
                return Matchers.hasConnectionProvider(driver, DirectConnectionProvider.class);
            }

            public void describeTo(Description description) {
                description.appendText("direct 'bolt://' driver ");
            }
        };
    }

    public static Matcher<Driver> directDriverWithAddress(final BoltServerAddress address) {
        return new TypeSafeMatcher<Driver>(){

            protected boolean matchesSafely(Driver driver) {
                DirectConnectionProvider provider = (DirectConnectionProvider)Matchers.extractConnectionProvider(driver, DirectConnectionProvider.class);
                return provider != null && Objects.equals(provider.getAddress(), address);
            }

            public void describeTo(Description description) {
                description.appendText("direct driver with address bolt://").appendValue((Object)address);
            }
        };
    }

    public static Matcher<Driver> clusterDriver() {
        return new TypeSafeMatcher<Driver>(){

            protected boolean matchesSafely(Driver driver) {
                return Matchers.hasConnectionProvider(driver, LoadBalancer.class);
            }

            public void describeTo(Description description) {
                description.appendText("cluster 'neo4j://' driver ");
            }
        };
    }

    public static Matcher<ResultSummary> containsResultAvailableAfterAndResultConsumedAfter() {
        return new TypeSafeMatcher<ResultSummary>(){

            protected boolean matchesSafely(ResultSummary summary) {
                return summary.resultAvailableAfter(TimeUnit.MILLISECONDS) >= 0L && summary.resultConsumedAfter(TimeUnit.MILLISECONDS) >= 0L;
            }

            public void describeTo(Description description) {
                description.appendText("resultAvailableAfter and resultConsumedAfter ");
            }
        };
    }

    public static Matcher<Throwable> arithmeticError() {
        return new TypeSafeMatcher<Throwable>(){

            protected boolean matchesSafely(Throwable error) {
                return error instanceof ClientException && ((ClientException)error).code().contains("ArithmeticError");
            }

            public void describeTo(Description description) {
                description.appendText("client error with code 'ArithmeticError' ");
            }
        };
    }

    public static Matcher<Throwable> syntaxError() {
        return Matchers.syntaxError(null);
    }

    public static Matcher<Throwable> syntaxError(final String messagePrefix) {
        return new TypeSafeMatcher<Throwable>(){

            protected boolean matchesSafely(Throwable error) {
                if (error instanceof ClientException) {
                    ClientException clientError = (ClientException)error;
                    return clientError.code().contains("SyntaxError") && (messagePrefix == null || clientError.getMessage().startsWith(messagePrefix));
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("client error with code 'SyntaxError' and prefix '" + messagePrefix + "' ");
            }
        };
    }

    public static Matcher<Throwable> connectionAcquisitionTimeoutError(final int timeoutMillis) {
        return new TypeSafeMatcher<Throwable>(){

            protected boolean matchesSafely(Throwable error) {
                if (error instanceof ClientException) {
                    String expectedMessage = "Unable to acquire connection from the pool within configured maximum time of " + timeoutMillis + "ms";
                    return expectedMessage.equals(error.getMessage());
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("acquisition timeout error with " + timeoutMillis + "ms");
            }
        };
    }

    public static Matcher<Throwable> blockingOperationInEventLoopError() {
        return new TypeSafeMatcher<Throwable>(){

            protected boolean matchesSafely(Throwable error) {
                return error instanceof IllegalStateException && error.getMessage() != null && error.getMessage().startsWith("Blocking operation can't be executed in IO thread");
            }

            public void describeTo(Description description) {
                description.appendText("IllegalStateException about blocking operation in event loop thread ");
            }
        };
    }

    private static boolean hasConnectionProvider(Driver driver, Class<? extends ConnectionProvider> providerClass) {
        return Matchers.extractConnectionProvider(driver, providerClass) != null;
    }

    private static <T extends ConnectionProvider> T extractConnectionProvider(Driver driver, Class<T> providerClass) {
        ConnectionProvider provider;
        SessionFactory sessionFactory;
        if (driver instanceof InternalDriver && (sessionFactory = ((InternalDriver)driver).getSessionFactory()) instanceof SessionFactoryImpl && providerClass.isInstance(provider = ((SessionFactoryImpl)sessionFactory).getConnectionProvider())) {
            return (T)((ConnectionProvider)providerClass.cast(provider));
        }
        return null;
    }
}

