/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import io.netty.util.concurrent.EventExecutorGroup;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.retry.ExponentialBackoffRetryLogic;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.ImmediateSchedulingEventExecutor;
import org.neo4j.driver.internal.util.SleeplessClock;

public class FixedRetryLogic
extends ExponentialBackoffRetryLogic {
    private final int retryCount;
    private int invocationCount;

    public FixedRetryLogic(int retryCount) {
        this(retryCount, (EventExecutorGroup)new ImmediateSchedulingEventExecutor());
    }

    public FixedRetryLogic(int retryCount, EventExecutorGroup eventExecutorGroup) {
        super(new RetrySettings(Long.MAX_VALUE), eventExecutorGroup, (Clock)new SleeplessClock(), DevNullLogging.DEV_NULL_LOGGING);
        this.retryCount = retryCount;
    }

    protected boolean canRetryOn(Throwable error) {
        return this.invocationCount++ < this.retryCount;
    }
}

