/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.internal.reactive.RxUtils;
import org.neo4j.driver.internal.util.Futures;
import org.reactivestreams.Publisher;
import reactor.test.StepVerifier;

class RxUtilsTest {
    RxUtilsTest() {
    }

    @Test
    void emptyPublisherShouldComplete() {
        Publisher emptyPublisher = RxUtils.createEmptyPublisher(Futures::completedWithNull);
        StepVerifier.create((Publisher)emptyPublisher).verifyComplete();
    }

    @Test
    void emptyPublisherShouldErrorWhenSupplierErrors() {
        RuntimeException error = new RuntimeException("Error");
        Publisher emptyPublisher = RxUtils.createEmptyPublisher(() -> Futures.failedFuture((Throwable)error));
        StepVerifier.create((Publisher)emptyPublisher).verifyErrorMatches(Predicate.isEqual(error));
    }

    @Test
    void singleItemPublisherShouldCompleteWithValue() {
        Publisher publisher = RxUtils.createSingleItemPublisher(() -> CompletableFuture.completedFuture("One"), () -> (Throwable)Mockito.mock(Throwable.class));
        StepVerifier.create((Publisher)publisher).expectNext((Object)"One").verifyComplete();
    }

    @Test
    void singleItemPublisherShouldErrorWhenFutureCompletesWithNull() {
        Throwable error = (Throwable)Mockito.mock(Throwable.class);
        Publisher publisher = RxUtils.createSingleItemPublisher(Futures::completedWithNull, () -> error);
        StepVerifier.create((Publisher)publisher).verifyErrorMatches(actualError -> error == actualError);
    }

    @Test
    void singleItemPublisherShouldErrorWhenSupplierErrors() {
        RuntimeException error = (RuntimeException)Mockito.mock(RuntimeException.class);
        Publisher publisher = RxUtils.createSingleItemPublisher(() -> Futures.failedFuture((Throwable)error), () -> (Throwable)Mockito.mock(Throwable.class));
        StepVerifier.create((Publisher)publisher).verifyErrorMatches(actualError -> error == actualError);
    }
}

