/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v3;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.DefaultBookmarkHolder;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cursor.AsyncResultCursor;
import org.neo4j.driver.internal.handlers.BeginTxResponseHandler;
import org.neo4j.driver.internal.handlers.CommitTxResponseHandler;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RollbackTxResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.request.BeginMessage;
import org.neo4j.driver.internal.messaging.request.CommitMessage;
import org.neo4j.driver.internal.messaging.request.GoodbyeMessage;
import org.neo4j.driver.internal.messaging.request.HelloMessage;
import org.neo4j.driver.internal.messaging.request.PullAllMessage;
import org.neo4j.driver.internal.messaging.request.RollbackMessage;
import org.neo4j.driver.internal.messaging.request.RunWithMetadataMessage;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v3.MessageFormatV3;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.util.TestUtil;

public class BoltProtocolV3Test {
    protected static final String QUERY_TEXT = "RETURN $x";
    protected static final Map<String, Value> PARAMS = Collections.singletonMap("x", Values.value((int)42));
    protected static final Query QUERY = new Query("RETURN $x", Values.value(PARAMS));
    protected final BoltProtocol protocol = this.createProtocol();
    private final EmbeddedChannel channel = new EmbeddedChannel();
    private final InboundMessageDispatcher messageDispatcher = new InboundMessageDispatcher((Channel)this.channel, Logging.none());
    private final TransactionConfig txConfig = TransactionConfig.builder().withTimeout(Duration.ofSeconds(12L)).withMetadata(Collections.singletonMap("key", Values.value((int)42))).build();

    @BeforeEach
    void beforeEach() {
        ChannelAttributes.setMessageDispatcher((Channel)this.channel, (InboundMessageDispatcher)this.messageDispatcher);
    }

    @AfterEach
    void afterEach() {
        this.channel.finishAndReleaseAll();
    }

    protected BoltProtocol createProtocol() {
        return BoltProtocolV3.INSTANCE;
    }

    protected Class<? extends MessageFormat> expectedMessageFormatType() {
        return MessageFormatV3.class;
    }

    @Test
    void shouldCreateMessageFormat() {
        MatcherAssert.assertThat((Object)this.protocol.createMessageFormat(), (Matcher)Matchers.instanceOf(this.expectedMessageFormatType()));
    }

    @Test
    void shouldInitializeChannel() {
        ChannelPromise promise = this.channel.newPromise();
        this.protocol.initializeChannel("MyDriver/0.0.1", (AuthToken)BoltProtocolV3Test.dummyAuthToken(), RoutingContext.EMPTY, promise);
        MatcherAssert.assertThat((Object)this.channel.outboundMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(this.channel.outboundMessages().poll(), (Matcher)Matchers.instanceOf(HelloMessage.class));
        Assertions.assertEquals((int)1, (int)this.messageDispatcher.queuedHandlersCount());
        Assertions.assertFalse((boolean)promise.isDone());
        HashMap<String, Value> metadata = new HashMap<String, Value>();
        metadata.put("server", Values.value((String)TestUtil.anyServerVersion().toString()));
        metadata.put("connection_id", Values.value((String)"bolt-42"));
        this.messageDispatcher.handleSuccessMessage(metadata);
        Assertions.assertTrue((boolean)promise.isDone());
        Assertions.assertTrue((boolean)promise.isSuccess());
    }

    @Test
    void shouldPrepareToCloseChannel() {
        this.protocol.prepareToCloseChannel((Channel)this.channel);
        MatcherAssert.assertThat((Object)this.channel.outboundMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(this.channel.outboundMessages().poll(), (Matcher)Matchers.instanceOf(GoodbyeMessage.class));
        Assertions.assertEquals((int)1, (int)this.messageDispatcher.queuedHandlersCount());
    }

    @Test
    void shouldFailToInitializeChannelWhenErrorIsReceived() {
        ChannelPromise promise = this.channel.newPromise();
        this.protocol.initializeChannel("MyDriver/2.2.1", (AuthToken)BoltProtocolV3Test.dummyAuthToken(), RoutingContext.EMPTY, promise);
        MatcherAssert.assertThat((Object)this.channel.outboundMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(this.channel.outboundMessages().poll(), (Matcher)Matchers.instanceOf(HelloMessage.class));
        Assertions.assertEquals((int)1, (int)this.messageDispatcher.queuedHandlersCount());
        Assertions.assertFalse((boolean)promise.isDone());
        this.messageDispatcher.handleFailureMessage("Neo.TransientError.General.DatabaseUnavailable", "Error!");
        Assertions.assertTrue((boolean)promise.isDone());
        Assertions.assertFalse((boolean)promise.isSuccess());
    }

    @Test
    void shouldBeginTransactionWithoutBookmark() {
        Connection connection = TestUtil.connectionMock(this.protocol);
        CompletionStage stage = this.protocol.beginTransaction(connection, InternalBookmark.empty(), TransactionConfig.empty());
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.eq((Object)new BeginMessage(InternalBookmark.empty(), TransactionConfig.empty(), DatabaseNameUtil.defaultDatabase(), AccessMode.WRITE, null)), (ResponseHandler)ArgumentMatchers.any(BeginTxResponseHandler.class));
        Assertions.assertNull(TestUtil.await(stage));
    }

    @Test
    void shouldBeginTransactionWithBookmarks() {
        Connection connection = TestUtil.connectionMock(this.protocol);
        Bookmark bookmark = InternalBookmark.parse((String)"neo4j:bookmark:v1:tx100");
        CompletionStage stage = this.protocol.beginTransaction(connection, bookmark, TransactionConfig.empty());
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.eq((Object)new BeginMessage(bookmark, TransactionConfig.empty(), DatabaseNameUtil.defaultDatabase(), AccessMode.WRITE, null)), (ResponseHandler)ArgumentMatchers.any(BeginTxResponseHandler.class));
        Assertions.assertNull(TestUtil.await(stage));
    }

    @Test
    void shouldBeginTransactionWithConfig() {
        Connection connection = TestUtil.connectionMock(this.protocol);
        CompletionStage stage = this.protocol.beginTransaction(connection, InternalBookmark.empty(), this.txConfig);
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.eq((Object)new BeginMessage(InternalBookmark.empty(), this.txConfig, DatabaseNameUtil.defaultDatabase(), AccessMode.WRITE, null)), (ResponseHandler)ArgumentMatchers.any(BeginTxResponseHandler.class));
        Assertions.assertNull(TestUtil.await(stage));
    }

    @Test
    void shouldBeginTransactionWithBookmarksAndConfig() {
        Connection connection = TestUtil.connectionMock(this.protocol);
        Bookmark bookmark = InternalBookmark.parse((String)"neo4j:bookmark:v1:tx4242");
        CompletionStage stage = this.protocol.beginTransaction(connection, bookmark, this.txConfig);
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.eq((Object)new BeginMessage(bookmark, this.txConfig, DatabaseNameUtil.defaultDatabase(), AccessMode.WRITE, null)), (ResponseHandler)ArgumentMatchers.any(BeginTxResponseHandler.class));
        Assertions.assertNull(TestUtil.await(stage));
    }

    @Test
    void shouldCommitTransaction() {
        String bookmarkString = "neo4j:bookmark:v1:tx4242";
        Connection connection = TestUtil.connectionMock(this.protocol);
        Mockito.when((Object)connection.protocol()).thenReturn((Object)this.protocol);
        ((Connection)Mockito.doAnswer(invocation -> {
            ResponseHandler commitHandler = (ResponseHandler)invocation.getArgument(1);
            commitHandler.onSuccess(Collections.singletonMap("bookmark", Values.value((String)bookmarkString)));
            return null;
        }).when((Object)connection)).writeAndFlush((Message)ArgumentMatchers.eq((Object)CommitMessage.COMMIT), (ResponseHandler)ArgumentMatchers.any());
        CompletionStage stage = this.protocol.commitTransaction(connection);
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.eq((Object)CommitMessage.COMMIT), (ResponseHandler)ArgumentMatchers.any(CommitTxResponseHandler.class));
        Assertions.assertEquals((Object)InternalBookmark.parse((String)bookmarkString), TestUtil.await(stage));
    }

    @Test
    void shouldRollbackTransaction() {
        Connection connection = TestUtil.connectionMock(this.protocol);
        CompletionStage stage = this.protocol.rollbackTransaction(connection);
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.eq((Object)RollbackMessage.ROLLBACK), (ResponseHandler)ArgumentMatchers.any(RollbackTxResponseHandler.class));
        Assertions.assertNull(TestUtil.await(stage));
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInAutoCommitTransactionAndWaitForRunResponse(AccessMode mode) throws Exception {
        this.testRunAndWaitForRunResponse(true, TransactionConfig.empty(), mode);
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInAutoCommitWithConfigTransactionAndWaitForRunResponse(AccessMode mode) throws Exception {
        this.testRunAndWaitForRunResponse(true, this.txConfig, mode);
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInAutoCommitTransactionAndWaitForSuccessRunResponse(AccessMode mode) throws Exception {
        this.testSuccessfulRunInAutoCommitTxWithWaitingForResponse(InternalBookmark.empty(), TransactionConfig.empty(), mode);
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInAutoCommitTransactionWithBookmarkAndConfigAndWaitForSuccessRunResponse(AccessMode mode) throws Exception {
        this.testSuccessfulRunInAutoCommitTxWithWaitingForResponse(InternalBookmark.parse((String)"neo4j:bookmark:v1:tx65"), this.txConfig, mode);
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInAutoCommitTransactionAndWaitForFailureRunResponse(AccessMode mode) throws Exception {
        this.testFailedRunInAutoCommitTxWithWaitingForResponse(InternalBookmark.empty(), TransactionConfig.empty(), mode);
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInAutoCommitTransactionWithBookmarkAndConfigAndWaitForFailureRunResponse(AccessMode mode) throws Exception {
        this.testFailedRunInAutoCommitTxWithWaitingForResponse(InternalBookmark.parse((String)"neo4j:bookmark:v1:tx163"), this.txConfig, mode);
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInUnmanagedTransactionAndWaitForRunResponse(AccessMode mode) throws Exception {
        this.testRunAndWaitForRunResponse(false, TransactionConfig.empty(), mode);
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInUnmanagedTransactionAndWaitForSuccessRunResponse(AccessMode mode) throws Exception {
        this.testRunInUnmanagedTransactionAndWaitForRunResponse(true, mode);
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldRunInUnmanagedTransactionAndWaitForFailureRunResponse(AccessMode mode) throws Exception {
        this.testRunInUnmanagedTransactionAndWaitForRunResponse(false, mode);
    }

    @Test
    void databaseNameInBeginTransaction() {
        this.testDatabaseNameSupport(false);
    }

    @Test
    void databaseNameForAutoCommitTransactions() {
        this.testDatabaseNameSupport(true);
    }

    @Test
    void shouldNotSupportDatabaseNameInBeginTransaction() {
        CompletionStage txStage = this.protocol.beginTransaction(TestUtil.connectionMock("foo", this.protocol), InternalBookmark.empty(), TransactionConfig.empty());
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> TestUtil.await(txStage));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Database name parameter for selecting database is not supported"));
    }

    @Test
    void shouldNotSupportDatabaseNameForAutoCommitTransactions() {
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> this.protocol.runInAutoCommitTransaction(TestUtil.connectionMock("foo", this.protocol), new Query("RETURN 1"), BookmarkHolder.NO_OP, TransactionConfig.empty(), -1L));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Database name parameter for selecting database is not supported"));
    }

    protected void testDatabaseNameSupport(boolean autoCommitTx) {
        ClientException e;
        if (autoCommitTx) {
            e = (ClientException)Assertions.assertThrows(ClientException.class, () -> this.protocol.runInAutoCommitTransaction(TestUtil.connectionMock("foo", this.protocol), new Query("RETURN 1"), BookmarkHolder.NO_OP, TransactionConfig.empty(), -1L));
        } else {
            CompletionStage txStage = this.protocol.beginTransaction(TestUtil.connectionMock("foo", this.protocol), InternalBookmark.empty(), TransactionConfig.empty());
            e = (ClientException)Assertions.assertThrows(ClientException.class, () -> TestUtil.await(txStage));
        }
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Database name parameter for selecting database is not supported"));
    }

    protected void testRunInUnmanagedTransactionAndWaitForRunResponse(boolean success, AccessMode mode) throws Exception {
        Connection connection = TestUtil.connectionMock(mode, this.protocol);
        CompletableFuture cursorFuture = this.protocol.runInUnmanagedTransaction(connection, QUERY, (UnmanagedTransaction)Mockito.mock(UnmanagedTransaction.class), -1L).asyncResult().toCompletableFuture();
        ResponseHandler runResponseHandler = BoltProtocolV3Test.verifyRunInvoked((Connection)connection, (boolean)false, (Bookmark)InternalBookmark.empty(), (TransactionConfig)TransactionConfig.empty(), (AccessMode)mode).runHandler;
        Assertions.assertFalse((boolean)cursorFuture.isDone());
        RuntimeException error = new RuntimeException();
        if (success) {
            runResponseHandler.onSuccess(Collections.emptyMap());
        } else {
            runResponseHandler.onFailure((Throwable)error);
        }
        Assertions.assertTrue((boolean)cursorFuture.isDone());
        if (success) {
            Assertions.assertNotNull(TestUtil.await(((AsyncResultCursor)cursorFuture.get()).mapSuccessfulRunCompletionAsync()));
        } else {
            Throwable actual = Assertions.assertThrows(error.getClass(), () -> TestUtil.await(((AsyncResultCursor)cursorFuture.get()).mapSuccessfulRunCompletionAsync()));
            Assertions.assertSame((Object)error, (Object)actual);
        }
    }

    protected void testRunAndWaitForRunResponse(boolean autoCommitTx, TransactionConfig config, AccessMode mode) throws Exception {
        CompletionStage cursorStage;
        Connection connection = TestUtil.connectionMock(mode, this.protocol);
        Bookmark initialBookmark = InternalBookmark.parse((String)"neo4j:bookmark:v1:tx987");
        if (autoCommitTx) {
            DefaultBookmarkHolder bookmarkHolder = new DefaultBookmarkHolder(initialBookmark);
            cursorStage = this.protocol.runInAutoCommitTransaction(connection, QUERY, (BookmarkHolder)bookmarkHolder, config, -1L).asyncResult();
        } else {
            cursorStage = this.protocol.runInUnmanagedTransaction(connection, QUERY, (UnmanagedTransaction)Mockito.mock(UnmanagedTransaction.class), -1L).asyncResult();
        }
        CompletableFuture cursorFuture = cursorStage.toCompletableFuture();
        Assertions.assertFalse((boolean)cursorFuture.isDone());
        Bookmark bookmark = autoCommitTx ? initialBookmark : InternalBookmark.empty();
        ResponseHandler runResponseHandler = BoltProtocolV3Test.verifyRunInvoked((Connection)connection, (boolean)autoCommitTx, (Bookmark)bookmark, (TransactionConfig)config, (AccessMode)mode).runHandler;
        runResponseHandler.onSuccess(Collections.emptyMap());
        Assertions.assertTrue((boolean)cursorFuture.isDone());
        Assertions.assertNotNull(cursorFuture.get());
    }

    protected void testSuccessfulRunInAutoCommitTxWithWaitingForResponse(Bookmark bookmark, TransactionConfig config, AccessMode mode) throws Exception {
        Connection connection = TestUtil.connectionMock(mode, this.protocol);
        DefaultBookmarkHolder bookmarkHolder = new DefaultBookmarkHolder(bookmark);
        CompletableFuture cursorFuture = this.protocol.runInAutoCommitTransaction(connection, QUERY, (BookmarkHolder)bookmarkHolder, config, -1L).asyncResult().toCompletableFuture();
        Assertions.assertFalse((boolean)cursorFuture.isDone());
        ResponseHandlers handlers = BoltProtocolV3Test.verifyRunInvoked(connection, true, bookmark, config, mode);
        String newBookmarkValue = "neo4j:bookmark:v1:tx98765";
        handlers.runHandler.onSuccess(Collections.emptyMap());
        handlers.pullAllHandler.onSuccess(Collections.singletonMap("bookmark", Values.value((String)newBookmarkValue)));
        Assertions.assertEquals((Object)InternalBookmark.parse((String)newBookmarkValue), (Object)bookmarkHolder.getBookmark());
        Assertions.assertTrue((boolean)cursorFuture.isDone());
        Assertions.assertNotNull(cursorFuture.get());
    }

    protected void testFailedRunInAutoCommitTxWithWaitingForResponse(Bookmark bookmark, TransactionConfig config, AccessMode mode) throws Exception {
        Connection connection = TestUtil.connectionMock(mode, this.protocol);
        DefaultBookmarkHolder bookmarkHolder = new DefaultBookmarkHolder(bookmark);
        CompletableFuture cursorFuture = this.protocol.runInAutoCommitTransaction(connection, QUERY, (BookmarkHolder)bookmarkHolder, config, -1L).asyncResult().toCompletableFuture();
        Assertions.assertFalse((boolean)cursorFuture.isDone());
        ResponseHandler runResponseHandler = BoltProtocolV3Test.verifyRunInvoked((Connection)connection, (boolean)true, (Bookmark)bookmark, (TransactionConfig)config, (AccessMode)mode).runHandler;
        RuntimeException error = new RuntimeException();
        runResponseHandler.onFailure((Throwable)error);
        Assertions.assertEquals((Object)bookmark, (Object)bookmarkHolder.getBookmark());
        Assertions.assertTrue((boolean)cursorFuture.isDone());
        Throwable actual = Assertions.assertThrows(error.getClass(), () -> TestUtil.await(((AsyncResultCursor)cursorFuture.get()).mapSuccessfulRunCompletionAsync()));
        Assertions.assertSame((Object)error, (Object)actual);
    }

    private static InternalAuthToken dummyAuthToken() {
        return (InternalAuthToken)AuthTokens.basic((String)"hello", (String)"world");
    }

    private static ResponseHandlers verifyRunInvoked(Connection connection, boolean session, Bookmark bookmark, TransactionConfig config, AccessMode mode) {
        ArgumentCaptor runHandlerCaptor = ArgumentCaptor.forClass(ResponseHandler.class);
        ArgumentCaptor pullAllHandlerCaptor = ArgumentCaptor.forClass(ResponseHandler.class);
        RunWithMetadataMessage expectedMessage = session ? RunWithMetadataMessage.autoCommitTxRunMessage((Query)QUERY, (TransactionConfig)config, (DatabaseName)DatabaseNameUtil.defaultDatabase(), (AccessMode)mode, (Bookmark)bookmark, null) : RunWithMetadataMessage.unmanagedTxRunMessage((Query)QUERY);
        ((Connection)Mockito.verify((Object)connection)).write((Message)ArgumentMatchers.eq((Object)expectedMessage), (ResponseHandler)runHandlerCaptor.capture());
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.eq((Object)PullAllMessage.PULL_ALL), (ResponseHandler)pullAllHandlerCaptor.capture());
        MatcherAssert.assertThat((Object)((ResponseHandler)runHandlerCaptor.getValue()), (Matcher)Matchers.instanceOf(RunResponseHandler.class));
        MatcherAssert.assertThat((Object)((ResponseHandler)pullAllHandlerCaptor.getValue()), (Matcher)Matchers.instanceOf(PullAllResponseHandler.class));
        return new ResponseHandlers((ResponseHandler)runHandlerCaptor.getValue(), (ResponseHandler)pullAllHandlerCaptor.getValue());
    }

    private static class ResponseHandlers {
        final ResponseHandler runHandler;
        final ResponseHandler pullAllHandler;

        ResponseHandlers(ResponseHandler runHandler, ResponseHandler pullAllHandler) {
            this.runHandler = runHandler;
            this.pullAllHandler = pullAllHandler;
        }
    }
}

