/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.messaging.request.TransactionMetadataBuilder;

public class TransactionMetadataBuilderTest {
    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldHaveCorrectMetadata(AccessMode mode) {
        Bookmark bookmark = InternalBookmark.parse(new HashSet<String>(Arrays.asList("neo4j:bookmark:v1:tx11", "neo4j:bookmark:v1:tx52")));
        HashMap<String, Value> txMetadata = new HashMap<String, Value>();
        txMetadata.put("foo", Values.value((String)"bar"));
        txMetadata.put("baz", Values.value((int)111));
        txMetadata.put("time", Values.value((LocalDateTime)LocalDateTime.now()));
        Duration txTimeout = Duration.ofSeconds(7L);
        Map metadata = TransactionMetadataBuilder.buildMetadata((Duration)txTimeout, txMetadata, (DatabaseName)DatabaseNameUtil.defaultDatabase(), (AccessMode)mode, (Bookmark)bookmark, null);
        HashMap<String, Value> expectedMetadata = new HashMap<String, Value>();
        expectedMetadata.put("bookmarks", Values.value((Object)bookmark.values()));
        expectedMetadata.put("tx_timeout", Values.value((int)7000));
        expectedMetadata.put("tx_metadata", Values.value(txMetadata));
        if (mode == AccessMode.READ) {
            expectedMetadata.put("mode", Values.value((String)"r"));
        }
        Assertions.assertEquals(expectedMetadata, (Object)metadata);
    }

    @ParameterizedTest
    @ValueSource(strings={"", "foo", "data"})
    void shouldHaveCorrectMetadataForDatabaseName(String databaseName) {
        Bookmark bookmark = InternalBookmark.parse(new HashSet<String>(Arrays.asList("neo4j:bookmark:v1:tx11", "neo4j:bookmark:v1:tx52")));
        HashMap<String, Value> txMetadata = new HashMap<String, Value>();
        txMetadata.put("foo", Values.value((String)"bar"));
        txMetadata.put("baz", Values.value((int)111));
        txMetadata.put("time", Values.value((LocalDateTime)LocalDateTime.now()));
        Duration txTimeout = Duration.ofSeconds(7L);
        Map metadata = TransactionMetadataBuilder.buildMetadata((Duration)txTimeout, txMetadata, (DatabaseName)DatabaseNameUtil.database((String)databaseName), (AccessMode)AccessMode.WRITE, (Bookmark)bookmark, null);
        HashMap<String, Value> expectedMetadata = new HashMap<String, Value>();
        expectedMetadata.put("bookmarks", Values.value((Object)bookmark.values()));
        expectedMetadata.put("tx_timeout", Values.value((int)7000));
        expectedMetadata.put("tx_metadata", Values.value(txMetadata));
        expectedMetadata.put("db", Values.value((String)databaseName));
        Assertions.assertEquals(expectedMetadata, (Object)metadata);
    }

    @Test
    void shouldNotHaveMetadataForDatabaseNameWhenIsNull() {
        Map metadata = TransactionMetadataBuilder.buildMetadata(null, null, (DatabaseName)DatabaseNameUtil.defaultDatabase(), (AccessMode)AccessMode.WRITE, null, null);
        Assertions.assertTrue((boolean)metadata.isEmpty());
    }
}

