/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.encode;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.ValuePacker;
import org.neo4j.driver.internal.messaging.encode.RouteMessageEncoder;
import org.neo4j.driver.internal.messaging.request.RouteMessage;

class RouteMessageEncoderTest {
    private final ValuePacker packer = (ValuePacker)Mockito.mock(ValuePacker.class);
    private final RouteMessageEncoder encoder = new RouteMessageEncoder();

    RouteMessageEncoderTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j"})
    @NullSource
    void shouldEncodeRouteMessage(String databaseName) throws IOException {
        Map<String, Value> routingContext = this.getRoutingContext();
        this.encoder.encode((Message)new RouteMessage(this.getRoutingContext(), null, databaseName, null), this.packer);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.packer});
        ((ValuePacker)inOrder.verify((Object)this.packer)).packStructHeader(3, (byte)102);
        ((ValuePacker)inOrder.verify((Object)this.packer)).pack(routingContext);
        ((ValuePacker)inOrder.verify((Object)this.packer)).pack(Values.value(Collections.emptyList()));
        ((ValuePacker)inOrder.verify((Object)this.packer)).pack(databaseName);
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j"})
    @NullSource
    void shouldEncodeRouteMessageWithBookmark(String databaseName) throws IOException {
        Map<String, Value> routingContext = this.getRoutingContext();
        Bookmark bookmark = InternalBookmark.parse((String)"somebookmark");
        this.encoder.encode((Message)new RouteMessage(this.getRoutingContext(), bookmark, databaseName, null), this.packer);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.packer});
        ((ValuePacker)inOrder.verify((Object)this.packer)).packStructHeader(3, (byte)102);
        ((ValuePacker)inOrder.verify((Object)this.packer)).pack(routingContext);
        ((ValuePacker)inOrder.verify((Object)this.packer)).pack(Values.value((Object)bookmark.values()));
        ((ValuePacker)inOrder.verify((Object)this.packer)).pack(databaseName);
    }

    @Test
    void shouldThrowIllegalArgumentIfMessageIsNotRouteMessage() {
        Message message = (Message)Mockito.mock(Message.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.encoder.encode(message, this.packer));
    }

    private Map<String, Value> getRoutingContext() {
        HashMap<String, Value> routingContext = new HashMap<String, Value>();
        routingContext.put("ip", Values.value((String)"127.0.0.1"));
        return routingContext;
    }
}

