/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;

class BoltProtocolVersionTest {
    BoltProtocolVersionTest() {
    }

    @ParameterizedTest(name="V{0}.{1}")
    @CsvSource(value={"3, 0", "4, 0", "4, 1", "4, 2", "100, 100", "255, 255", "0, 0"})
    void shouldParseVersion(int major, int minor) {
        BoltProtocolVersion protocolVersion = new BoltProtocolVersion(major, minor);
        BoltProtocolVersion testVersion = BoltProtocolVersion.fromRawBytes((int)protocolVersion.toInt());
        Assertions.assertEquals((long)major, (long)testVersion.getMajorVersion());
        Assertions.assertEquals((long)minor, (long)testVersion.getMinorVersion());
    }

    @ParameterizedTest(name="V{0}.{1} comparedTo V{2}.{3}")
    @CsvSource(value={"1, 3, 25, 21, -1", "4, 0, 4, 0, 0", "4, 1, 4, 0, 1", "0, 1, 0, 2, -1"})
    void shouldCompareTo(int majorA, int minorA, int majorB, int minorB, int expectedResult) {
        BoltProtocolVersion versionA = new BoltProtocolVersion(majorA, minorA);
        BoltProtocolVersion versionB = new BoltProtocolVersion(majorB, minorB);
        Assertions.assertEquals((int)expectedResult, (int)versionA.compareTo(versionB));
    }

    @ParameterizedTest(name="V{0}.{1} toIntRange V{2}.{3}")
    @CsvSource(value={"1, 0, 1, 0, 0x000001", "4, 3, 4, 2, 0x010304", "4, 3, 4, 1, 0x020304", "4, 3, 4, 0, 0x030304", "100, 100, 100, 0, 0x646464", "255, 255, 255, 0, 0xFFFFFF"})
    void shouldOutputCorrectIntRange(int majorA, int minorA, int majorB, int minorB, int expectedResult) {
        BoltProtocolVersion versionA = new BoltProtocolVersion(majorA, minorA);
        BoltProtocolVersion versionB = new BoltProtocolVersion(majorB, minorB);
        Assertions.assertEquals((int)expectedResult, (int)versionA.toIntRange(versionB));
    }

    @ParameterizedTest(name="V{0}.{1} toIntRange V{2}.{3}")
    @CsvSource(value={"1, 0, 2, 0", "2, 0, 1, 0", "4, 3, 4, 5", "4, 6, 3, 7", "3, 7, 4, 6", "255, 255, 100, 0"})
    void shouldThrowsIllegalArgumentExceptionForIncorrectIntRange(int majorA, int minorA, int majorB, int minorB) {
        BoltProtocolVersion versionA = new BoltProtocolVersion(majorA, minorA);
        BoltProtocolVersion versionB = new BoltProtocolVersion(majorB, minorB);
        Assertions.assertThrows(IllegalArgumentException.class, () -> versionA.toIntRange(versionB));
    }

    @Test
    void shouldOutputCorrectLongFormatForMajorVersionOnly() {
        BoltProtocolVersion version = new BoltProtocolVersion(4, 0);
        Assertions.assertEquals((long)4L, (long)version.toInt());
    }

    @Test
    void shouldOutputCorrectLongFormatForMajorAndMinorVersion() {
        BoltProtocolVersion version = new BoltProtocolVersion(4, 1);
        Assertions.assertEquals((long)260L, (long)version.toInt());
    }

    @Test
    void shouldOutputFormattedString() {
        BoltProtocolVersion version = new BoltProtocolVersion(4, 1);
        Assertions.assertEquals((Object)"4.1", (Object)version.toString());
    }
}

