/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.logging;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.Logger;
import org.neo4j.driver.internal.logging.PrefixedLogger;

class PrefixedLoggerTest {
    private static final String PREFIX = "Output";
    private static final String MESSAGE = "Hello World!";
    private static final Exception ERROR = new Exception();

    PrefixedLoggerTest() {
    }

    @Test
    void shouldThrowWhenDelegateIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new PrefixedLogger(null));
    }

    @Test
    void shouldAllowNullPrefix() {
        Assertions.assertNotNull((Object)new PrefixedLogger(null, PrefixedLoggerTest.newLoggerMock()));
    }

    @Test
    void shouldDelegateIsDebugEnabled() {
        Logger delegate = PrefixedLoggerTest.newLoggerMock(true, false);
        PrefixedLogger logger = new PrefixedLogger(delegate);
        Assertions.assertTrue((boolean)logger.isDebugEnabled());
        ((Logger)Mockito.verify((Object)delegate)).isDebugEnabled();
    }

    @Test
    void shouldDelegateIsTraceEnabled() {
        Logger delegate = PrefixedLoggerTest.newLoggerMock(false, true);
        PrefixedLogger logger = new PrefixedLogger(delegate);
        Assertions.assertTrue((boolean)logger.isTraceEnabled());
        ((Logger)Mockito.verify((Object)delegate)).isTraceEnabled();
    }

    @Test
    void shouldNotDelegateDebugLogWhenDebugDisabled() {
        Logger delegate = PrefixedLoggerTest.newLoggerMock();
        PrefixedLogger logger = new PrefixedLogger(delegate);
        logger.debug(MESSAGE, new Object[0]);
        ((Logger)Mockito.verify((Object)delegate, (VerificationMode)Mockito.never())).debug(ArgumentMatchers.anyString(), (Object[])ArgumentMatchers.any(Object[].class));
    }

    @Test
    void shouldNotDelegateDebugLogWithThrowableWhenDebugDisabled() {
        Logger delegate = PrefixedLoggerTest.newLoggerMock();
        PrefixedLogger logger = new PrefixedLogger(delegate);
        logger.debug(MESSAGE, (Throwable)Mockito.mock(Throwable.class));
        ((Logger)Mockito.verify((Object)delegate, (VerificationMode)Mockito.never())).debug(ArgumentMatchers.anyString(), (Throwable)ArgumentMatchers.any(Throwable.class));
    }

    @Test
    void shouldNotDelegateTraceLogWhenTraceDisabled() {
        Logger delegate = PrefixedLoggerTest.newLoggerMock();
        PrefixedLogger logger = new PrefixedLogger(delegate);
        logger.trace(MESSAGE, new Object[0]);
        ((Logger)Mockito.verify((Object)delegate, (VerificationMode)Mockito.never())).trace(ArgumentMatchers.anyString(), (Object[])ArgumentMatchers.any());
    }

    @Test
    void shouldDelegateErrorMessageWhenNoPrefix() {
        Logger delegate = PrefixedLoggerTest.newLoggerMock();
        PrefixedLogger logger = new PrefixedLogger(delegate);
        logger.error(MESSAGE, (Throwable)ERROR);
        ((Logger)Mockito.verify((Object)delegate)).error(MESSAGE, (Throwable)ERROR);
    }

    @Test
    void shouldDelegateInfoMessageWhenNoPrefix() {
        Logger delegate = PrefixedLoggerTest.newLoggerMock();
        PrefixedLogger logger = new PrefixedLogger(delegate);
        logger.info(MESSAGE, new Object[0]);
        ((Logger)Mockito.verify((Object)delegate)).info(MESSAGE, new Object[0]);
    }

    @Test
    void shouldDelegateWarnMessageWhenNoPrefix() {
        Logger delegate = PrefixedLoggerTest.newLoggerMock();
        PrefixedLogger logger = new PrefixedLogger(delegate);
        logger.warn(MESSAGE, new Object[0]);
        ((Logger)Mockito.verify((Object)delegate)).warn(MESSAGE, new Object[0]);
    }

    @Test
    void shouldDelegateWarnMessageWithoutErrorWhenNoPrefix() {
        Logger delegate = PrefixedLoggerTest.newLoggerMock();
        PrefixedLogger logger = new PrefixedLogger(delegate);
        Exception cause = new Exception();
        logger.warn(MESSAGE, (Throwable)cause);
        ((Logger)Mockito.verify((Object)delegate)).warn(MESSAGE, (Throwable)cause);
    }

    @Test
    void shouldDelegateDebugMessageWhenNoPrefix() {
        Logger delegate = PrefixedLoggerTest.newLoggerMock(true, false);
        PrefixedLogger logger = new PrefixedLogger(delegate);
        logger.debug(MESSAGE, new Object[0]);
        ((Logger)Mockito.verify((Object)delegate)).debug(MESSAGE, new Object[0]);
    }

    @Test
    void shouldDelegateTraceMessageWhenNoPrefix() {
        Logger delegate = PrefixedLoggerTest.newLoggerMock(false, true);
        PrefixedLogger logger = new PrefixedLogger(delegate);
        logger.trace(MESSAGE, new Object[0]);
        ((Logger)Mockito.verify((Object)delegate)).trace(MESSAGE, new Object[0]);
    }

    @Test
    void shouldDelegateErrorMessageWithPrefix() {
        Logger delegate = PrefixedLoggerTest.newLoggerMock();
        PrefixedLogger logger = new PrefixedLogger(PREFIX, delegate);
        logger.error(MESSAGE, (Throwable)ERROR);
        ((Logger)Mockito.verify((Object)delegate)).error("Output Hello World!", (Throwable)ERROR);
    }

    @Test
    void shouldDelegateInfoMessageWithPrefix() {
        Logger delegate = PrefixedLoggerTest.newLoggerMock();
        PrefixedLogger logger = new PrefixedLogger(PREFIX, delegate);
        logger.info(MESSAGE, new Object[0]);
        ((Logger)Mockito.verify((Object)delegate)).info("Output Hello World!", new Object[0]);
    }

    @Test
    void shouldDelegateWarnMessageWithPrefix() {
        Logger delegate = PrefixedLoggerTest.newLoggerMock();
        PrefixedLogger logger = new PrefixedLogger(PREFIX, delegate);
        logger.warn(MESSAGE, new Object[0]);
        ((Logger)Mockito.verify((Object)delegate)).warn("Output Hello World!", new Object[0]);
    }

    @Test
    void shouldDelegateWarnMessageWithErrorWithPrefix() {
        Logger delegate = PrefixedLoggerTest.newLoggerMock();
        PrefixedLogger logger = new PrefixedLogger(PREFIX, delegate);
        Exception cause = new Exception();
        logger.warn(MESSAGE, (Throwable)cause);
        ((Logger)Mockito.verify((Object)delegate)).warn("Output Hello World!", (Throwable)cause);
    }

    @Test
    void shouldDelegateDebugMessageWithPrefix() {
        Logger delegate = PrefixedLoggerTest.newLoggerMock(true, false);
        PrefixedLogger logger = new PrefixedLogger(PREFIX, delegate);
        logger.debug(MESSAGE, new Object[0]);
        ((Logger)Mockito.verify((Object)delegate)).debug("Output Hello World!", new Object[0]);
    }

    @Test
    void shouldDelegateTraceMessageWithPrefix() {
        Logger delegate = PrefixedLoggerTest.newLoggerMock(false, true);
        PrefixedLogger logger = new PrefixedLogger(PREFIX, delegate);
        logger.trace(MESSAGE, new Object[0]);
        ((Logger)Mockito.verify((Object)delegate)).trace("Output Hello World!", new Object[0]);
    }

    private static Logger newLoggerMock() {
        return PrefixedLoggerTest.newLoggerMock(false, false);
    }

    private static Logger newLoggerMock(boolean debugEnabled, boolean traceEnabled) {
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logger.isDebugEnabled()).thenReturn((Object)debugEnabled);
        Mockito.when((Object)logger.isTraceEnabled()).thenReturn((Object)traceEnabled);
        return logger;
    }
}

