/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers.pulln;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.Query;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.handlers.PullAllResponseHandlerTestBase;
import org.neo4j.driver.internal.handlers.PullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.AutoPullResponseHandler;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.request.PullMessage;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.value.BooleanValue;

class AutoPullResponseHandlerTest
extends PullAllResponseHandlerTestBase<AutoPullResponseHandler> {
    AutoPullResponseHandlerTest() {
    }

    @Override
    protected AutoPullResponseHandler newHandler(Query query, List<String> queryKeys, Connection connection) {
        RunResponseHandler runResponseHandler = new RunResponseHandler(new CompletableFuture(), BoltProtocolV3.METADATA_EXTRACTOR, (Connection)Mockito.mock(Connection.class), null);
        runResponseHandler.onSuccess(Collections.singletonMap("fields", Values.value(queryKeys)));
        AutoPullResponseHandler handler = new AutoPullResponseHandler(query, runResponseHandler, connection, BoltProtocolV3.METADATA_EXTRACTOR, (PullResponseCompletionListener)Mockito.mock(PullResponseCompletionListener.class), 1000L);
        handler.prePopulateRecords();
        return handler;
    }

    protected AutoPullResponseHandler newHandler(Query query, Connection connection, long fetchSize) {
        RunResponseHandler runResponseHandler = new RunResponseHandler(new CompletableFuture(), BoltProtocolV3.METADATA_EXTRACTOR, (Connection)Mockito.mock(Connection.class), null);
        runResponseHandler.onSuccess(Collections.emptyMap());
        AutoPullResponseHandler handler = new AutoPullResponseHandler(query, runResponseHandler, connection, BoltProtocolV3.METADATA_EXTRACTOR, (PullResponseCompletionListener)Mockito.mock(PullResponseCompletionListener.class), fetchSize);
        handler.prePopulateRecords();
        return handler;
    }

    @Test
    void shouldKeepRequestingWhenBetweenRange() {
        Connection connection = this.connectionMock();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{connection});
        AutoPullResponseHandler handler = this.newHandler(new Query("RETURN 1"), connection, 4L);
        HashMap<String, BooleanValue> metaData = new HashMap<String, BooleanValue>(1);
        metaData.put("has_more", BooleanValue.TRUE);
        ((Connection)inOrder.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(PullMessage.class), (ResponseHandler)ArgumentMatchers.any());
        handler.onRecord(Values.values((Object[])new Object[]{1}));
        handler.onRecord(Values.values((Object[])new Object[]{2}));
        handler.onSuccess(metaData);
        ((Connection)inOrder.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(), (ResponseHandler)ArgumentMatchers.any());
    }

    @Test
    void shouldStopRequestingWhenOverMaxWatermark() {
        Connection connection = this.connectionMock();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{connection});
        AutoPullResponseHandler handler = this.newHandler(new Query("RETURN 1"), connection, 4L);
        HashMap<String, BooleanValue> metaData = new HashMap<String, BooleanValue>(1);
        metaData.put("has_more", BooleanValue.TRUE);
        ((Connection)inOrder.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(PullMessage.class), (ResponseHandler)ArgumentMatchers.any());
        handler.onRecord(Values.values((Object[])new Object[]{1}));
        handler.onRecord(Values.values((Object[])new Object[]{2}));
        handler.onRecord(Values.values((Object[])new Object[]{3}));
        handler.onSuccess(metaData);
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).writeAndFlush((Message)ArgumentMatchers.any(PullMessage.class), (ResponseHandler)ArgumentMatchers.any());
    }

    @Test
    void shouldRestartRequestingWhenMinimumWatermarkMet() {
        Connection connection = this.connectionMock();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{connection});
        AutoPullResponseHandler handler = this.newHandler(new Query("RETURN 1"), connection, 7L);
        HashMap<String, BooleanValue> metaData = new HashMap<String, BooleanValue>(1);
        metaData.put("has_more", BooleanValue.TRUE);
        ((Connection)inOrder.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(PullMessage.class), (ResponseHandler)ArgumentMatchers.any());
        handler.onRecord(Values.values((Object[])new Object[]{1}));
        handler.onRecord(Values.values((Object[])new Object[]{2}));
        handler.onRecord(Values.values((Object[])new Object[]{3}));
        handler.onRecord(Values.values((Object[])new Object[]{4}));
        handler.onRecord(Values.values((Object[])new Object[]{5}));
        handler.onSuccess(metaData);
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).writeAndFlush((Message)ArgumentMatchers.any(PullMessage.class), (ResponseHandler)ArgumentMatchers.any());
        handler.nextAsync();
        handler.nextAsync();
        handler.nextAsync();
        ((Connection)inOrder.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(PullMessage.class), (ResponseHandler)ArgumentMatchers.any());
    }

    @Test
    void shouldKeepRequestingMoreRecordsWhenPullAll() {
        Connection connection = this.connectionMock();
        AutoPullResponseHandler handler = this.newHandler(new Query("RETURN 1"), connection, -1L);
        HashMap<String, BooleanValue> metaData = new HashMap<String, BooleanValue>(1);
        metaData.put("has_more", BooleanValue.TRUE);
        handler.onRecord(Values.values((Object[])new Object[]{1}));
        handler.onSuccess(metaData);
        handler.onRecord(Values.values((Object[])new Object[]{2}));
        handler.onSuccess(metaData);
        handler.onRecord(Values.values((Object[])new Object[]{3}));
        handler.onSuccess(Collections.emptyMap());
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)3))).writeAndFlush((Message)ArgumentMatchers.any(PullMessage.class), (ResponseHandler)ArgumentMatchers.any());
    }

    @Test
    void shouldFunctionWhenHighAndLowWatermarksAreEqual() {
        Connection connection = this.connectionMock();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{connection});
        AutoPullResponseHandler handler = this.newHandler(new Query("RETURN 1"), connection, 1L);
        HashMap<String, BooleanValue> metaData = new HashMap<String, BooleanValue>(1);
        metaData.put("has_more", BooleanValue.TRUE);
        ((Connection)inOrder.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(PullMessage.class), (ResponseHandler)ArgumentMatchers.any());
        handler.onRecord(Values.values((Object[])new Object[]{1}));
        handler.onSuccess(metaData);
        ((Connection)inOrder.verify((Object)connection, Mockito.never())).writeAndFlush((Message)ArgumentMatchers.any(), (ResponseHandler)ArgumentMatchers.any());
        handler.nextAsync();
        ((Connection)inOrder.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(PullMessage.class), (ResponseHandler)ArgumentMatchers.any());
    }
}

