/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.handlers.ResetResponseHandler;

class ResetResponseHandlerTest {
    ResetResponseHandlerTest() {
    }

    @Test
    void shouldCompleteFutureOnSuccess() throws Exception {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ResetResponseHandler handler = ResetResponseHandlerTest.newHandler(future);
        Assertions.assertFalse((boolean)future.isDone());
        handler.onSuccess(Collections.emptyMap());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertNull((Object)future.get());
    }

    @Test
    void shouldCompleteFutureOnFailure() throws Exception {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ResetResponseHandler handler = ResetResponseHandlerTest.newHandler(future);
        Assertions.assertFalse((boolean)future.isDone());
        handler.onFailure((Throwable)new RuntimeException());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertNull((Object)future.get());
    }

    @Test
    void shouldThrowWhenOnRecord() {
        ResetResponseHandler handler = ResetResponseHandlerTest.newHandler(new CompletableFuture<Void>());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> handler.onRecord(Values.values((Object[])new Object[]{1, 2, 3})));
    }

    private static ResetResponseHandler newHandler(CompletableFuture<Void> future) {
        return new ResetResponseHandler((InboundMessageDispatcher)Mockito.mock(InboundMessageDispatcher.class), future);
    }

    private static ResetResponseHandler newHandler(InboundMessageDispatcher messageDispatcher, CompletableFuture<Void> future) {
        return new ResetResponseHandler(messageDispatcher, future);
    }
}

