/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.async.ImmutableConnectionContext;
import org.neo4j.driver.internal.cluster.Rediscovery;
import org.neo4j.driver.internal.cluster.RediscoveryImpl;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.cluster.RoutingTableHandler;
import org.neo4j.driver.internal.cluster.RoutingTableRegistry;
import org.neo4j.driver.internal.cluster.RoutingTableRegistryImpl;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.ClusterCompositionUtil;
import org.neo4j.driver.util.TestUtil;

class RoutingTableRegistryImplTest {
    RoutingTableRegistryImplTest() {
    }

    @Test
    void factoryShouldCreateARoutingTableWithSameDatabaseName() throws Throwable {
        Clock clock = Clock.SYSTEM;
        RoutingTableRegistryImpl.RoutingTableHandlerFactory factory = new RoutingTableRegistryImpl.RoutingTableHandlerFactory((ConnectionPool)Mockito.mock(ConnectionPool.class), (Rediscovery)Mockito.mock(RediscoveryImpl.class), clock, DevNullLogging.DEV_NULL_LOGGING, RoutingSettings.STALE_ROUTING_TABLE_PURGE_DELAY_MS);
        RoutingTableHandler handler = factory.newInstance(DatabaseNameUtil.database((String)"Molly"), null);
        RoutingTable table = handler.routingTable();
        MatcherAssert.assertThat((Object)table.database().description(), (Matcher)Matchers.equalTo((Object)"Molly"));
        MatcherAssert.assertThat((Object)table.routers().size(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)table.readers().size(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)table.writers().size(), (Matcher)Matchers.equalTo((Object)0));
        Assertions.assertTrue((boolean)table.isStaleFor(AccessMode.READ));
        Assertions.assertTrue((boolean)table.isStaleFor(AccessMode.WRITE));
    }

    @ParameterizedTest
    @ValueSource(strings={"system", "", "database", " molly "})
    void shouldCreateRoutingTableHandlerIfAbsentWhenFreshRoutingTable(String databaseName) throws Throwable {
        ConcurrentHashMap<DatabaseName, RoutingTableHandler> map = new ConcurrentHashMap<DatabaseName, RoutingTableHandler>();
        RoutingTableRegistryImpl.RoutingTableHandlerFactory factory = this.mockedHandlerFactory();
        RoutingTableRegistryImpl routingTables = this.newRoutingTables(map, factory);
        DatabaseName database = DatabaseNameUtil.database((String)databaseName);
        routingTables.ensureRoutingTable((ConnectionContext)new ImmutableConnectionContext(database, InternalBookmark.empty(), AccessMode.READ));
        Assertions.assertTrue((boolean)map.containsKey(database));
        ((RoutingTableRegistryImpl.RoutingTableHandlerFactory)Mockito.verify((Object)factory)).newInstance((DatabaseName)ArgumentMatchers.eq((Object)database), (RoutingTableRegistry)ArgumentMatchers.eq((Object)routingTables));
    }

    @ParameterizedTest
    @ValueSource(strings={"system", "", "database", " molly "})
    void shouldReturnExistingRoutingTableHandlerWhenFreshRoutingTable(String databaseName) throws Throwable {
        ConcurrentHashMap<DatabaseName, RoutingTableHandler> map = new ConcurrentHashMap<DatabaseName, RoutingTableHandler>();
        RoutingTableHandler handler = this.mockedRoutingTableHandler();
        DatabaseName database = DatabaseNameUtil.database((String)databaseName);
        map.put(database, handler);
        RoutingTableRegistryImpl.RoutingTableHandlerFactory factory = this.mockedHandlerFactory();
        RoutingTableRegistryImpl routingTables = this.newRoutingTables(map, factory);
        ImmutableConnectionContext context = new ImmutableConnectionContext(database, InternalBookmark.empty(), AccessMode.READ);
        RoutingTableHandler actual = (RoutingTableHandler)TestUtil.await(routingTables.ensureRoutingTable((ConnectionContext)context));
        ((RoutingTableHandler)Mockito.verify((Object)handler)).ensureRoutingTable((ConnectionContext)context);
        Assertions.assertEquals((Object)handler, (Object)actual);
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldReturnFreshRoutingTable(AccessMode mode) throws Throwable {
        ConcurrentHashMap map = new ConcurrentHashMap();
        RoutingTableHandler handler = this.mockedRoutingTableHandler();
        RoutingTableRegistryImpl.RoutingTableHandlerFactory factory = this.mockedHandlerFactory(handler);
        RoutingTableRegistryImpl routingTables = new RoutingTableRegistryImpl(map, factory, null, null, null, DevNullLogging.DEV_NULL_LOGGING);
        ImmutableConnectionContext context = new ImmutableConnectionContext(DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), mode);
        routingTables.ensureRoutingTable((ConnectionContext)context);
        ((RoutingTableHandler)Mockito.verify((Object)handler)).ensureRoutingTable((ConnectionContext)context);
    }

    @Test
    void shouldReturnServersInAllRoutingTables() throws Throwable {
        ConcurrentHashMap<DatabaseName, RoutingTableHandler> map = new ConcurrentHashMap<DatabaseName, RoutingTableHandler>();
        map.put(DatabaseNameUtil.database((String)"Apple"), this.mockedRoutingTableHandler(ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C));
        map.put(DatabaseNameUtil.database((String)"Banana"), this.mockedRoutingTableHandler(ClusterCompositionUtil.B, ClusterCompositionUtil.C, ClusterCompositionUtil.D));
        map.put(DatabaseNameUtil.database((String)"Orange"), this.mockedRoutingTableHandler(ClusterCompositionUtil.E, ClusterCompositionUtil.F, ClusterCompositionUtil.C));
        RoutingTableRegistryImpl.RoutingTableHandlerFactory factory = this.mockedHandlerFactory();
        RoutingTableRegistryImpl routingTables = new RoutingTableRegistryImpl(map, factory, null, null, null, DevNullLogging.DEV_NULL_LOGGING);
        Set servers = routingTables.allServers();
        MatcherAssert.assertThat((Object)servers, (Matcher)Matchers.containsInAnyOrder((Object[])new BoltServerAddress[]{ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C, ClusterCompositionUtil.D, ClusterCompositionUtil.E, ClusterCompositionUtil.F}));
    }

    @Test
    void shouldRemoveRoutingTableHandler() throws Throwable {
        ConcurrentHashMap<DatabaseName, RoutingTableHandler> map = new ConcurrentHashMap<DatabaseName, RoutingTableHandler>();
        map.put(DatabaseNameUtil.database((String)"Apple"), this.mockedRoutingTableHandler(ClusterCompositionUtil.A));
        map.put(DatabaseNameUtil.database((String)"Banana"), this.mockedRoutingTableHandler(ClusterCompositionUtil.B));
        map.put(DatabaseNameUtil.database((String)"Orange"), this.mockedRoutingTableHandler(ClusterCompositionUtil.C));
        RoutingTableRegistryImpl.RoutingTableHandlerFactory factory = this.mockedHandlerFactory();
        RoutingTableRegistryImpl routingTables = this.newRoutingTables(map, factory);
        routingTables.remove(DatabaseNameUtil.database((String)"Apple"));
        routingTables.remove(DatabaseNameUtil.database((String)"Banana"));
        MatcherAssert.assertThat((Object)routingTables.allServers(), (Matcher)Matchers.contains((Object[])new BoltServerAddress[]{ClusterCompositionUtil.C}));
    }

    @Test
    void shouldRemoveStaleRoutingTableHandlers() throws Throwable {
        ConcurrentHashMap<DatabaseName, RoutingTableHandler> map = new ConcurrentHashMap<DatabaseName, RoutingTableHandler>();
        map.put(DatabaseNameUtil.database((String)"Apple"), this.mockedRoutingTableHandler(ClusterCompositionUtil.A));
        map.put(DatabaseNameUtil.database((String)"Banana"), this.mockedRoutingTableHandler(ClusterCompositionUtil.B));
        map.put(DatabaseNameUtil.database((String)"Orange"), this.mockedRoutingTableHandler(ClusterCompositionUtil.C));
        RoutingTableRegistryImpl.RoutingTableHandlerFactory factory = this.mockedHandlerFactory();
        RoutingTableRegistryImpl routingTables = this.newRoutingTables(map, factory);
        routingTables.removeAged();
        MatcherAssert.assertThat((Object)routingTables.allServers(), (Matcher)Matchers.empty());
    }

    private RoutingTableHandler mockedRoutingTableHandler(BoltServerAddress ... servers) {
        RoutingTableHandler handler = (RoutingTableHandler)Mockito.mock(RoutingTableHandler.class);
        Mockito.when((Object)handler.servers()).thenReturn(new HashSet<BoltServerAddress>(Arrays.asList(servers)));
        Mockito.when((Object)handler.isRoutingTableAged()).thenReturn((Object)true);
        return handler;
    }

    private RoutingTableRegistryImpl newRoutingTables(ConcurrentMap<DatabaseName, RoutingTableHandler> handlers, RoutingTableRegistryImpl.RoutingTableHandlerFactory factory) {
        return new RoutingTableRegistryImpl(handlers, factory, null, null, null, DevNullLogging.DEV_NULL_LOGGING);
    }

    private RoutingTableRegistryImpl.RoutingTableHandlerFactory mockedHandlerFactory(RoutingTableHandler handler) {
        RoutingTableRegistryImpl.RoutingTableHandlerFactory factory = (RoutingTableRegistryImpl.RoutingTableHandlerFactory)Mockito.mock(RoutingTableRegistryImpl.RoutingTableHandlerFactory.class);
        Mockito.when((Object)factory.newInstance((DatabaseName)ArgumentMatchers.any(), (RoutingTableRegistry)ArgumentMatchers.any())).thenReturn((Object)handler);
        return factory;
    }

    private RoutingTableRegistryImpl.RoutingTableHandlerFactory mockedHandlerFactory() {
        return this.mockedHandlerFactory(this.mockedRoutingTableHandler());
    }

    private RoutingTableHandler mockedRoutingTableHandler() {
        RoutingTableHandler handler = (RoutingTableHandler)Mockito.mock(RoutingTableHandler.class);
        Mockito.when((Object)handler.ensureRoutingTable((ConnectionContext)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture((RoutingTable)Mockito.mock(RoutingTable.class)));
        return handler;
    }
}

