/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.async.ImmutableConnectionContext;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterCompositionLookupResult;
import org.neo4j.driver.internal.cluster.ClusterRoutingTable;
import org.neo4j.driver.internal.cluster.Rediscovery;
import org.neo4j.driver.internal.cluster.RediscoveryImpl;
import org.neo4j.driver.internal.cluster.RediscoveryUtil;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.cluster.RoutingTableHandler;
import org.neo4j.driver.internal.cluster.RoutingTableHandlerImpl;
import org.neo4j.driver.internal.cluster.RoutingTableRegistry;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.ClusterCompositionUtil;
import org.neo4j.driver.internal.util.FakeClock;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.util.TestUtil;

class RoutingTableHandlerTest {
    RoutingTableHandlerTest() {
    }

    @Test
    void shouldRemoveAddressFromRoutingTableOnConnectionFailure() {
        ClusterRoutingTable routingTable = new ClusterRoutingTable(DatabaseNameUtil.defaultDatabase(), (Clock)new FakeClock(), new BoltServerAddress[0]);
        routingTable.update(new ClusterComposition(42L, TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C), TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.C, ClusterCompositionUtil.E), TestUtil.asOrderedSet(ClusterCompositionUtil.B, ClusterCompositionUtil.D, ClusterCompositionUtil.F), null));
        RoutingTableHandler handler = RoutingTableHandlerTest.newRoutingTableHandler((RoutingTable)routingTable, RoutingTableHandlerTest.newRediscoveryMock(), RoutingTableHandlerTest.newConnectionPoolMock());
        handler.onConnectionFailure(ClusterCompositionUtil.B);
        Assertions.assertArrayEquals((Object[])new BoltServerAddress[]{ClusterCompositionUtil.A, ClusterCompositionUtil.C}, (Object[])routingTable.readers().toArray());
        Assertions.assertArrayEquals((Object[])new BoltServerAddress[]{ClusterCompositionUtil.A, ClusterCompositionUtil.C, ClusterCompositionUtil.E}, (Object[])routingTable.writers().toArray());
        Assertions.assertArrayEquals((Object[])new BoltServerAddress[]{ClusterCompositionUtil.D, ClusterCompositionUtil.F}, (Object[])routingTable.routers().toArray());
        handler.onConnectionFailure(ClusterCompositionUtil.A);
        Assertions.assertArrayEquals((Object[])new BoltServerAddress[]{ClusterCompositionUtil.C}, (Object[])routingTable.readers().toArray());
        Assertions.assertArrayEquals((Object[])new BoltServerAddress[]{ClusterCompositionUtil.C, ClusterCompositionUtil.E}, (Object[])routingTable.writers().toArray());
        Assertions.assertArrayEquals((Object[])new BoltServerAddress[]{ClusterCompositionUtil.D, ClusterCompositionUtil.F}, (Object[])routingTable.routers().toArray());
    }

    @Test
    void acquireShouldUpdateRoutingTableWhenKnownRoutingTableIsStale() {
        BoltServerAddress initialRouter = new BoltServerAddress("initialRouter", 1);
        BoltServerAddress reader1 = new BoltServerAddress("reader-1", 2);
        BoltServerAddress reader2 = new BoltServerAddress("reader-1", 3);
        BoltServerAddress writer1 = new BoltServerAddress("writer-1", 4);
        BoltServerAddress router1 = new BoltServerAddress("router-1", 5);
        ConnectionPool connectionPool = RoutingTableHandlerTest.newConnectionPoolMock();
        ClusterRoutingTable routingTable = new ClusterRoutingTable(DatabaseNameUtil.defaultDatabase(), (Clock)new FakeClock(), new BoltServerAddress[]{initialRouter});
        LinkedHashSet<BoltServerAddress> readers = new LinkedHashSet<BoltServerAddress>(Arrays.asList(reader1, reader2));
        LinkedHashSet<BoltServerAddress> writers = new LinkedHashSet<BoltServerAddress>(Collections.singletonList(writer1));
        LinkedHashSet<BoltServerAddress> routers = new LinkedHashSet<BoltServerAddress>(Collections.singletonList(router1));
        ClusterComposition clusterComposition = new ClusterComposition(42L, readers, writers, routers, null);
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(RediscoveryImpl.class);
        Mockito.when((Object)rediscovery.lookupClusterComposition((RoutingTable)ArgumentMatchers.eq((Object)routingTable), (ConnectionPool)ArgumentMatchers.eq((Object)connectionPool), (Bookmark)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(new ClusterCompositionLookupResult(clusterComposition)));
        RoutingTableHandler handler = RoutingTableHandlerTest.newRoutingTableHandler((RoutingTable)routingTable, rediscovery, connectionPool);
        Assertions.assertNotNull(TestUtil.await(handler.ensureRoutingTable(ImmutableConnectionContext.simple((boolean)false))));
        ((Rediscovery)Mockito.verify((Object)rediscovery)).lookupClusterComposition((RoutingTable)ArgumentMatchers.eq((Object)routingTable), (ConnectionPool)ArgumentMatchers.eq((Object)connectionPool), (Bookmark)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        Assertions.assertArrayEquals((Object[])new BoltServerAddress[]{reader1, reader2}, (Object[])routingTable.readers().toArray());
        Assertions.assertArrayEquals((Object[])new BoltServerAddress[]{writer1}, (Object[])routingTable.writers().toArray());
        Assertions.assertArrayEquals((Object[])new BoltServerAddress[]{router1}, (Object[])routingTable.routers().toArray());
    }

    @Test
    void shouldRediscoverOnReadWhenRoutingTableIsStaleForReads() {
        this.testRediscoveryWhenStale(AccessMode.READ);
    }

    @Test
    void shouldRediscoverOnWriteWhenRoutingTableIsStaleForWrites() {
        this.testRediscoveryWhenStale(AccessMode.WRITE);
    }

    @Test
    void shouldNotRediscoverOnReadWhenRoutingTableIsStaleForWritesButNotReads() {
        this.testNoRediscoveryWhenNotStale(AccessMode.WRITE, AccessMode.READ);
    }

    @Test
    void shouldNotRediscoverOnWriteWhenRoutingTableIsStaleForReadsButNotWrites() {
        this.testNoRediscoveryWhenNotStale(AccessMode.READ, AccessMode.WRITE);
    }

    @Test
    void shouldRetainAllFetchedAddressesInConnectionPoolAfterFetchingOfRoutingTable() {
        ClusterRoutingTable routingTable = new ClusterRoutingTable(DatabaseNameUtil.defaultDatabase(), (Clock)new FakeClock(), new BoltServerAddress[0]);
        routingTable.update(new ClusterComposition(42L, TestUtil.asOrderedSet(new BoltServerAddress[0]), TestUtil.asOrderedSet(ClusterCompositionUtil.B, ClusterCompositionUtil.C), TestUtil.asOrderedSet(ClusterCompositionUtil.D, ClusterCompositionUtil.E), null));
        ConnectionPool connectionPool = RoutingTableHandlerTest.newConnectionPoolMock();
        Rediscovery rediscovery = RoutingTableHandlerTest.newRediscoveryMock();
        Mockito.when((Object)rediscovery.lookupClusterComposition((RoutingTable)ArgumentMatchers.any(), (ConnectionPool)ArgumentMatchers.any(), (Bookmark)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(new ClusterCompositionLookupResult(new ClusterComposition(42L, TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B), TestUtil.asOrderedSet(ClusterCompositionUtil.B, ClusterCompositionUtil.C), TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.C), null))));
        RoutingTableRegistry registry = new RoutingTableRegistry((RoutingTable)routingTable){
            final /* synthetic */ RoutingTable val$routingTable;
            {
                this.val$routingTable = routingTable;
            }

            public CompletionStage<RoutingTableHandler> ensureRoutingTable(ConnectionContext context) {
                throw new UnsupportedOperationException();
            }

            public Set<BoltServerAddress> allServers() {
                return this.val$routingTable.servers();
            }

            public void remove(DatabaseName databaseName) {
                throw new UnsupportedOperationException();
            }

            public void removeAged() {
            }

            public Optional<RoutingTableHandler> getRoutingTableHandler(DatabaseName databaseName) {
                return Optional.empty();
            }
        };
        RoutingTableHandler handler = RoutingTableHandlerTest.newRoutingTableHandler((RoutingTable)routingTable, rediscovery, connectionPool, registry);
        RoutingTable actual = (RoutingTable)TestUtil.await(handler.ensureRoutingTable(ImmutableConnectionContext.simple((boolean)false)));
        Assertions.assertEquals((Object)routingTable, (Object)actual);
        ((ConnectionPool)Mockito.verify((Object)connectionPool)).retainAll(new HashSet<BoltServerAddress>(Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C)));
    }

    @Test
    void shouldRemoveRoutingTableHandlerIfFailedToLookup() throws Throwable {
        ClusterRoutingTable routingTable = new ClusterRoutingTable(DatabaseNameUtil.defaultDatabase(), (Clock)new FakeClock(), new BoltServerAddress[0]);
        Rediscovery rediscovery = RoutingTableHandlerTest.newRediscoveryMock();
        Mockito.when((Object)rediscovery.lookupClusterComposition((RoutingTable)ArgumentMatchers.any(), (ConnectionPool)ArgumentMatchers.any(), (Bookmark)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)Futures.failedFuture((Throwable)new RuntimeException("Bang!")));
        ConnectionPool connectionPool = RoutingTableHandlerTest.newConnectionPoolMock();
        RoutingTableRegistry registry = RoutingTableHandlerTest.newRoutingTableRegistryMock();
        RoutingTableHandler handler = RoutingTableHandlerTest.newRoutingTableHandler((RoutingTable)routingTable, rediscovery, connectionPool, registry);
        Assertions.assertThrows(RuntimeException.class, () -> TestUtil.await(handler.ensureRoutingTable(ImmutableConnectionContext.simple((boolean)false))));
        ((RoutingTableRegistry)Mockito.verify((Object)registry)).remove(DatabaseNameUtil.defaultDatabase());
    }

    private void testRediscoveryWhenStale(AccessMode mode) {
        ConnectionPool connectionPool = (ConnectionPool)Mockito.mock(ConnectionPool.class);
        Mockito.when((Object)connectionPool.acquire(BoltServerAddress.LOCAL_DEFAULT)).thenReturn(CompletableFuture.completedFuture((Connection)Mockito.mock(Connection.class)));
        RoutingTable routingTable = RoutingTableHandlerTest.newStaleRoutingTableMock(mode);
        Rediscovery rediscovery = RoutingTableHandlerTest.newRediscoveryMock();
        RoutingTableHandler handler = RoutingTableHandlerTest.newRoutingTableHandler(routingTable, rediscovery, connectionPool);
        RoutingTable actual = (RoutingTable)TestUtil.await(handler.ensureRoutingTable(RediscoveryUtil.contextWithMode(mode)));
        Assertions.assertEquals((Object)routingTable, (Object)actual);
        ((RoutingTable)Mockito.verify((Object)routingTable)).isStaleFor(mode);
        ((Rediscovery)Mockito.verify((Object)rediscovery)).lookupClusterComposition((RoutingTable)ArgumentMatchers.eq((Object)routingTable), (ConnectionPool)ArgumentMatchers.eq((Object)connectionPool), (Bookmark)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    private void testNoRediscoveryWhenNotStale(AccessMode staleMode, AccessMode notStaleMode) {
        ConnectionPool connectionPool = (ConnectionPool)Mockito.mock(ConnectionPool.class);
        Mockito.when((Object)connectionPool.acquire(BoltServerAddress.LOCAL_DEFAULT)).thenReturn(CompletableFuture.completedFuture((Connection)Mockito.mock(Connection.class)));
        RoutingTable routingTable = RoutingTableHandlerTest.newStaleRoutingTableMock(staleMode);
        Rediscovery rediscovery = RoutingTableHandlerTest.newRediscoveryMock();
        RoutingTableHandler handler = RoutingTableHandlerTest.newRoutingTableHandler(routingTable, rediscovery, connectionPool);
        Assertions.assertNotNull(TestUtil.await(handler.ensureRoutingTable(RediscoveryUtil.contextWithMode(notStaleMode))));
        ((RoutingTable)Mockito.verify((Object)routingTable)).isStaleFor(notStaleMode);
        ((Rediscovery)Mockito.verify((Object)rediscovery, (VerificationMode)Mockito.never())).lookupClusterComposition((RoutingTable)ArgumentMatchers.eq((Object)routingTable), (ConnectionPool)ArgumentMatchers.eq((Object)connectionPool), (Bookmark)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    private static RoutingTable newStaleRoutingTableMock(AccessMode mode) {
        RoutingTable routingTable = (RoutingTable)Mockito.mock(RoutingTable.class);
        Mockito.when((Object)routingTable.isStaleFor(mode)).thenReturn((Object)true);
        List<BoltServerAddress> addresses = Collections.singletonList(BoltServerAddress.LOCAL_DEFAULT);
        Mockito.when((Object)routingTable.readers()).thenReturn(addresses);
        Mockito.when((Object)routingTable.writers()).thenReturn(addresses);
        Mockito.when((Object)routingTable.database()).thenReturn((Object)DatabaseNameUtil.defaultDatabase());
        return routingTable;
    }

    private static RoutingTableRegistry newRoutingTableRegistryMock() {
        return (RoutingTableRegistry)Mockito.mock(RoutingTableRegistry.class);
    }

    private static Rediscovery newRediscoveryMock() {
        Rediscovery rediscovery = (Rediscovery)Mockito.mock(RediscoveryImpl.class);
        Set noServers = Collections.emptySet();
        ClusterComposition clusterComposition = new ClusterComposition(1L, noServers, noServers, noServers, null);
        Mockito.when((Object)rediscovery.lookupClusterComposition((RoutingTable)ArgumentMatchers.any(RoutingTable.class), (ConnectionPool)ArgumentMatchers.any(ConnectionPool.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(new ClusterCompositionLookupResult(clusterComposition)));
        return rediscovery;
    }

    private static ConnectionPool newConnectionPoolMock() {
        return RoutingTableHandlerTest.newConnectionPoolMockWithFailures(Collections.emptySet());
    }

    private static ConnectionPool newConnectionPoolMockWithFailures(Set<BoltServerAddress> unavailableAddresses) {
        ConnectionPool pool = (ConnectionPool)Mockito.mock(ConnectionPool.class);
        Mockito.when((Object)pool.acquire((BoltServerAddress)ArgumentMatchers.any(BoltServerAddress.class))).then(invocation -> {
            BoltServerAddress requestedAddress = (BoltServerAddress)invocation.getArgument(0);
            if (unavailableAddresses.contains(requestedAddress)) {
                return Futures.failedFuture((Throwable)new ServiceUnavailableException(requestedAddress + " is unavailable!"));
            }
            Connection connection = (Connection)Mockito.mock(Connection.class);
            Mockito.when((Object)connection.serverAddress()).thenReturn((Object)requestedAddress);
            return CompletableFuture.completedFuture(connection);
        });
        return pool;
    }

    private static RoutingTableHandler newRoutingTableHandler(RoutingTable routingTable, Rediscovery rediscovery, ConnectionPool connectionPool) {
        return new RoutingTableHandlerImpl(routingTable, rediscovery, connectionPool, RoutingTableHandlerTest.newRoutingTableRegistryMock(), DevNullLogging.DEV_NULL_LOGGING, RoutingSettings.STALE_ROUTING_TABLE_PURGE_DELAY_MS);
    }

    private static RoutingTableHandler newRoutingTableHandler(RoutingTable routingTable, Rediscovery rediscovery, ConnectionPool connectionPool, RoutingTableRegistry routingTableRegistry) {
        return new RoutingTableHandlerImpl(routingTable, rediscovery, connectionPool, routingTableRegistry, DevNullLogging.DEV_NULL_LOGGING, RoutingSettings.STALE_ROUTING_TABLE_PURGE_DELAY_MS);
    }
}

