/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ProtocolException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.MultiDatabasesRoutingProcedureRunner;
import org.neo4j.driver.internal.cluster.RouteMessageRoutingProcedureRunner;
import org.neo4j.driver.internal.cluster.RoutingProcedureClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.RoutingProcedureResponse;
import org.neo4j.driver.internal.cluster.SingleDatabaseRoutingProcedureRunner;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.messaging.v43.BoltProtocolV43;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.internal.value.StringValue;
import org.neo4j.driver.util.TestUtil;

class RoutingProcedureClusterCompositionProviderTest {
    RoutingProcedureClusterCompositionProviderTest() {
    }

    @Test
    void shouldProtocolErrorWhenNoRecord() {
        SingleDatabaseRoutingProcedureRunner mockedRunner = RoutingProcedureClusterCompositionProviderTest.newProcedureRunnerMock();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        RoutingProcedureClusterCompositionProvider provider = RoutingProcedureClusterCompositionProviderTest.newClusterCompositionProvider(mockedRunner, connection);
        RoutingProcedureResponse noRecordsResponse = RoutingProcedureClusterCompositionProviderTest.newRoutingResponse(new Record[0]);
        Mockito.when((Object)mockedRunner.run((Connection)ArgumentMatchers.eq((Object)connection), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(noRecordsResponse));
        ProtocolException error = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> RoutingProcedureClusterCompositionProviderTest.lambda$shouldProtocolErrorWhenNoRecord$0((ClusterCompositionProvider)provider, connection));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"records received '0' is too few or too many."));
    }

    @Test
    void shouldProtocolErrorWhenMoreThanOneRecord() {
        SingleDatabaseRoutingProcedureRunner mockedRunner = RoutingProcedureClusterCompositionProviderTest.newProcedureRunnerMock();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        RoutingProcedureClusterCompositionProvider provider = RoutingProcedureClusterCompositionProviderTest.newClusterCompositionProvider(mockedRunner, connection);
        InternalRecord aRecord = new InternalRecord(Arrays.asList("key1", "key2"), new Value[]{new StringValue("a value")});
        RoutingProcedureResponse routingResponse = RoutingProcedureClusterCompositionProviderTest.newRoutingResponse(new Record[]{aRecord, aRecord});
        Mockito.when((Object)mockedRunner.run((Connection)ArgumentMatchers.eq((Object)connection), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(routingResponse));
        ProtocolException error = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> RoutingProcedureClusterCompositionProviderTest.lambda$shouldProtocolErrorWhenMoreThanOneRecord$1((ClusterCompositionProvider)provider, connection));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"records received '2' is too few or too many."));
    }

    @Test
    void shouldProtocolErrorWhenUnparsableRecord() {
        SingleDatabaseRoutingProcedureRunner mockedRunner = RoutingProcedureClusterCompositionProviderTest.newProcedureRunnerMock();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        RoutingProcedureClusterCompositionProvider provider = RoutingProcedureClusterCompositionProviderTest.newClusterCompositionProvider(mockedRunner, connection);
        InternalRecord aRecord = new InternalRecord(Arrays.asList("key1", "key2"), new Value[]{new StringValue("a value")});
        RoutingProcedureResponse routingResponse = RoutingProcedureClusterCompositionProviderTest.newRoutingResponse(new Record[]{aRecord});
        Mockito.when((Object)mockedRunner.run((Connection)ArgumentMatchers.eq((Object)connection), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(routingResponse));
        ProtocolException error = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> RoutingProcedureClusterCompositionProviderTest.lambda$shouldProtocolErrorWhenUnparsableRecord$2((ClusterCompositionProvider)provider, connection));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"unparsable record received."));
    }

    @Test
    void shouldProtocolErrorWhenNoRouters() {
        MultiDatabasesRoutingProcedureRunner mockedRunner = RoutingProcedureClusterCompositionProviderTest.newMultiDBProcedureRunnerMock();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Clock mockedClock = (Clock)Mockito.mock(Clock.class);
        RoutingProcedureClusterCompositionProvider provider = RoutingProcedureClusterCompositionProviderTest.newClusterCompositionProvider(mockedRunner, connection, mockedClock);
        InternalRecord record = new InternalRecord(Arrays.asList("ttl", "servers"), new Value[]{Values.value((int)100), Values.value(Arrays.asList(RoutingProcedureClusterCompositionProviderTest.serverInfo("READ", "one:1337", "two:1337"), RoutingProcedureClusterCompositionProviderTest.serverInfo("WRITE", "one:1337")))});
        RoutingProcedureResponse routingResponse = RoutingProcedureClusterCompositionProviderTest.newRoutingResponse(new Record[]{record});
        Mockito.when((Object)mockedRunner.run((Connection)ArgumentMatchers.eq((Object)connection), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(routingResponse));
        Mockito.when((Object)mockedClock.millis()).thenReturn((Object)12345L);
        ProtocolException error = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> RoutingProcedureClusterCompositionProviderTest.lambda$shouldProtocolErrorWhenNoRouters$3((ClusterCompositionProvider)provider, connection));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"no router or reader found in response."));
    }

    @Test
    void routeMessageRoutingProcedureShouldProtocolErrorWhenNoRouters() {
        RouteMessageRoutingProcedureRunner mockedRunner = RoutingProcedureClusterCompositionProviderTest.newRouteMessageRoutingProcedureRunnerMock();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Clock mockedClock = (Clock)Mockito.mock(Clock.class);
        RoutingProcedureClusterCompositionProvider provider = RoutingProcedureClusterCompositionProviderTest.newClusterCompositionProvider(mockedRunner, connection, mockedClock);
        InternalRecord record = new InternalRecord(Arrays.asList("ttl", "servers"), new Value[]{Values.value((int)100), Values.value(Arrays.asList(RoutingProcedureClusterCompositionProviderTest.serverInfo("READ", "one:1337", "two:1337"), RoutingProcedureClusterCompositionProviderTest.serverInfo("WRITE", "one:1337")))});
        RoutingProcedureResponse routingResponse = RoutingProcedureClusterCompositionProviderTest.newRoutingResponse(new Record[]{record});
        Mockito.when((Object)mockedRunner.run((Connection)ArgumentMatchers.eq((Object)connection), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(routingResponse));
        Mockito.when((Object)mockedClock.millis()).thenReturn((Object)12345L);
        ProtocolException error = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> RoutingProcedureClusterCompositionProviderTest.lambda$routeMessageRoutingProcedureShouldProtocolErrorWhenNoRouters$4((ClusterCompositionProvider)provider, connection));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"no router or reader found in response."));
    }

    @Test
    void shouldProtocolErrorWhenNoReaders() {
        MultiDatabasesRoutingProcedureRunner mockedRunner = RoutingProcedureClusterCompositionProviderTest.newMultiDBProcedureRunnerMock();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Clock mockedClock = (Clock)Mockito.mock(Clock.class);
        RoutingProcedureClusterCompositionProvider provider = RoutingProcedureClusterCompositionProviderTest.newClusterCompositionProvider(mockedRunner, connection, mockedClock);
        InternalRecord record = new InternalRecord(Arrays.asList("ttl", "servers"), new Value[]{Values.value((int)100), Values.value(Arrays.asList(RoutingProcedureClusterCompositionProviderTest.serverInfo("WRITE", "one:1337"), RoutingProcedureClusterCompositionProviderTest.serverInfo("ROUTE", "one:1337", "two:1337")))});
        RoutingProcedureResponse routingResponse = RoutingProcedureClusterCompositionProviderTest.newRoutingResponse(new Record[]{record});
        Mockito.when((Object)mockedRunner.run((Connection)ArgumentMatchers.eq((Object)connection), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(routingResponse));
        Mockito.when((Object)mockedClock.millis()).thenReturn((Object)12345L);
        ProtocolException error = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> RoutingProcedureClusterCompositionProviderTest.lambda$shouldProtocolErrorWhenNoReaders$5((ClusterCompositionProvider)provider, connection));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"no router or reader found in response."));
    }

    @Test
    void routeMessageRoutingProcedureShouldProtocolErrorWhenNoReaders() {
        RouteMessageRoutingProcedureRunner mockedRunner = RoutingProcedureClusterCompositionProviderTest.newRouteMessageRoutingProcedureRunnerMock();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Clock mockedClock = (Clock)Mockito.mock(Clock.class);
        RoutingProcedureClusterCompositionProvider provider = RoutingProcedureClusterCompositionProviderTest.newClusterCompositionProvider(mockedRunner, connection, mockedClock);
        InternalRecord record = new InternalRecord(Arrays.asList("ttl", "servers"), new Value[]{Values.value((int)100), Values.value(Arrays.asList(RoutingProcedureClusterCompositionProviderTest.serverInfo("WRITE", "one:1337"), RoutingProcedureClusterCompositionProviderTest.serverInfo("ROUTE", "one:1337", "two:1337")))});
        RoutingProcedureResponse routingResponse = RoutingProcedureClusterCompositionProviderTest.newRoutingResponse(new Record[]{record});
        Mockito.when((Object)mockedRunner.run((Connection)ArgumentMatchers.eq((Object)connection), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(routingResponse));
        Mockito.when((Object)mockedClock.millis()).thenReturn((Object)12345L);
        ProtocolException error = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> RoutingProcedureClusterCompositionProviderTest.lambda$routeMessageRoutingProcedureShouldProtocolErrorWhenNoReaders$6((ClusterCompositionProvider)provider, connection));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"no router or reader found in response."));
    }

    @Test
    void shouldPropagateConnectionFailureExceptions() {
        SingleDatabaseRoutingProcedureRunner mockedRunner = RoutingProcedureClusterCompositionProviderTest.newProcedureRunnerMock();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        RoutingProcedureClusterCompositionProvider provider = RoutingProcedureClusterCompositionProviderTest.newClusterCompositionProvider(mockedRunner, connection);
        Mockito.when((Object)mockedRunner.run((Connection)ArgumentMatchers.eq((Object)connection), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any())).thenReturn((Object)Futures.failedFuture((Throwable)new ServiceUnavailableException("Connection breaks during cypher execution")));
        ServiceUnavailableException e = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> RoutingProcedureClusterCompositionProviderTest.lambda$shouldPropagateConnectionFailureExceptions$7((ClusterCompositionProvider)provider, connection));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Connection breaks during cypher execution"));
    }

    @Test
    void shouldReturnSuccessResultWhenNoError() {
        Clock mockedClock = (Clock)Mockito.mock(Clock.class);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        MultiDatabasesRoutingProcedureRunner mockedRunner = RoutingProcedureClusterCompositionProviderTest.newMultiDBProcedureRunnerMock();
        RoutingProcedureClusterCompositionProvider provider = RoutingProcedureClusterCompositionProviderTest.newClusterCompositionProvider(mockedRunner, connection, mockedClock);
        InternalRecord record = new InternalRecord(Arrays.asList("ttl", "servers"), new Value[]{Values.value((int)100), Values.value(Arrays.asList(RoutingProcedureClusterCompositionProviderTest.serverInfo("READ", "one:1337", "two:1337"), RoutingProcedureClusterCompositionProviderTest.serverInfo("WRITE", "one:1337"), RoutingProcedureClusterCompositionProviderTest.serverInfo("ROUTE", "one:1337", "two:1337")))});
        RoutingProcedureResponse routingResponse = RoutingProcedureClusterCompositionProviderTest.newRoutingResponse(new Record[]{record});
        Mockito.when((Object)mockedRunner.run((Connection)ArgumentMatchers.eq((Object)connection), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(routingResponse));
        Mockito.when((Object)mockedClock.millis()).thenReturn((Object)12345L);
        ClusterComposition cluster = (ClusterComposition)TestUtil.await(provider.getClusterComposition(connection, DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null));
        Assertions.assertEquals((long)112345L, (long)cluster.expirationTimestamp());
        Assertions.assertEquals(RoutingProcedureClusterCompositionProviderTest.serverSet("one:1337", "two:1337"), (Object)cluster.readers());
        Assertions.assertEquals(RoutingProcedureClusterCompositionProviderTest.serverSet("one:1337"), (Object)cluster.writers());
        Assertions.assertEquals(RoutingProcedureClusterCompositionProviderTest.serverSet("one:1337", "two:1337"), (Object)cluster.routers());
    }

    @Test
    void routeMessageRoutingProcedureShouldReturnSuccessResultWhenNoError() {
        Clock mockedClock = (Clock)Mockito.mock(Clock.class);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        RouteMessageRoutingProcedureRunner mockedRunner = RoutingProcedureClusterCompositionProviderTest.newRouteMessageRoutingProcedureRunnerMock();
        RoutingProcedureClusterCompositionProvider provider = RoutingProcedureClusterCompositionProviderTest.newClusterCompositionProvider(mockedRunner, connection, mockedClock);
        InternalRecord record = new InternalRecord(Arrays.asList("ttl", "servers"), new Value[]{Values.value((int)100), Values.value(Arrays.asList(RoutingProcedureClusterCompositionProviderTest.serverInfo("READ", "one:1337", "two:1337"), RoutingProcedureClusterCompositionProviderTest.serverInfo("WRITE", "one:1337"), RoutingProcedureClusterCompositionProviderTest.serverInfo("ROUTE", "one:1337", "two:1337")))});
        RoutingProcedureResponse routingResponse = RoutingProcedureClusterCompositionProviderTest.newRoutingResponse(new Record[]{record});
        Mockito.when((Object)mockedRunner.run((Connection)ArgumentMatchers.eq((Object)connection), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(routingResponse));
        Mockito.when((Object)mockedClock.millis()).thenReturn((Object)12345L);
        ClusterComposition cluster = (ClusterComposition)TestUtil.await(provider.getClusterComposition(connection, DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null));
        Assertions.assertEquals((long)112345L, (long)cluster.expirationTimestamp());
        Assertions.assertEquals(RoutingProcedureClusterCompositionProviderTest.serverSet("one:1337", "two:1337"), (Object)cluster.readers());
        Assertions.assertEquals(RoutingProcedureClusterCompositionProviderTest.serverSet("one:1337"), (Object)cluster.writers());
        Assertions.assertEquals(RoutingProcedureClusterCompositionProviderTest.serverSet("one:1337", "two:1337"), (Object)cluster.routers());
    }

    @Test
    void shouldReturnFailureWhenProcedureRunnerFails() {
        SingleDatabaseRoutingProcedureRunner procedureRunner = RoutingProcedureClusterCompositionProviderTest.newProcedureRunnerMock();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        RuntimeException error = new RuntimeException("hi");
        Mockito.when((Object)procedureRunner.run((Connection)ArgumentMatchers.eq((Object)connection), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(RoutingProcedureClusterCompositionProviderTest.newRoutingResponse(error)));
        RoutingProcedureClusterCompositionProvider provider = RoutingProcedureClusterCompositionProviderTest.newClusterCompositionProvider(procedureRunner, connection);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TestUtil.await(provider.getClusterComposition(connection, DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null)));
        Assertions.assertEquals((Object)error, (Object)e);
    }

    @Test
    void shouldUseMultiDBProcedureRunnerWhenConnectingWith40Server() throws Throwable {
        MultiDatabasesRoutingProcedureRunner procedureRunner = RoutingProcedureClusterCompositionProviderTest.newMultiDBProcedureRunnerMock();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        RoutingProcedureClusterCompositionProvider provider = RoutingProcedureClusterCompositionProviderTest.newClusterCompositionProvider(procedureRunner, connection);
        Mockito.when((Object)procedureRunner.run((Connection)ArgumentMatchers.eq((Object)connection), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any())).thenReturn((Object)Futures.completedWithNull());
        provider.getClusterComposition(connection, DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null);
        ((MultiDatabasesRoutingProcedureRunner)Mockito.verify((Object)procedureRunner)).run((Connection)ArgumentMatchers.eq((Object)connection), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any());
    }

    @Test
    void shouldUseProcedureRunnerWhenConnectingWith35AndPreviousServers() throws Throwable {
        SingleDatabaseRoutingProcedureRunner procedureRunner = RoutingProcedureClusterCompositionProviderTest.newProcedureRunnerMock();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        RoutingProcedureClusterCompositionProvider provider = RoutingProcedureClusterCompositionProviderTest.newClusterCompositionProvider(procedureRunner, connection);
        Mockito.when((Object)procedureRunner.run((Connection)ArgumentMatchers.eq((Object)connection), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any())).thenReturn((Object)Futures.completedWithNull());
        provider.getClusterComposition(connection, DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null);
        ((SingleDatabaseRoutingProcedureRunner)Mockito.verify((Object)procedureRunner)).run((Connection)ArgumentMatchers.eq((Object)connection), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any());
    }

    @Test
    void shouldUseRouteMessageProcedureRunnerWhenConnectingWithProtocol43() throws Throwable {
        RouteMessageRoutingProcedureRunner procedureRunner = RoutingProcedureClusterCompositionProviderTest.newRouteMessageRoutingProcedureRunnerMock();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        RoutingProcedureClusterCompositionProvider provider = RoutingProcedureClusterCompositionProviderTest.newClusterCompositionProvider(procedureRunner, connection);
        Mockito.when((Object)procedureRunner.run((Connection)ArgumentMatchers.eq((Object)connection), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any())).thenReturn((Object)Futures.completedWithNull());
        provider.getClusterComposition(connection, DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null);
        ((RouteMessageRoutingProcedureRunner)Mockito.verify((Object)procedureRunner)).run((Connection)ArgumentMatchers.eq((Object)connection), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any());
    }

    private static Map<String, Object> serverInfo(String role, String ... addresses) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("role", role);
        map.put("addresses", Arrays.asList(addresses));
        return map;
    }

    private static Set<BoltServerAddress> serverSet(String ... addresses) {
        HashSet<BoltServerAddress> result = new HashSet<BoltServerAddress>();
        for (String address : addresses) {
            result.add(new BoltServerAddress(address));
        }
        return result;
    }

    private static SingleDatabaseRoutingProcedureRunner newProcedureRunnerMock() {
        return (SingleDatabaseRoutingProcedureRunner)Mockito.mock(SingleDatabaseRoutingProcedureRunner.class);
    }

    private static MultiDatabasesRoutingProcedureRunner newMultiDBProcedureRunnerMock() {
        return (MultiDatabasesRoutingProcedureRunner)Mockito.mock(MultiDatabasesRoutingProcedureRunner.class);
    }

    private static RouteMessageRoutingProcedureRunner newRouteMessageRoutingProcedureRunnerMock() {
        return (RouteMessageRoutingProcedureRunner)Mockito.mock(RouteMessageRoutingProcedureRunner.class);
    }

    private static RoutingProcedureResponse newRoutingResponse(Record ... records) {
        return new RoutingProcedureResponse(new Query("procedure"), Arrays.asList(records));
    }

    private static RoutingProcedureResponse newRoutingResponse(Throwable error) {
        return new RoutingProcedureResponse(new Query("procedure"), error);
    }

    private static RoutingProcedureClusterCompositionProvider newClusterCompositionProvider(SingleDatabaseRoutingProcedureRunner runner, Connection connection) {
        Mockito.when((Object)connection.serverVersion()).thenReturn((Object)ServerVersion.v3_5_0);
        Mockito.when((Object)connection.protocol()).thenReturn((Object)BoltProtocolV3.INSTANCE);
        return new RoutingProcedureClusterCompositionProvider((Clock)Mockito.mock(Clock.class), runner, RoutingProcedureClusterCompositionProviderTest.newMultiDBProcedureRunnerMock(), RoutingProcedureClusterCompositionProviderTest.newRouteMessageRoutingProcedureRunnerMock());
    }

    private static RoutingProcedureClusterCompositionProvider newClusterCompositionProvider(MultiDatabasesRoutingProcedureRunner runner, Connection connection) {
        Mockito.when((Object)connection.serverVersion()).thenReturn((Object)ServerVersion.v4_0_0);
        Mockito.when((Object)connection.protocol()).thenReturn((Object)BoltProtocolV4.INSTANCE);
        return new RoutingProcedureClusterCompositionProvider((Clock)Mockito.mock(Clock.class), RoutingProcedureClusterCompositionProviderTest.newProcedureRunnerMock(), runner, RoutingProcedureClusterCompositionProviderTest.newRouteMessageRoutingProcedureRunnerMock());
    }

    private static RoutingProcedureClusterCompositionProvider newClusterCompositionProvider(MultiDatabasesRoutingProcedureRunner runner, Connection connection, Clock clock) {
        Mockito.when((Object)connection.serverVersion()).thenReturn((Object)ServerVersion.v4_0_0);
        Mockito.when((Object)connection.protocol()).thenReturn((Object)BoltProtocolV4.INSTANCE);
        return new RoutingProcedureClusterCompositionProvider(clock, RoutingProcedureClusterCompositionProviderTest.newProcedureRunnerMock(), runner, RoutingProcedureClusterCompositionProviderTest.newRouteMessageRoutingProcedureRunnerMock());
    }

    private static RoutingProcedureClusterCompositionProvider newClusterCompositionProvider(RouteMessageRoutingProcedureRunner runner, Connection connection) {
        return RoutingProcedureClusterCompositionProviderTest.newClusterCompositionProvider(runner, connection, (Clock)Mockito.mock(Clock.class));
    }

    private static RoutingProcedureClusterCompositionProvider newClusterCompositionProvider(RouteMessageRoutingProcedureRunner runner, Connection connection, Clock clock) {
        Mockito.when((Object)connection.protocol()).thenReturn((Object)BoltProtocolV43.INSTANCE);
        return new RoutingProcedureClusterCompositionProvider(clock, RoutingProcedureClusterCompositionProviderTest.newProcedureRunnerMock(), RoutingProcedureClusterCompositionProviderTest.newMultiDBProcedureRunnerMock(), runner);
    }

    private static /* synthetic */ void lambda$shouldPropagateConnectionFailureExceptions$7(ClusterCompositionProvider provider, Connection connection) throws Throwable {
        TestUtil.await(provider.getClusterComposition(connection, DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null));
    }

    private static /* synthetic */ void lambda$routeMessageRoutingProcedureShouldProtocolErrorWhenNoReaders$6(ClusterCompositionProvider provider, Connection connection) throws Throwable {
        TestUtil.await(provider.getClusterComposition(connection, DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null));
    }

    private static /* synthetic */ void lambda$shouldProtocolErrorWhenNoReaders$5(ClusterCompositionProvider provider, Connection connection) throws Throwable {
        TestUtil.await(provider.getClusterComposition(connection, DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null));
    }

    private static /* synthetic */ void lambda$routeMessageRoutingProcedureShouldProtocolErrorWhenNoRouters$4(ClusterCompositionProvider provider, Connection connection) throws Throwable {
        TestUtil.await(provider.getClusterComposition(connection, DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null));
    }

    private static /* synthetic */ void lambda$shouldProtocolErrorWhenNoRouters$3(ClusterCompositionProvider provider, Connection connection) throws Throwable {
        TestUtil.await(provider.getClusterComposition(connection, DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null));
    }

    private static /* synthetic */ void lambda$shouldProtocolErrorWhenUnparsableRecord$2(ClusterCompositionProvider provider, Connection connection) throws Throwable {
        TestUtil.await(provider.getClusterComposition(connection, DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null));
    }

    private static /* synthetic */ void lambda$shouldProtocolErrorWhenMoreThanOneRecord$1(ClusterCompositionProvider provider, Connection connection) throws Throwable {
        TestUtil.await(provider.getClusterComposition(connection, DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null));
    }

    private static /* synthetic */ void lambda$shouldProtocolErrorWhenNoRecord$0(ClusterCompositionProvider provider, Connection connection) throws Throwable {
        TestUtil.await(provider.getClusterComposition(connection, DatabaseNameUtil.defaultDatabase(), InternalBookmark.empty(), null));
    }
}

