/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.driver.exceptions.AuthorizationExpiredException;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.DiscoveryException;
import org.neo4j.driver.exceptions.ProtocolException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.DefaultDomainNameResolver;
import org.neo4j.driver.internal.DomainNameResolver;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterCompositionLookupResult;
import org.neo4j.driver.internal.cluster.ClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.ClusterRoutingTable;
import org.neo4j.driver.internal.cluster.Rediscovery;
import org.neo4j.driver.internal.cluster.RediscoveryImpl;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.ClusterCompositionUtil;
import org.neo4j.driver.internal.util.FakeClock;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.ImmediateSchedulingEventExecutor;
import org.neo4j.driver.net.ServerAddress;
import org.neo4j.driver.net.ServerAddressResolver;
import org.neo4j.driver.util.TestUtil;

class RediscoveryTest {
    private final ConnectionPool pool = RediscoveryTest.asyncConnectionPoolMock();

    RediscoveryTest() {
    }

    @Test
    void shouldUseFirstRouterInTable() {
        ClusterComposition expectedComposition = new ClusterComposition(42L, TestUtil.asOrderedSet(ClusterCompositionUtil.B, ClusterCompositionUtil.C), TestUtil.asOrderedSet(ClusterCompositionUtil.C, ClusterCompositionUtil.D), TestUtil.asOrderedSet(ClusterCompositionUtil.B), null);
        HashMap<BoltServerAddress, Object> responsesByAddress = new HashMap<BoltServerAddress, Object>();
        responsesByAddress.put(ClusterCompositionUtil.B, expectedComposition);
        ClusterCompositionProvider compositionProvider = RediscoveryTest.compositionProviderMock(responsesByAddress);
        Rediscovery rediscovery = this.newRediscovery(ClusterCompositionUtil.A, compositionProvider, (ServerAddressResolver)Mockito.mock(ServerAddressResolver.class));
        RoutingTable table = RediscoveryTest.routingTableMock(ClusterCompositionUtil.B);
        ClusterComposition actualComposition = ((ClusterCompositionLookupResult)TestUtil.await(rediscovery.lookupClusterComposition(table, this.pool, InternalBookmark.empty(), null))).getClusterComposition();
        Assertions.assertEquals((Object)expectedComposition, (Object)actualComposition);
        ((RoutingTable)Mockito.verify((Object)table, (VerificationMode)Mockito.never())).forget(ClusterCompositionUtil.B);
    }

    @Test
    void shouldSkipFailingRouters() {
        ClusterComposition expectedComposition = new ClusterComposition(42L, TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C), TestUtil.asOrderedSet(ClusterCompositionUtil.B, ClusterCompositionUtil.C, ClusterCompositionUtil.D), TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B), null);
        HashMap<BoltServerAddress, Object> responsesByAddress = new HashMap<BoltServerAddress, Object>();
        responsesByAddress.put(ClusterCompositionUtil.A, new RuntimeException("Hi!"));
        responsesByAddress.put(ClusterCompositionUtil.B, (Object)new ServiceUnavailableException("Hi!"));
        responsesByAddress.put(ClusterCompositionUtil.C, expectedComposition);
        ClusterCompositionProvider compositionProvider = RediscoveryTest.compositionProviderMock(responsesByAddress);
        Rediscovery rediscovery = this.newRediscovery(ClusterCompositionUtil.A, compositionProvider, (ServerAddressResolver)Mockito.mock(ServerAddressResolver.class));
        RoutingTable table = RediscoveryTest.routingTableMock(ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C);
        ClusterComposition actualComposition = ((ClusterCompositionLookupResult)TestUtil.await(rediscovery.lookupClusterComposition(table, this.pool, InternalBookmark.empty(), null))).getClusterComposition();
        Assertions.assertEquals((Object)expectedComposition, (Object)actualComposition);
        ((RoutingTable)Mockito.verify((Object)table)).forget(ClusterCompositionUtil.A);
        ((RoutingTable)Mockito.verify((Object)table)).forget(ClusterCompositionUtil.B);
        ((RoutingTable)Mockito.verify((Object)table, (VerificationMode)Mockito.never())).forget(ClusterCompositionUtil.C);
    }

    @Test
    void shouldFailImmediatelyOnAuthError() {
        AuthenticationException authError = new AuthenticationException("Neo.ClientError.Security.Unauthorized", "Wrong password");
        HashMap<BoltServerAddress, Object> responsesByAddress = new HashMap<BoltServerAddress, Object>();
        responsesByAddress.put(ClusterCompositionUtil.A, new RuntimeException("Hi!"));
        responsesByAddress.put(ClusterCompositionUtil.B, authError);
        ClusterCompositionProvider compositionProvider = RediscoveryTest.compositionProviderMock(responsesByAddress);
        Rediscovery rediscovery = this.newRediscovery(ClusterCompositionUtil.A, compositionProvider, (ServerAddressResolver)Mockito.mock(ServerAddressResolver.class));
        RoutingTable table = RediscoveryTest.routingTableMock(ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C);
        AuthenticationException error = (AuthenticationException)Assertions.assertThrows(AuthenticationException.class, () -> TestUtil.await(rediscovery.lookupClusterComposition(table, this.pool, InternalBookmark.empty(), null)));
        Assertions.assertEquals((Object)authError, (Object)error);
        ((RoutingTable)Mockito.verify((Object)table)).forget(ClusterCompositionUtil.A);
    }

    @Test
    void shouldUseAnotherRouterOnAuthorizationExpiredException() {
        ClusterComposition expectedComposition = new ClusterComposition(42L, TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C), TestUtil.asOrderedSet(ClusterCompositionUtil.B, ClusterCompositionUtil.C, ClusterCompositionUtil.D), TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B), null);
        HashMap<BoltServerAddress, Object> responsesByAddress = new HashMap<BoltServerAddress, Object>();
        responsesByAddress.put(ClusterCompositionUtil.A, new AuthorizationExpiredException("Neo.ClientError.Security.AuthorizationExpired", "message"));
        responsesByAddress.put(ClusterCompositionUtil.B, expectedComposition);
        ClusterCompositionProvider compositionProvider = RediscoveryTest.compositionProviderMock(responsesByAddress);
        Rediscovery rediscovery = this.newRediscovery(ClusterCompositionUtil.A, compositionProvider, (ServerAddressResolver)Mockito.mock(ServerAddressResolver.class));
        RoutingTable table = RediscoveryTest.routingTableMock(ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C);
        ClusterComposition actualComposition = ((ClusterCompositionLookupResult)TestUtil.await(rediscovery.lookupClusterComposition(table, this.pool, InternalBookmark.empty(), null))).getClusterComposition();
        Assertions.assertEquals((Object)expectedComposition, (Object)actualComposition);
        ((RoutingTable)Mockito.verify((Object)table)).forget(ClusterCompositionUtil.A);
        ((RoutingTable)Mockito.verify((Object)table, (VerificationMode)Mockito.never())).forget(ClusterCompositionUtil.B);
        ((RoutingTable)Mockito.verify((Object)table, (VerificationMode)Mockito.never())).forget(ClusterCompositionUtil.C);
    }

    @ParameterizedTest
    @ValueSource(strings={"Neo.ClientError.Transaction.InvalidBookmark", "Neo.ClientError.Transaction.InvalidBookmarkMixture"})
    void shouldFailImmediatelyOnBookmarkErrors(String code) {
        ClientException error = new ClientException(code, "Invalid");
        HashMap<BoltServerAddress, Object> responsesByAddress = new HashMap<BoltServerAddress, Object>();
        responsesByAddress.put(ClusterCompositionUtil.A, new RuntimeException("Hi!"));
        responsesByAddress.put(ClusterCompositionUtil.B, error);
        ClusterCompositionProvider compositionProvider = RediscoveryTest.compositionProviderMock(responsesByAddress);
        Rediscovery rediscovery = this.newRediscovery(ClusterCompositionUtil.A, compositionProvider, (ServerAddressResolver)Mockito.mock(ServerAddressResolver.class));
        RoutingTable table = RediscoveryTest.routingTableMock(ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C);
        ClientException actualError = (ClientException)Assertions.assertThrows(ClientException.class, () -> TestUtil.await(rediscovery.lookupClusterComposition(table, this.pool, InternalBookmark.empty(), null)));
        Assertions.assertEquals((Object)error, (Object)actualError);
        ((RoutingTable)Mockito.verify((Object)table)).forget(ClusterCompositionUtil.A);
    }

    @Test
    void shouldFailImmediatelyOnClosedPoolError() {
        IllegalStateException error = new IllegalStateException("Pool closed");
        HashMap<BoltServerAddress, Object> responsesByAddress = new HashMap<BoltServerAddress, Object>();
        responsesByAddress.put(ClusterCompositionUtil.A, new RuntimeException("Hi!"));
        responsesByAddress.put(ClusterCompositionUtil.B, error);
        ClusterCompositionProvider compositionProvider = RediscoveryTest.compositionProviderMock(responsesByAddress);
        Rediscovery rediscovery = this.newRediscovery(ClusterCompositionUtil.A, compositionProvider, (ServerAddressResolver)Mockito.mock(ServerAddressResolver.class));
        RoutingTable table = RediscoveryTest.routingTableMock(ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C);
        IllegalStateException actualError = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> TestUtil.await(rediscovery.lookupClusterComposition(table, this.pool, InternalBookmark.empty(), null)));
        Assertions.assertEquals((Object)error, (Object)actualError);
        ((RoutingTable)Mockito.verify((Object)table)).forget(ClusterCompositionUtil.A);
    }

    @Test
    void shouldFallbackToInitialRouterWhenKnownRoutersFail() {
        BoltServerAddress initialRouter = ClusterCompositionUtil.A;
        ClusterComposition expectedComposition = new ClusterComposition(42L, TestUtil.asOrderedSet(ClusterCompositionUtil.C, ClusterCompositionUtil.B, ClusterCompositionUtil.A), TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B), TestUtil.asOrderedSet(ClusterCompositionUtil.D, ClusterCompositionUtil.E), null);
        HashMap<BoltServerAddress, Object> responsesByAddress = new HashMap<BoltServerAddress, Object>();
        responsesByAddress.put(ClusterCompositionUtil.B, (Object)new ServiceUnavailableException("Hi!"));
        responsesByAddress.put(ClusterCompositionUtil.C, (Object)new ServiceUnavailableException("Hi!"));
        responsesByAddress.put(initialRouter, expectedComposition);
        ClusterCompositionProvider compositionProvider = RediscoveryTest.compositionProviderMock(responsesByAddress);
        ServerAddressResolver resolver = RediscoveryTest.resolverMock(initialRouter, initialRouter);
        Rediscovery rediscovery = this.newRediscovery(initialRouter, compositionProvider, resolver);
        RoutingTable table = RediscoveryTest.routingTableMock(ClusterCompositionUtil.B, ClusterCompositionUtil.C);
        ClusterComposition actualComposition = ((ClusterCompositionLookupResult)TestUtil.await(rediscovery.lookupClusterComposition(table, this.pool, InternalBookmark.empty(), null))).getClusterComposition();
        Assertions.assertEquals((Object)expectedComposition, (Object)actualComposition);
        ((RoutingTable)Mockito.verify((Object)table)).forget(ClusterCompositionUtil.B);
        ((RoutingTable)Mockito.verify((Object)table)).forget(ClusterCompositionUtil.C);
    }

    @Test
    void shouldFailImmediatelyWhenClusterCompositionProviderReturnsFailure() {
        ClusterComposition validComposition = new ClusterComposition(42L, TestUtil.asOrderedSet(ClusterCompositionUtil.A), TestUtil.asOrderedSet(ClusterCompositionUtil.B), TestUtil.asOrderedSet(ClusterCompositionUtil.C), null);
        ProtocolException protocolError = new ProtocolException("Wrong record!");
        HashMap<BoltServerAddress, Object> responsesByAddress = new HashMap<BoltServerAddress, Object>();
        responsesByAddress.put(ClusterCompositionUtil.B, protocolError);
        responsesByAddress.put(ClusterCompositionUtil.C, validComposition);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        ClusterCompositionProvider compositionProvider = RediscoveryTest.compositionProviderMock(responsesByAddress);
        Rediscovery rediscovery = this.newRediscovery(ClusterCompositionUtil.A, compositionProvider, (ServerAddressResolver)Mockito.mock(ServerAddressResolver.class), logging);
        RoutingTable table = RediscoveryTest.routingTableMock(ClusterCompositionUtil.B, ClusterCompositionUtil.C);
        ClusterComposition composition = ((ClusterCompositionLookupResult)TestUtil.await(rediscovery.lookupClusterComposition(table, this.pool, InternalBookmark.empty(), null))).getClusterComposition();
        Assertions.assertEquals((Object)validComposition, (Object)composition);
        ArgumentCaptor warningMessageCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor debugMessageCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor debugThrowableCaptor = ArgumentCaptor.forClass(DiscoveryException.class);
        ((Logging)Mockito.verify((Object)logging)).getLog(RediscoveryImpl.class);
        ((Logger)Mockito.verify((Object)logger)).warn((String)warningMessageCaptor.capture(), new Object[0]);
        ((Logger)Mockito.verify((Object)logger)).debug((String)debugMessageCaptor.capture(), (Throwable)debugThrowableCaptor.capture());
        Assertions.assertNotNull((Object)warningMessageCaptor.getValue());
        Assertions.assertEquals((Object)warningMessageCaptor.getValue(), (Object)debugMessageCaptor.getValue());
        Assert.assertThat((Object)((DiscoveryException)debugThrowableCaptor.getValue()).getCause(), (Matcher)CoreMatchers.equalTo((Object)protocolError));
    }

    @Test
    void shouldResolveInitialRouterAddress() {
        BoltServerAddress initialRouter = ClusterCompositionUtil.A;
        ClusterComposition expectedComposition = new ClusterComposition(42L, TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B), TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B), TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B), null);
        HashMap<BoltServerAddress, Object> responsesByAddress = new HashMap<BoltServerAddress, Object>();
        responsesByAddress.put(ClusterCompositionUtil.B, (Object)new ServiceUnavailableException("Hi!"));
        responsesByAddress.put(ClusterCompositionUtil.C, (Object)new ServiceUnavailableException("Hi!"));
        responsesByAddress.put(ClusterCompositionUtil.D, new IOException("Hi!"));
        responsesByAddress.put(ClusterCompositionUtil.E, expectedComposition);
        ClusterCompositionProvider compositionProvider = RediscoveryTest.compositionProviderMock(responsesByAddress);
        ServerAddressResolver resolver = RediscoveryTest.resolverMock(initialRouter, ClusterCompositionUtil.D, ClusterCompositionUtil.E);
        Rediscovery rediscovery = this.newRediscovery(initialRouter, compositionProvider, resolver);
        RoutingTable table = RediscoveryTest.routingTableMock(ClusterCompositionUtil.B, ClusterCompositionUtil.C);
        ClusterComposition actualComposition = ((ClusterCompositionLookupResult)TestUtil.await(rediscovery.lookupClusterComposition(table, this.pool, InternalBookmark.empty(), null))).getClusterComposition();
        Assertions.assertEquals((Object)expectedComposition, (Object)actualComposition);
        ((RoutingTable)Mockito.verify((Object)table)).forget(ClusterCompositionUtil.B);
        ((RoutingTable)Mockito.verify((Object)table)).forget(ClusterCompositionUtil.C);
        ((RoutingTable)Mockito.verify((Object)table)).forget(ClusterCompositionUtil.D);
    }

    @Test
    void shouldResolveInitialRouterAddressUsingCustomResolver() {
        ClusterComposition expectedComposition = new ClusterComposition(42L, TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C), TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C), TestUtil.asOrderedSet(ClusterCompositionUtil.B, ClusterCompositionUtil.E), null);
        ServerAddressResolver resolver = address -> {
            Assertions.assertEquals((Object)ClusterCompositionUtil.A, (Object)address);
            return TestUtil.asOrderedSet(ClusterCompositionUtil.B, ClusterCompositionUtil.C, ClusterCompositionUtil.E);
        };
        HashMap<BoltServerAddress, Object> responsesByAddress = new HashMap<BoltServerAddress, Object>();
        responsesByAddress.put(ClusterCompositionUtil.B, (Object)new ServiceUnavailableException("Hi!"));
        responsesByAddress.put(ClusterCompositionUtil.C, (Object)new ServiceUnavailableException("Hi!"));
        responsesByAddress.put(ClusterCompositionUtil.E, expectedComposition);
        ClusterCompositionProvider compositionProvider = RediscoveryTest.compositionProviderMock(responsesByAddress);
        Rediscovery rediscovery = this.newRediscovery(ClusterCompositionUtil.A, compositionProvider, resolver);
        RoutingTable table = RediscoveryTest.routingTableMock(ClusterCompositionUtil.B, ClusterCompositionUtil.C);
        ClusterComposition actualComposition = ((ClusterCompositionLookupResult)TestUtil.await(rediscovery.lookupClusterComposition(table, this.pool, InternalBookmark.empty(), null))).getClusterComposition();
        Assertions.assertEquals((Object)expectedComposition, (Object)actualComposition);
        ((RoutingTable)Mockito.verify((Object)table)).forget(ClusterCompositionUtil.B);
        ((RoutingTable)Mockito.verify((Object)table)).forget(ClusterCompositionUtil.C);
    }

    @Test
    void shouldPropagateFailureWhenResolverFails() {
        ClusterComposition expectedComposition = new ClusterComposition(42L, TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B), TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B), TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B), null);
        Map<BoltServerAddress, ClusterComposition> responsesByAddress = Collections.singletonMap(ClusterCompositionUtil.A, expectedComposition);
        ClusterCompositionProvider compositionProvider = RediscoveryTest.compositionProviderMock(responsesByAddress);
        ServerAddressResolver resolver = (ServerAddressResolver)Mockito.mock(ServerAddressResolver.class);
        Mockito.when((Object)resolver.resolve((ServerAddress)ClusterCompositionUtil.A)).thenThrow(new Throwable[]{new RuntimeException("Resolver fails!")});
        Rediscovery rediscovery = this.newRediscovery(ClusterCompositionUtil.A, compositionProvider, resolver);
        RoutingTable table = RediscoveryTest.routingTableMock(new BoltServerAddress[0]);
        RuntimeException error = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TestUtil.await(rediscovery.lookupClusterComposition(table, this.pool, InternalBookmark.empty(), null)));
        Assertions.assertEquals((Object)"Resolver fails!", (Object)error.getMessage());
        ((ServerAddressResolver)Mockito.verify((Object)resolver)).resolve((ServerAddress)ClusterCompositionUtil.A);
        ((RoutingTable)Mockito.verify((Object)table, (VerificationMode)Mockito.never())).forget((BoltServerAddress)ArgumentMatchers.any());
    }

    @Test
    void shouldRecordAllErrorsWhenNoRouterRespond() {
        HashMap<BoltServerAddress, Object> responsesByAddress = new HashMap<BoltServerAddress, Object>();
        ServiceUnavailableException first = new ServiceUnavailableException("Hi!");
        responsesByAddress.put(ClusterCompositionUtil.A, (Object)first);
        SessionExpiredException second = new SessionExpiredException("Hi!");
        responsesByAddress.put(ClusterCompositionUtil.B, second);
        IOException third = new IOException("Hi!");
        responsesByAddress.put(ClusterCompositionUtil.C, third);
        ClusterCompositionProvider compositionProvider = RediscoveryTest.compositionProviderMock(responsesByAddress);
        Rediscovery rediscovery = this.newRediscovery(ClusterCompositionUtil.A, compositionProvider, (ServerAddressResolver)Mockito.mock(ServerAddressResolver.class));
        RoutingTable table = RediscoveryTest.routingTableMock(ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C);
        ServiceUnavailableException e = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> TestUtil.await(rediscovery.lookupClusterComposition(table, this.pool, InternalBookmark.empty(), null)));
        Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Could not perform discovery"));
        Assert.assertThat((Object)e.getSuppressed().length, (Matcher)CoreMatchers.equalTo((Object)3));
        Assert.assertThat((Object)e.getSuppressed()[0].getCause(), (Matcher)CoreMatchers.equalTo((Object)((Object)first)));
        Assert.assertThat((Object)e.getSuppressed()[1].getCause(), (Matcher)CoreMatchers.equalTo((Object)second));
        Assert.assertThat((Object)e.getSuppressed()[2].getCause(), (Matcher)CoreMatchers.equalTo((Object)third));
    }

    @Test
    void shouldUseInitialRouterAfterDiscoveryReturnsNoWriters() {
        BoltServerAddress initialRouter = ClusterCompositionUtil.A;
        ClusterComposition noWritersComposition = new ClusterComposition(42L, TestUtil.asOrderedSet(ClusterCompositionUtil.D, ClusterCompositionUtil.E), Collections.emptySet(), TestUtil.asOrderedSet(ClusterCompositionUtil.D, ClusterCompositionUtil.E), null);
        ClusterComposition validComposition = new ClusterComposition(42L, TestUtil.asOrderedSet(ClusterCompositionUtil.B, ClusterCompositionUtil.A), TestUtil.asOrderedSet(ClusterCompositionUtil.B, ClusterCompositionUtil.A), TestUtil.asOrderedSet(ClusterCompositionUtil.B, ClusterCompositionUtil.A), null);
        HashMap<BoltServerAddress, Object> responsesByAddress = new HashMap<BoltServerAddress, Object>();
        responsesByAddress.put(initialRouter, validComposition);
        ClusterCompositionProvider compositionProvider = RediscoveryTest.compositionProviderMock(responsesByAddress);
        ServerAddressResolver resolver = RediscoveryTest.resolverMock(initialRouter, initialRouter);
        Rediscovery rediscovery = this.newRediscovery(initialRouter, compositionProvider, resolver);
        ClusterRoutingTable table = new ClusterRoutingTable(DatabaseNameUtil.defaultDatabase(), (Clock)new FakeClock(), new BoltServerAddress[0]);
        table.update(noWritersComposition);
        ClusterComposition composition2 = ((ClusterCompositionLookupResult)TestUtil.await(rediscovery.lookupClusterComposition((RoutingTable)table, this.pool, InternalBookmark.empty(), null))).getClusterComposition();
        Assertions.assertEquals((Object)validComposition, (Object)composition2);
    }

    @Test
    void shouldUseInitialRouterToStartWith() {
        BoltServerAddress initialRouter = ClusterCompositionUtil.A;
        ClusterComposition validComposition = new ClusterComposition(42L, TestUtil.asOrderedSet(ClusterCompositionUtil.A), TestUtil.asOrderedSet(ClusterCompositionUtil.A), TestUtil.asOrderedSet(ClusterCompositionUtil.A), null);
        HashMap<BoltServerAddress, Object> responsesByAddress = new HashMap<BoltServerAddress, Object>();
        responsesByAddress.put(initialRouter, validComposition);
        ClusterCompositionProvider compositionProvider = RediscoveryTest.compositionProviderMock(responsesByAddress);
        ServerAddressResolver resolver = RediscoveryTest.resolverMock(initialRouter, initialRouter);
        Rediscovery rediscovery = this.newRediscovery(initialRouter, compositionProvider, resolver);
        RoutingTable table = RediscoveryTest.routingTableMock(true, ClusterCompositionUtil.B, ClusterCompositionUtil.C, ClusterCompositionUtil.D);
        ClusterComposition composition = ((ClusterCompositionLookupResult)TestUtil.await(rediscovery.lookupClusterComposition(table, this.pool, InternalBookmark.empty(), null))).getClusterComposition();
        Assertions.assertEquals((Object)validComposition, (Object)composition);
    }

    @Test
    void shouldUseKnownRoutersWhenInitialRouterFails() {
        BoltServerAddress initialRouter = ClusterCompositionUtil.A;
        ClusterComposition validComposition = new ClusterComposition(42L, TestUtil.asOrderedSet(ClusterCompositionUtil.D, ClusterCompositionUtil.E), TestUtil.asOrderedSet(ClusterCompositionUtil.E, ClusterCompositionUtil.D), TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.B), null);
        HashMap<BoltServerAddress, Object> responsesByAddress = new HashMap<BoltServerAddress, Object>();
        responsesByAddress.put(initialRouter, (Object)new ServiceUnavailableException("Hi"));
        responsesByAddress.put(ClusterCompositionUtil.D, new IOException("Hi"));
        responsesByAddress.put(ClusterCompositionUtil.E, validComposition);
        ClusterCompositionProvider compositionProvider = RediscoveryTest.compositionProviderMock(responsesByAddress);
        ServerAddressResolver resolver = RediscoveryTest.resolverMock(initialRouter, initialRouter);
        Rediscovery rediscovery = this.newRediscovery(initialRouter, compositionProvider, resolver);
        RoutingTable table = RediscoveryTest.routingTableMock(true, ClusterCompositionUtil.D, ClusterCompositionUtil.E);
        ClusterComposition composition = ((ClusterCompositionLookupResult)TestUtil.await(rediscovery.lookupClusterComposition(table, this.pool, InternalBookmark.empty(), null))).getClusterComposition();
        Assertions.assertEquals((Object)validComposition, (Object)composition);
        ((RoutingTable)Mockito.verify((Object)table)).forget(initialRouter);
        ((RoutingTable)Mockito.verify((Object)table)).forget(ClusterCompositionUtil.D);
    }

    @Test
    void shouldRetryConfiguredNumberOfTimesWithDelay() {
        int maxRoutingFailures = 3;
        long retryTimeoutDelay = 15L;
        ClusterComposition expectedComposition = new ClusterComposition(42L, TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.C), TestUtil.asOrderedSet(ClusterCompositionUtil.B, ClusterCompositionUtil.D), TestUtil.asOrderedSet(ClusterCompositionUtil.A, ClusterCompositionUtil.E), null);
        HashMap<BoltServerAddress, Object> responsesByAddress = new HashMap<BoltServerAddress, Object>();
        responsesByAddress.put(ClusterCompositionUtil.A, (Object)new ServiceUnavailableException("Hi!"));
        responsesByAddress.put(ClusterCompositionUtil.B, (Object)new ServiceUnavailableException("Hi!"));
        responsesByAddress.put(ClusterCompositionUtil.E, expectedComposition);
        ClusterCompositionProvider compositionProvider = RediscoveryTest.compositionProviderMock(responsesByAddress);
        ServerAddressResolver resolver = (ServerAddressResolver)Mockito.mock(ServerAddressResolver.class);
        Mockito.when((Object)resolver.resolve((ServerAddress)ClusterCompositionUtil.A)).thenReturn(TestUtil.asOrderedSet(ClusterCompositionUtil.A)).thenReturn(TestUtil.asOrderedSet(ClusterCompositionUtil.A)).thenReturn(TestUtil.asOrderedSet(ClusterCompositionUtil.E));
        ImmediateSchedulingEventExecutor eventExecutor = new ImmediateSchedulingEventExecutor();
        RoutingSettings settings = new RoutingSettings(maxRoutingFailures, retryTimeoutDelay, 0L);
        RediscoveryImpl rediscovery = new RediscoveryImpl(ClusterCompositionUtil.A, settings, compositionProvider, (EventExecutorGroup)eventExecutor, resolver, DevNullLogging.DEV_NULL_LOGGING, (DomainNameResolver)DefaultDomainNameResolver.getInstance());
        RoutingTable table = RediscoveryTest.routingTableMock(ClusterCompositionUtil.A, ClusterCompositionUtil.B);
        ClusterComposition actualComposition = ((ClusterCompositionLookupResult)TestUtil.await(rediscovery.lookupClusterComposition(table, this.pool, InternalBookmark.empty(), null))).getClusterComposition();
        Assertions.assertEquals((Object)expectedComposition, (Object)actualComposition);
        ((RoutingTable)Mockito.verify((Object)table, (VerificationMode)Mockito.times((int)maxRoutingFailures))).forget(ClusterCompositionUtil.A);
        ((RoutingTable)Mockito.verify((Object)table, (VerificationMode)Mockito.times((int)maxRoutingFailures))).forget(ClusterCompositionUtil.B);
        Assertions.assertEquals(Arrays.asList(retryTimeoutDelay, retryTimeoutDelay * 2L), eventExecutor.scheduleDelays());
    }

    @Test
    void shouldNotLogWhenSingleRetryAttemptFails() {
        int maxRoutingFailures = 1;
        long retryTimeoutDelay = 10L;
        Map<BoltServerAddress, ServiceUnavailableException> responsesByAddress = Collections.singletonMap(ClusterCompositionUtil.A, new ServiceUnavailableException("Hi!"));
        ClusterCompositionProvider compositionProvider = RediscoveryTest.compositionProviderMock(responsesByAddress);
        ServerAddressResolver resolver = RediscoveryTest.resolverMock(ClusterCompositionUtil.A, ClusterCompositionUtil.A);
        ImmediateSchedulingEventExecutor eventExecutor = new ImmediateSchedulingEventExecutor();
        RoutingSettings settings = new RoutingSettings(maxRoutingFailures, retryTimeoutDelay, 0L);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        RediscoveryImpl rediscovery = new RediscoveryImpl(ClusterCompositionUtil.A, settings, compositionProvider, (EventExecutorGroup)eventExecutor, resolver, logging, (DomainNameResolver)DefaultDomainNameResolver.getInstance());
        RoutingTable table = RediscoveryTest.routingTableMock(ClusterCompositionUtil.A);
        ServiceUnavailableException e = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> this.lambda$shouldNotLogWhenSingleRetryAttemptFails$6((Rediscovery)rediscovery, table));
        Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Could not perform discovery"));
        ((Logging)Mockito.verify((Object)logging)).getLog(RediscoveryImpl.class);
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.never())).info(Mockito.startsWith((String)"Unable to fetch new routing table, will try again in "), new Object[0]);
        Assertions.assertEquals((int)0, (int)eventExecutor.scheduleDelays().size());
    }

    @Test
    void shouldResolveToIP() throws UnknownHostException {
        ServerAddressResolver resolver = RediscoveryTest.resolverMock(ClusterCompositionUtil.A, ClusterCompositionUtil.A);
        DomainNameResolver domainNameResolver = (DomainNameResolver)Mockito.mock(DomainNameResolver.class);
        InetAddress localhost = InetAddress.getLocalHost();
        Mockito.when((Object)domainNameResolver.resolve(ClusterCompositionUtil.A.host())).thenReturn((Object)new InetAddress[]{localhost});
        RediscoveryImpl rediscovery = new RediscoveryImpl(ClusterCompositionUtil.A, null, null, null, resolver, DevNullLogging.DEV_NULL_LOGGING, domainNameResolver);
        List addresses = rediscovery.resolve();
        ((ServerAddressResolver)Mockito.verify((Object)resolver, (VerificationMode)Mockito.times((int)1))).resolve((ServerAddress)ClusterCompositionUtil.A);
        ((DomainNameResolver)Mockito.verify((Object)domainNameResolver, (VerificationMode)Mockito.times((int)1))).resolve(ClusterCompositionUtil.A.host());
        Assertions.assertEquals((int)1, (int)addresses.size());
        Assertions.assertEquals((Object)new BoltServerAddress(ClusterCompositionUtil.A.host(), localhost.getHostAddress(), ClusterCompositionUtil.A.port()), addresses.get(0));
    }

    private Rediscovery newRediscovery(BoltServerAddress initialRouter, ClusterCompositionProvider compositionProvider, ServerAddressResolver resolver) {
        return this.newRediscovery(initialRouter, compositionProvider, resolver, DevNullLogging.DEV_NULL_LOGGING);
    }

    private Rediscovery newRediscovery(BoltServerAddress initialRouter, ClusterCompositionProvider compositionProvider, ServerAddressResolver resolver, Logging logging) {
        RoutingSettings settings = new RoutingSettings(1, 0L, 0L);
        return new RediscoveryImpl(initialRouter, settings, compositionProvider, (EventExecutorGroup)GlobalEventExecutor.INSTANCE, resolver, logging, (DomainNameResolver)DefaultDomainNameResolver.getInstance());
    }

    private static ClusterCompositionProvider compositionProviderMock(Map<BoltServerAddress, Object> responsesByAddress) {
        ClusterCompositionProvider provider = (ClusterCompositionProvider)Mockito.mock(ClusterCompositionProvider.class);
        Mockito.when((Object)provider.getClusterComposition((Connection)ArgumentMatchers.any(Connection.class), (DatabaseName)ArgumentMatchers.any(DatabaseName.class), (Bookmark)ArgumentMatchers.any(InternalBookmark.class), (String)ArgumentMatchers.any())).then(invocation -> {
            Connection connection = (Connection)invocation.getArgument(0);
            BoltServerAddress address = connection.serverAddress();
            Object response = responsesByAddress.get(address);
            Assertions.assertNotNull(response);
            if (response instanceof Throwable) {
                return Futures.failedFuture((Throwable)((Throwable)response));
            }
            return CompletableFuture.completedFuture(response);
        });
        return provider;
    }

    private static ServerAddressResolver resolverMock(BoltServerAddress address, BoltServerAddress ... resolved) {
        ServerAddressResolver resolver = (ServerAddressResolver)Mockito.mock(ServerAddressResolver.class);
        Mockito.when((Object)resolver.resolve((ServerAddress)address)).thenReturn(TestUtil.asOrderedSet(resolved));
        return resolver;
    }

    private static ConnectionPool asyncConnectionPoolMock() {
        ConnectionPool pool = (ConnectionPool)Mockito.mock(ConnectionPool.class);
        Mockito.when((Object)pool.acquire((BoltServerAddress)ArgumentMatchers.any())).then(invocation -> {
            BoltServerAddress address = (BoltServerAddress)invocation.getArgument(0);
            return CompletableFuture.completedFuture(RediscoveryTest.asyncConnectionMock(address));
        });
        return pool;
    }

    private static Connection asyncConnectionMock(BoltServerAddress address) {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.serverAddress()).thenReturn((Object)address);
        return connection;
    }

    private static RoutingTable routingTableMock(BoltServerAddress ... routers) {
        return RediscoveryTest.routingTableMock(false, routers);
    }

    private static RoutingTable routingTableMock(boolean preferInitialRouter, BoltServerAddress ... routers) {
        RoutingTable routingTable = (RoutingTable)Mockito.mock(RoutingTable.class);
        Mockito.when((Object)routingTable.routers()).thenReturn(Arrays.asList(routers));
        Mockito.when((Object)routingTable.database()).thenReturn((Object)DatabaseNameUtil.defaultDatabase());
        Mockito.when((Object)routingTable.preferInitialRouter()).thenReturn((Object)preferInitialRouter);
        return routingTable;
    }

    private /* synthetic */ void lambda$shouldNotLogWhenSingleRetryAttemptFails$6(Rediscovery rediscovery, RoutingTable table) throws Throwable {
        TestUtil.await(rediscovery.lookupClusterComposition(table, this.pool, InternalBookmark.empty(), null));
    }
}

