/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.outbound;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.IOException;
import java.util.HashMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.Query;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.async.outbound.OutboundMessageHandler;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.request.PullAllMessage;
import org.neo4j.driver.internal.messaging.v3.MessageFormatV3;
import org.neo4j.driver.internal.packstream.PackOutput;
import org.neo4j.driver.internal.value.BytesValue;
import org.neo4j.driver.util.TestUtil;

class OutboundMessageHandlerTest {
    private final EmbeddedChannel channel = new EmbeddedChannel();

    OutboundMessageHandlerTest() {
    }

    @BeforeEach
    void setUp() {
        ChannelAttributes.setMessageDispatcher((Channel)this.channel, (InboundMessageDispatcher)new InboundMessageDispatcher((Channel)this.channel, DevNullLogging.DEV_NULL_LOGGING));
    }

    @AfterEach
    void tearDown() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    void shouldOutputByteBufAsWrittenByWriterAndMessageBoundary() {
        MessageFormat messageFormat = OutboundMessageHandlerTest.mockMessageFormatWithWriter(1, 2, 3, 4, 5);
        OutboundMessageHandler handler = OutboundMessageHandlerTest.newHandler(messageFormat);
        this.channel.pipeline().addLast(new ChannelHandler[]{handler});
        Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{PullAllMessage.PULL_ALL}));
        Assertions.assertTrue((boolean)this.channel.finish());
        Assertions.assertEquals((int)1, (int)this.channel.outboundMessages().size());
        ByteBuf buf = (ByteBuf)this.channel.readOutbound();
        TestUtil.assertByteBufContains(buf, (short)5, (byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)0, (byte)0);
    }

    @Test
    void shouldSupportByteArraysByDefault() {
        OutboundMessageHandler handler = OutboundMessageHandlerTest.newHandler((MessageFormat)new MessageFormatV3());
        this.channel.pipeline().addLast(new ChannelHandler[]{handler});
        HashMap<String, BytesValue> params = new HashMap<String, BytesValue>();
        params.put("array", Values.value((byte[])new byte[]{1, 2, 3}));
        Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{new Query("RETURN 1", Values.value(params))}));
        Assertions.assertTrue((boolean)this.channel.finish());
    }

    private static MessageFormat mockMessageFormatWithWriter(int ... bytesToWrite) {
        MessageFormat messageFormat = (MessageFormat)Mockito.mock(MessageFormat.class);
        Mockito.when((Object)messageFormat.newWriter((PackOutput)ArgumentMatchers.any(PackOutput.class))).then(invocation -> {
            PackOutput output = (PackOutput)invocation.getArgument(0);
            return OutboundMessageHandlerTest.mockWriter(output, bytesToWrite);
        });
        return messageFormat;
    }

    private static MessageFormat.Writer mockWriter(PackOutput output, int ... bytesToWrite) throws IOException {
        MessageFormat.Writer writer = (MessageFormat.Writer)Mockito.mock(MessageFormat.Writer.class);
        ((MessageFormat.Writer)Mockito.doAnswer(invocation -> {
            for (int b : bytesToWrite) {
                output.writeByte((byte)b);
            }
            return writer;
        }).when((Object)writer)).write((Message)ArgumentMatchers.any(Message.class));
        return writer;
    }

    private static OutboundMessageHandler newHandler(MessageFormat messageFormat) {
        return new OutboundMessageHandler(messageFormat, DevNullLogging.DEV_NULL_LOGGING);
    }
}

