/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderException;
import java.io.IOException;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.async.inbound.InboundMessageHandler;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.ResponseMessageHandler;
import org.neo4j.driver.internal.messaging.request.ResetMessage;
import org.neo4j.driver.internal.messaging.response.FailureMessage;
import org.neo4j.driver.internal.messaging.response.IgnoredMessage;
import org.neo4j.driver.internal.messaging.response.RecordMessage;
import org.neo4j.driver.internal.messaging.response.SuccessMessage;
import org.neo4j.driver.internal.messaging.v3.MessageFormatV3;
import org.neo4j.driver.internal.packstream.PackInput;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.io.MessageToByteBufWriter;
import org.neo4j.driver.internal.util.messaging.KnowledgeableMessageFormat;

class InboundMessageHandlerTest {
    private EmbeddedChannel channel;
    private InboundMessageDispatcher messageDispatcher;
    private MessageToByteBufWriter writer;

    InboundMessageHandlerTest() {
    }

    @BeforeEach
    void setUp() {
        this.channel = new EmbeddedChannel();
        this.messageDispatcher = new InboundMessageDispatcher((Channel)this.channel, DevNullLogging.DEV_NULL_LOGGING);
        this.writer = new MessageToByteBufWriter((MessageFormat)new KnowledgeableMessageFormat());
        ChannelAttributes.setMessageDispatcher((Channel)this.channel, (InboundMessageDispatcher)this.messageDispatcher);
        InboundMessageHandler handler = new InboundMessageHandler((MessageFormat)new MessageFormatV3(), DevNullLogging.DEV_NULL_LOGGING);
        this.channel.pipeline().addFirst(new ChannelHandler[]{handler});
    }

    @AfterEach
    void tearDown() {
        if (this.channel != null) {
            this.channel.finishAndReleaseAll();
        }
    }

    @Test
    void shouldReadSuccessMessage() {
        ResponseHandler responseHandler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        this.messageDispatcher.enqueue(responseHandler);
        HashMap<String, Value> metadata = new HashMap<String, Value>();
        metadata.put("key1", Values.value((int)1));
        metadata.put("key2", Values.value((int)2));
        this.channel.writeInbound(new Object[]{this.writer.asByteBuf((Message)new SuccessMessage(metadata))});
        ((ResponseHandler)Mockito.verify((Object)responseHandler)).onSuccess(metadata);
    }

    @Test
    void shouldReadFailureMessage() {
        ResponseHandler responseHandler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        this.messageDispatcher.enqueue(responseHandler);
        this.channel.writeInbound(new Object[]{this.writer.asByteBuf((Message)new FailureMessage("Neo.TransientError.General.ReadOnly", "Hi!"))});
        ArgumentCaptor captor = ArgumentCaptor.forClass(Neo4jException.class);
        ((ResponseHandler)Mockito.verify((Object)responseHandler)).onFailure((Throwable)captor.capture());
        Assertions.assertEquals((Object)"Neo.TransientError.General.ReadOnly", (Object)((Neo4jException)captor.getValue()).code());
        Assertions.assertEquals((Object)"Hi!", (Object)((Neo4jException)captor.getValue()).getMessage());
    }

    @Test
    void shouldReadRecordMessage() {
        ResponseHandler responseHandler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        this.messageDispatcher.enqueue(responseHandler);
        Value[] fields = new Value[]{Values.value((int)1), Values.value((int)2), Values.value((int)3)};
        this.channel.writeInbound(new Object[]{this.writer.asByteBuf((Message)new RecordMessage(fields))});
        ((ResponseHandler)Mockito.verify((Object)responseHandler)).onRecord(fields);
    }

    @Test
    void shouldReadIgnoredMessage() {
        ResponseHandler responseHandler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        this.messageDispatcher.enqueue(responseHandler);
        this.channel.writeInbound(new Object[]{this.writer.asByteBuf((Message)IgnoredMessage.IGNORED)});
        Assertions.assertEquals((int)0, (int)this.messageDispatcher.queuedHandlersCount());
    }

    @Test
    void shouldRethrowReadErrors() throws IOException {
        MessageFormat messageFormat = (MessageFormat)Mockito.mock(MessageFormat.class);
        MessageFormat.Reader reader = (MessageFormat.Reader)Mockito.mock(MessageFormat.Reader.class);
        RuntimeException error = new RuntimeException("Unable to decode!");
        ((MessageFormat.Reader)Mockito.doThrow((Throwable[])new Throwable[]{error}).when((Object)reader)).read((ResponseMessageHandler)ArgumentMatchers.any());
        Mockito.when((Object)messageFormat.newReader((PackInput)ArgumentMatchers.any())).thenReturn((Object)reader);
        InboundMessageHandler handler = new InboundMessageHandler(messageFormat, DevNullLogging.DEV_NULL_LOGGING);
        this.channel.pipeline().remove(InboundMessageHandler.class);
        this.channel.pipeline().addLast(new ChannelHandler[]{handler});
        DecoderException e = (DecoderException)Assertions.assertThrows(DecoderException.class, () -> this.channel.writeInbound(new Object[]{this.writer.asByteBuf((Message)ResetMessage.RESET)}));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Failed to read inbound message"));
    }
}

