/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import io.netty.buffer.ByteBuf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.internal.async.inbound.ByteBufInput;

class ByteBufInputTest {
    ByteBufInputTest() {
    }

    @Test
    void shouldThrowWhenStartedWithNullBuf() {
        ByteBufInput input = new ByteBufInput();
        Assertions.assertThrows(NullPointerException.class, () -> input.start(null));
    }

    @Test
    void shouldThrowWhenStartedTwice() {
        ByteBufInput input = new ByteBufInput();
        input.start((ByteBuf)Mockito.mock(ByteBuf.class));
        Assertions.assertThrows(IllegalStateException.class, () -> input.start((ByteBuf)Mockito.mock(ByteBuf.class)));
    }

    @Test
    void shouldDelegateReadByte() {
        ByteBufInput input = new ByteBufInput();
        ByteBuf buf = (ByteBuf)Mockito.mock(ByteBuf.class);
        Mockito.when((Object)buf.readByte()).thenReturn((Object)42);
        input.start(buf);
        Assertions.assertEquals((byte)42, (byte)input.readByte());
    }

    @Test
    void shouldDelegateReadShort() {
        ByteBufInput input = new ByteBufInput();
        ByteBuf buf = (ByteBuf)Mockito.mock(ByteBuf.class);
        Mockito.when((Object)buf.readShort()).thenReturn((Object)-42);
        input.start(buf);
        Assertions.assertEquals((short)-42, (short)input.readShort());
    }

    @Test
    void shouldDelegateReadInt() {
        ByteBufInput input = new ByteBufInput();
        ByteBuf buf = (ByteBuf)Mockito.mock(ByteBuf.class);
        Mockito.when((Object)buf.readInt()).thenReturn((Object)15);
        input.start(buf);
        Assertions.assertEquals((int)15, (int)input.readInt());
    }

    @Test
    void shouldDelegateReadLong() {
        ByteBufInput input = new ByteBufInput();
        ByteBuf buf = (ByteBuf)Mockito.mock(ByteBuf.class);
        Mockito.when((Object)buf.readLong()).thenReturn((Object)4242L);
        input.start(buf);
        Assertions.assertEquals((long)4242L, (long)input.readLong());
    }

    @Test
    void shouldDelegateReadDouble() {
        ByteBufInput input = new ByteBufInput();
        ByteBuf buf = (ByteBuf)Mockito.mock(ByteBuf.class);
        Mockito.when((Object)buf.readDouble()).thenReturn((Object)42.42);
        input.start(buf);
        Assertions.assertEquals((double)42.42, (double)input.readDouble(), (double)1.0E-5);
    }

    @Test
    void shouldDelegateReadBytes() {
        ByteBufInput input = new ByteBufInput();
        ByteBuf buf = (ByteBuf)Mockito.mock(ByteBuf.class);
        input.start(buf);
        input.readBytes(new byte[10], 3, 5);
        ((ByteBuf)Mockito.verify((Object)buf)).readBytes(new byte[10], 3, 5);
    }

    @Test
    void shouldDelegatePeekByte() {
        ByteBufInput input = new ByteBufInput();
        ByteBuf buf = (ByteBuf)Mockito.mock(ByteBuf.class);
        Mockito.when((Object)buf.getByte(ArgumentMatchers.anyInt())).thenReturn((Object)42);
        input.start(buf);
        Assertions.assertEquals((byte)42, (byte)input.peekByte());
    }
}

