/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.DefaultBookmarkHolder;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.async.LeakLoggingNetworkSession;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.util.FixedRetryLogic;
import org.neo4j.driver.util.TestUtil;

class LeakLoggingNetworkSessionTest {
    LeakLoggingNetworkSessionTest() {
    }

    @Test
    void logsNothingDuringFinalizationIfClosed() throws Exception {
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger log = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)log);
        LeakLoggingNetworkSession session = LeakLoggingNetworkSessionTest.newSession(logging, false);
        LeakLoggingNetworkSessionTest.finalize((NetworkSession)session);
        ((Logger)Mockito.verify((Object)log, (VerificationMode)Mockito.never())).error(ArgumentMatchers.anyString(), (Throwable)ArgumentMatchers.any(Throwable.class));
    }

    @Test
    void logsMessageWithStacktraceDuringFinalizationIfLeaked(TestInfo testInfo) throws Exception {
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger log = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)log);
        LeakLoggingNetworkSession session = LeakLoggingNetworkSessionTest.newSession(logging, true);
        session.beginTransactionAsync(TransactionConfig.empty());
        LeakLoggingNetworkSessionTest.finalize((NetworkSession)session);
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(String.class);
        ((Logger)Mockito.verify((Object)log)).error((String)messageCaptor.capture(), (Throwable)ArgumentMatchers.any());
        Assertions.assertEquals((int)1, (int)messageCaptor.getAllValues().size());
        String loggedMessage = (String)messageCaptor.getValue();
        MatcherAssert.assertThat((Object)loggedMessage, (Matcher)Matchers.containsString((String)"Neo4j Session object leaked"));
        MatcherAssert.assertThat((Object)loggedMessage, (Matcher)Matchers.containsString((String)"Session was create at"));
        MatcherAssert.assertThat((Object)loggedMessage, (Matcher)Matchers.containsString((String)(this.getClass().getSimpleName() + "." + ((Method)testInfo.getTestMethod().get()).getName())));
    }

    private static void finalize(NetworkSession session) throws Exception {
        Method finalizeMethod = session.getClass().getDeclaredMethod("finalize", new Class[0]);
        finalizeMethod.setAccessible(true);
        finalizeMethod.invoke((Object)session, new Object[0]);
    }

    private static LeakLoggingNetworkSession newSession(Logging logging, boolean openConnection) {
        return new LeakLoggingNetworkSession(LeakLoggingNetworkSessionTest.connectionProviderMock(openConnection), (RetryLogic)new FixedRetryLogic(0), DatabaseNameUtil.defaultDatabase(), AccessMode.READ, (BookmarkHolder)new DefaultBookmarkHolder(), null, -1L, logging);
    }

    private static ConnectionProvider connectionProviderMock(boolean openConnection) {
        ConnectionProvider provider = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        Connection connection = LeakLoggingNetworkSessionTest.connectionMock(openConnection);
        Mockito.when((Object)provider.acquireConnection((ConnectionContext)ArgumentMatchers.any(ConnectionContext.class))).thenReturn(CompletableFuture.completedFuture(connection));
        return provider;
    }

    private static Connection connectionMock(boolean open) {
        Connection connection = TestUtil.connectionMock(TestUtil.DEFAULT_TEST_PROTOCOL);
        Mockito.when((Object)connection.isOpen()).thenReturn((Object)open);
        return connection;
    }
}

