/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalNode;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.types.Node;

class SelfContainedNodeTest {
    SelfContainedNodeTest() {
    }

    private Node adamTheNode() {
        return new InternalNode(1L, Collections.singletonList("Person"), Values.parameters((Object[])new Object[]{"name", Values.value((String)"Adam")}).asMap(Values.ofValue()));
    }

    @Test
    void testIdentity() {
        Node node = this.adamTheNode();
        MatcherAssert.assertThat((Object)node.id(), (Matcher)IsEqual.equalTo((Object)1L));
    }

    @Test
    void testLabels() {
        Node node = this.adamTheNode();
        List labels = Iterables.asList((Iterable)node.labels());
        MatcherAssert.assertThat((Object)labels.size(), (Matcher)IsEqual.equalTo((Object)1));
        MatcherAssert.assertThat((Object)labels.contains("Person"), (Matcher)IsEqual.equalTo((Object)true));
    }

    @Test
    void testKeys() {
        Node node = this.adamTheNode();
        List keys = Iterables.asList((Iterable)node.keys());
        MatcherAssert.assertThat((Object)keys.size(), (Matcher)IsEqual.equalTo((Object)1));
        MatcherAssert.assertThat((Object)keys.contains("name"), (Matcher)IsEqual.equalTo((Object)true));
    }

    @Test
    void testValue() {
        Node node = this.adamTheNode();
        MatcherAssert.assertThat((Object)node.get("name").asString(), (Matcher)IsEqual.equalTo((Object)"Adam"));
    }
}

