/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalNode;

class InternalNodeTest {
    InternalNodeTest() {
    }

    @Test
    void extractValuesFromNode() {
        InternalNode node = this.createNode();
        Function<Value, Integer> extractor = Value::asInt;
        Iterable values = node.values(extractor);
        Iterator iterator = values.iterator();
        MatcherAssert.assertThat((Object)((Integer)iterator.next()), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((Integer)iterator.next()), (Matcher)CoreMatchers.equalTo((Object)2));
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void accessUnknownKeyShouldBeNull() {
        InternalNode node = this.createNode();
        MatcherAssert.assertThat((Object)node.get("k1"), (Matcher)CoreMatchers.equalTo((Object)Values.value((int)1)));
        MatcherAssert.assertThat((Object)node.get("k2"), (Matcher)CoreMatchers.equalTo((Object)Values.value((int)2)));
        MatcherAssert.assertThat((Object)node.get("k3"), (Matcher)CoreMatchers.equalTo((Object)Values.NULL));
    }

    private InternalNode createNode() {
        HashMap<String, Value> props = new HashMap<String, Value>();
        props.put("k1", Values.value((int)1));
        props.put("k2", Values.value((int)2));
        return new InternalNode(42L, Collections.singletonList("L"), props);
    }
}

