/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.InternalIsoDuration;
import org.neo4j.driver.types.IsoDuration;

class InternalIsoDurationTest {
    InternalIsoDurationTest() {
    }

    @Test
    void shouldExposeMonths() {
        IsoDuration duration = InternalIsoDurationTest.newDuration(42L, 1L, 2L, 3);
        Assertions.assertEquals((long)42L, (long)duration.months());
        Assertions.assertEquals((long)42L, (long)duration.get((TemporalUnit)ChronoUnit.MONTHS));
    }

    @Test
    void shouldExposeDays() {
        IsoDuration duration = InternalIsoDurationTest.newDuration(1L, 42L, 2L, 3);
        Assertions.assertEquals((long)42L, (long)duration.days());
        Assertions.assertEquals((long)42L, (long)duration.get((TemporalUnit)ChronoUnit.DAYS));
    }

    @Test
    void shouldExposeSeconds() {
        IsoDuration duration = InternalIsoDurationTest.newDuration(1L, 2L, 42L, 3);
        Assertions.assertEquals((long)42L, (long)duration.seconds());
        Assertions.assertEquals((long)42L, (long)duration.get((TemporalUnit)ChronoUnit.SECONDS));
    }

    @Test
    void shouldExposeNanoseconds() {
        IsoDuration duration = InternalIsoDurationTest.newDuration(1L, 2L, 3L, 42);
        Assertions.assertEquals((int)42, (int)duration.nanoseconds());
        Assertions.assertEquals((long)42L, (long)duration.get((TemporalUnit)ChronoUnit.NANOS));
    }

    @Test
    void shouldFailToGetUnsupportedTemporalUnit() {
        IsoDuration duration = InternalIsoDurationTest.newDuration(1L, 2L, 3L, 4);
        Assertions.assertThrows(UnsupportedTemporalTypeException.class, () -> duration.get((TemporalUnit)ChronoUnit.YEARS));
    }

    @Test
    void shouldExposeSupportedTemporalUnits() {
        IsoDuration duration = InternalIsoDurationTest.newDuration(1L, 2L, 3L, 4);
        Assertions.assertEquals(Arrays.asList(ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.SECONDS, ChronoUnit.NANOS), (Object)duration.getUnits());
    }

    @Test
    void shouldAddTo() {
        IsoDuration duration = InternalIsoDurationTest.newDuration(1L, 2L, 3L, 4);
        LocalDateTime dateTime = LocalDateTime.of(1990, 1, 1, 0, 0, 0, 0);
        Temporal result = duration.addTo((Temporal)dateTime);
        Assertions.assertEquals((Object)LocalDateTime.of(1990, 2, 3, 0, 0, 3, 4), (Object)result);
    }

    @Test
    void shouldSubtractFrom() {
        IsoDuration duration = InternalIsoDurationTest.newDuration(4L, 3L, 2L, 1);
        LocalDateTime dateTime = LocalDateTime.of(1990, 7, 19, 0, 0, 59, 999);
        Temporal result = duration.subtractFrom((Temporal)dateTime);
        Assertions.assertEquals((Object)LocalDateTime.of(1990, 3, 16, 0, 0, 57, 998), (Object)result);
    }

    @Test
    void shouldImplementEqualsAndHashCode() {
        IsoDuration duration1 = InternalIsoDurationTest.newDuration(1L, 2L, 3L, 4);
        IsoDuration duration2 = InternalIsoDurationTest.newDuration(1L, 2L, 3L, 4);
        Assertions.assertEquals((Object)duration1, (Object)duration2);
        Assertions.assertEquals((int)duration1.hashCode(), (int)duration2.hashCode());
    }

    @Test
    void shouldCreateFromPeriod() {
        Period period = Period.of(3, 5, 12);
        InternalIsoDuration duration = new InternalIsoDuration(period);
        Assertions.assertEquals((long)period.toTotalMonths(), (long)duration.months());
        Assertions.assertEquals((long)period.getDays(), (long)duration.days());
        Assertions.assertEquals((long)0L, (long)duration.seconds());
        Assertions.assertEquals((int)0, (int)duration.nanoseconds());
    }

    @Test
    void shouldCreateFromDuration() {
        Duration duration = Duration.ofSeconds(391784L, 4879173L);
        InternalIsoDuration isoDuration = new InternalIsoDuration(duration);
        Assertions.assertEquals((long)0L, (long)isoDuration.months());
        Assertions.assertEquals((long)0L, (long)isoDuration.days());
        Assertions.assertEquals((long)duration.getSeconds(), (long)isoDuration.seconds());
        Assertions.assertEquals((int)duration.getNano(), (int)isoDuration.nanoseconds());
    }

    @Test
    void toStringShouldPrintInIsoStandardFormat() {
        MatcherAssert.assertThat((Object)InternalIsoDurationTest.newDuration(0L, 0L, 0L, 0).toString(), (Matcher)Matchers.equalTo((Object)"P0M0DT0S"));
        MatcherAssert.assertThat((Object)InternalIsoDurationTest.newDuration(2L, 45L, 59L, 11).toString(), (Matcher)Matchers.equalTo((Object)"P2M45DT59.000000011S"));
        MatcherAssert.assertThat((Object)InternalIsoDurationTest.newDuration(4L, -101L, 1L, 999).toString(), (Matcher)Matchers.equalTo((Object)"P4M-101DT1.000000999S"));
        MatcherAssert.assertThat((Object)InternalIsoDurationTest.newDuration(-1L, 12L, -19L, 1).toString(), (Matcher)Matchers.equalTo((Object)"P-1M12DT-18.999999999S"));
        MatcherAssert.assertThat((Object)InternalIsoDurationTest.newDuration(0L, 0L, -1L, 1).toString(), (Matcher)Matchers.equalTo((Object)"P0M0DT-0.999999999S"));
        MatcherAssert.assertThat((Object)new InternalIsoDuration(Period.parse("P356D")).toString(), (Matcher)Matchers.equalTo((Object)"P0M356DT0S"));
        MatcherAssert.assertThat((Object)new InternalIsoDuration(Duration.parse("PT45S")).toString(), (Matcher)Matchers.equalTo((Object)"P0M0DT45S"));
        MatcherAssert.assertThat((Object)new InternalIsoDuration(0L, 14L, Duration.parse("PT16H12M")).toString(), (Matcher)Matchers.equalTo((Object)"P0M14DT58320S"));
        MatcherAssert.assertThat((Object)new InternalIsoDuration(5L, 1L, Duration.parse("PT12H")).toString(), (Matcher)Matchers.equalTo((Object)"P5M1DT43200S"));
        MatcherAssert.assertThat((Object)new InternalIsoDuration(0L, 17L, Duration.parse("PT2H0.111222333S")).toString(), (Matcher)Matchers.equalTo((Object)"P0M17DT7200.111222333S"));
        MatcherAssert.assertThat((Object)InternalIsoDurationTest.newDuration(42L, 42L, 42L, 0).toString(), (Matcher)Matchers.equalTo((Object)"P42M42DT42S"));
        MatcherAssert.assertThat((Object)InternalIsoDurationTest.newDuration(42L, 42L, -42L, 0).toString(), (Matcher)Matchers.equalTo((Object)"P42M42DT-42S"));
        MatcherAssert.assertThat((Object)InternalIsoDurationTest.newDuration(42L, 42L, 0L, 5).toString(), (Matcher)Matchers.equalTo((Object)"P42M42DT0.000000005S"));
        MatcherAssert.assertThat((Object)InternalIsoDurationTest.newDuration(42L, 42L, 0L, -5).toString(), (Matcher)Matchers.equalTo((Object)"P42M42DT-0.000000005S"));
        MatcherAssert.assertThat((Object)InternalIsoDurationTest.newDuration(42L, 42L, 1L, 5).toString(), (Matcher)Matchers.equalTo((Object)"P42M42DT1.000000005S"));
        MatcherAssert.assertThat((Object)InternalIsoDurationTest.newDuration(42L, 42L, -1L, 5).toString(), (Matcher)Matchers.equalTo((Object)"P42M42DT-0.999999995S"));
        MatcherAssert.assertThat((Object)InternalIsoDurationTest.newDuration(42L, 42L, 1L, -5).toString(), (Matcher)Matchers.equalTo((Object)"P42M42DT0.999999995S"));
        MatcherAssert.assertThat((Object)InternalIsoDurationTest.newDuration(42L, 42L, -1L, -5).toString(), (Matcher)Matchers.equalTo((Object)"P42M42DT-1.000000005S"));
        MatcherAssert.assertThat((Object)InternalIsoDurationTest.newDuration(42L, 42L, 28L, 9).toString(), (Matcher)Matchers.equalTo((Object)"P42M42DT28.000000009S"));
        MatcherAssert.assertThat((Object)InternalIsoDurationTest.newDuration(42L, 42L, -28L, 9).toString(), (Matcher)Matchers.equalTo((Object)"P42M42DT-27.999999991S"));
        MatcherAssert.assertThat((Object)InternalIsoDurationTest.newDuration(42L, 42L, 28L, -9).toString(), (Matcher)Matchers.equalTo((Object)"P42M42DT27.999999991S"));
        MatcherAssert.assertThat((Object)InternalIsoDurationTest.newDuration(42L, 42L, -28L, -9).toString(), (Matcher)Matchers.equalTo((Object)"P42M42DT-28.000000009S"));
    }

    private static IsoDuration newDuration(long months, long days, long seconds, int nanoseconds) {
        return new InternalIsoDuration(months, days, seconds, nanoseconds);
    }
}

