/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration.async;

import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.Record;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.AsyncTransaction;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.TestUtil;

@ParallelizableIT
class AsyncSessionServerRestartIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();
    private AsyncSession session;

    AsyncSessionServerRestartIT() {
    }

    @BeforeEach
    void setUp() {
        this.session = neo4j.driver().asyncSession();
    }

    @AfterEach
    void tearDown() {
        this.session.closeAsync();
    }

    @Test
    void shouldFailWhenServerIsRestarted() {
        int queryCount = 10000;
        String query = "UNWIND range(1, 100) AS x CREATE (n1:Node {value: x})-[r:LINKED {value: x}]->(n2:Node {value: x}) DETACH DELETE n1, n2 RETURN x";
        Assertions.assertThrows(ServiceUnavailableException.class, () -> {
            for (int i = 0; i < queryCount; ++i) {
                ResultCursor cursor = (ResultCursor)TestUtil.await(this.session.runAsync(query));
                if (i == 0) {
                    neo4j.stopDb();
                }
                List records = (List)TestUtil.await(cursor.listAsync());
                Assertions.assertEquals((int)100, (int)records.size());
            }
        });
        neo4j.startDb();
    }

    @Test
    void shouldRunAfterRunFailureToAcquireConnection() {
        neo4j.stopDb();
        Assertions.assertThrows(ServiceUnavailableException.class, () -> {
            ResultCursor cursor = (ResultCursor)TestUtil.await(this.session.runAsync("RETURN 42"));
            TestUtil.await(cursor.nextAsync());
        });
        neo4j.startDb();
        ResultCursor cursor2 = (ResultCursor)TestUtil.await(this.session.runAsync("RETURN 42"));
        Record record = (Record)TestUtil.await(cursor2.singleAsync());
        Assertions.assertEquals((int)42, (int)record.get(0).asInt());
    }

    @Test
    void shouldBeginTxAfterRunFailureToAcquireConnection() {
        neo4j.stopDb();
        Assertions.assertThrows(ServiceUnavailableException.class, () -> {
            ResultCursor cursor = (ResultCursor)TestUtil.await(this.session.runAsync("RETURN 42"));
            TestUtil.await(cursor.consumeAsync());
        });
        neo4j.startDb();
        AsyncTransaction tx = (AsyncTransaction)TestUtil.await(this.session.beginTransactionAsync());
        ResultCursor cursor2 = (ResultCursor)TestUtil.await(tx.runAsync("RETURN 42"));
        Record record = (Record)TestUtil.await(cursor2.singleAsync());
        Assertions.assertEquals((int)42, (int)record.get(0).asInt());
        Assertions.assertNull(TestUtil.await(tx.rollbackAsync()));
    }
}

