/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;
import org.neo4j.driver.internal.DriverFactory;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.internal.security.SecurityPlanImpl;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;

@ParallelizableIT
class SharedEventLoopIT {
    private final DriverFactory driverFactory = new DriverFactory();
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();

    SharedEventLoopIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testDriverShouldNotCloseSharedEventLoop() {
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(1);
        try {
            Driver driver1 = this.createDriver((EventLoopGroup)eventLoopGroup);
            Driver driver2 = this.createDriver((EventLoopGroup)eventLoopGroup);
            this.testConnection(driver1);
            this.testConnection(driver2);
            driver1.close();
            this.testConnection(driver2);
            driver2.close();
        }
        finally {
            eventLoopGroup.shutdownGracefully(100L, 100L, TimeUnit.MILLISECONDS);
        }
    }

    @Test
    void testDriverShouldUseSharedEventLoop() {
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(1);
        Driver driver = this.createDriver((EventLoopGroup)eventLoopGroup);
        this.testConnection(driver);
        eventLoopGroup.shutdownGracefully(100L, 100L, TimeUnit.MILLISECONDS);
        try {
            this.testConnection(driver);
            Assertions.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Driver createDriver(EventLoopGroup eventLoopGroup) {
        return this.driverFactory.newInstance(neo4j.uri(), neo4j.authToken(), RoutingSettings.DEFAULT, RetrySettings.DEFAULT, Config.defaultConfig(), eventLoopGroup, SecurityPlanImpl.insecure());
    }

    private void testConnection(Driver driver) {
        try (Session session = driver.session();){
            session.run("RETURN 1");
        }
    }
}

