/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Record;
import org.neo4j.driver.Session;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.internal.security.SecurityPlanImpl;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.DriverFactoryWithClock;
import org.neo4j.driver.internal.util.FakeClock;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.Neo4jRunner;
import org.neo4j.driver.util.ParallelizableIT;

@ParallelizableIT
class ServerKilledIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();

    ServerKilledIT() {
    }

    private static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{"plaintext", Config.builder().withoutEncryption()}), Arguments.of((Object[])new Object[]{"tls encrypted", Config.builder().withEncryption().withTrustStrategy(Config.TrustStrategy.trustCustomCertificateSignedBy((File[])new File[]{neo4j.tlsCertFile()}))}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void shouldRecoverFromServerRestart(String name, Config.ConfigBuilder configBuilder) {
        try (Driver driver = GraphDatabase.driver((URI)neo4j.uri(), (AuthToken)Neo4jRunner.DEFAULT_AUTH_TOKEN, (Config)configBuilder.build());){
            ServerKilledIT.acquireAndReleaseConnections(4, driver);
            neo4j.forceRestartDb();
            int toleratedFailures = 4;
            for (int i = 0; i < 10; ++i) {
                try (Session s = driver.session();){
                    s.run("RETURN 'Hello, world!'");
                    continue;
                }
                catch (ServiceUnavailableException e) {
                    if (toleratedFailures-- != 0) continue;
                    Assertions.fail((String)("Expected (for now) at most four failures, one for each old connection, but now I've gotten five: " + e.getMessage()));
                }
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void shouldDropBrokenOldSessions(String name, Config.ConfigBuilder configBuilder) {
        int livenessCheckTimeoutMinutes = 10;
        configBuilder.withConnectionLivenessCheckTimeout((long)livenessCheckTimeoutMinutes, TimeUnit.MINUTES);
        FakeClock clock = new FakeClock();
        try (Driver driver = this.createDriver(clock, configBuilder.build());){
            ServerKilledIT.acquireAndReleaseConnections(5, driver);
            neo4j.forceRestartDb();
            clock.progress(TimeUnit.MINUTES.toMillis(livenessCheckTimeoutMinutes + 1));
            try (Session session = driver.session();){
                List records = session.run("RETURN 1").list();
                Assertions.assertEquals((int)1, (int)records.size());
                Assertions.assertEquals((int)1, (int)((Record)records.get(0)).get(0).asInt());
            }
        }
    }

    private static void acquireAndReleaseConnections(int count, Driver driver) {
        if (count > 0) {
            Session session = driver.session();
            session.run("RETURN 1");
            ServerKilledIT.acquireAndReleaseConnections(count - 1, driver);
            session.close();
        }
    }

    private Driver createDriver(Clock clock, Config config) {
        DriverFactoryWithClock factory = new DriverFactoryWithClock(clock);
        RoutingSettings routingSettings = RoutingSettings.DEFAULT;
        RetrySettings retrySettings = RetrySettings.DEFAULT;
        return factory.newInstance(neo4j.uri(), Neo4jRunner.DEFAULT_AUTH_TOKEN, routingSettings, retrySettings, config, SecurityPlanImpl.insecure());
    }
}

