/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.SessionExtension;
import org.neo4j.driver.util.TestUtil;

@ParallelizableIT
class QueryIT {
    @RegisterExtension
    static final SessionExtension session = new SessionExtension();

    QueryIT() {
    }

    @Test
    void shouldRunWithResult() {
        List result = session.run("UNWIND [1,2,3] AS k RETURN k").list();
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)((Record)result.get(0)).get("k").asLong(), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)((Record)result.get(1)).get("k").asLong(), (Matcher)CoreMatchers.equalTo((Object)2L));
        MatcherAssert.assertThat((Object)((Record)result.get(2)).get("k").asLong(), (Matcher)CoreMatchers.equalTo((Object)3L));
        long expected = 0L;
        for (Record value : result) {
            MatcherAssert.assertThat((Object)value.get("k"), (Matcher)CoreMatchers.equalTo((Object)Values.value((long)(++expected))));
        }
        MatcherAssert.assertThat((Object)expected, (Matcher)CoreMatchers.equalTo((Object)3L));
    }

    @Test
    void shouldRunWithParameters() {
        session.run("CREATE (n:FirstNode {name:$name})", Values.parameters((Object[])new Object[]{"name", "Steven"}));
    }

    @Test
    void shouldRunWithNullValuesAsParameters() {
        Value params = null;
        session.run("CREATE (n:FirstNode {name:'Steven'})", params);
    }

    @Test
    void shouldRunWithNullRecordAsParameters() {
        Record params = null;
        session.run("CREATE (n:FirstNode {name:'Steven'})", params);
    }

    @Test
    void shouldRunWithNullMapAsParameters() {
        Map<String, Object> params = null;
        session.run("CREATE (n:FirstNode {name:'Steven'})", params);
    }

    @Test
    void shouldRunWithCollectionAsParameter() {
        session.run("RETURN $param", Values.parameters((Object[])new Object[]{"param", Collections.singleton("FOO")}));
    }

    @Test
    void shouldRunWithIteratorAsParameter() {
        Iterator<String> values = Arrays.asList("FOO", "BAR", "BAZ").iterator();
        session.run("RETURN $param", Values.parameters((Object[])new Object[]{"param", values}));
    }

    @Test
    void shouldRun() {
        session.run("CREATE (n:FirstNode)");
    }

    @Test
    void shouldRunParameterizedWithResult() {
        List result = session.run("UNWIND $list AS k RETURN k", Values.parameters((Object[])new Object[]{"list", Arrays.asList(1, 2, 3)})).list();
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    void shouldRunSimpleQuery() {
        session.run("CREATE (a {name:'Adam'})");
        Result result2 = session.run("MATCH (a) RETURN a.name");
        Value name = null;
        while (result2.hasNext()) {
            name = result2.next().get("a.name");
        }
        MatcherAssert.assertThat((Object)name.asString(), (Matcher)CoreMatchers.equalTo((Object)"Adam"));
    }

    @Test
    void shouldFailForIllegalQueries() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> session.run((String)null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> session.run(""));
    }

    @Test
    void shouldBeAbleToLogSemanticWrongExceptions() {
        try {
            session.writeTransaction(tx -> tx.run("MATCH (n:Element) WHERE n.name = {param} RETURN n", Values.parameters((Object[])new Object[]{"param", "Luke"})).list());
        }
        catch (Exception ex) {
            TestUtil.assertNoCircularReferences(ex);
        }
    }
}

