/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.util.ValueFactory;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.internal.value.PathValue;
import org.neo4j.driver.internal.value.RelationshipValue;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.SessionExtension;
import org.neo4j.driver.util.TestUtil;

@ParallelizableIT
class ParametersIT {
    private static final int LONG_VALUE_SIZE = 1000000;
    @RegisterExtension
    static final SessionExtension session = new SessionExtension();

    ParametersIT() {
    }

    @Test
    void shouldBeAbleToSetAndReturnBooleanProperty() {
        Result result = session.run("CREATE (a {value:$value}) RETURN a.value", Values.parameters((Object[])new Object[]{"value", true}));
        for (Record record : result.list()) {
            Value value = record.get("a.value");
            MatcherAssert.assertThat((Object)value.hasType(session.typeSystem().BOOLEAN()), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)value.asBoolean(), (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    @Test
    void shouldBeAbleToSetAndReturnByteProperty() {
        Result result = session.run("CREATE (a {value:$value}) RETURN a.value", Values.parameters((Object[])new Object[]{"value", (byte)1}));
        for (Record record : result.list()) {
            Value value = record.get("a.value");
            MatcherAssert.assertThat((Object)value.hasType(session.typeSystem().INTEGER()), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)value.asLong(), (Matcher)CoreMatchers.equalTo((Object)1L));
        }
    }

    @Test
    void shouldBeAbleToSetAndReturnShortProperty() {
        Result result = session.run("CREATE (a {value:$value}) RETURN a.value", Values.parameters((Object[])new Object[]{"value", (short)1}));
        for (Record record : result.list()) {
            Value value = record.get("a.value");
            MatcherAssert.assertThat((Object)value.hasType(session.typeSystem().INTEGER()), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)value.asLong(), (Matcher)CoreMatchers.equalTo((Object)1L));
        }
    }

    @Test
    void shouldBeAbleToSetAndReturnIntegerProperty() {
        Result result = session.run("CREATE (a {value:$value}) RETURN a.value", Values.parameters((Object[])new Object[]{"value", 1}));
        for (Record record : result.list()) {
            Value value = record.get("a.value");
            MatcherAssert.assertThat((Object)value.hasType(session.typeSystem().INTEGER()), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)value.asLong(), (Matcher)CoreMatchers.equalTo((Object)1L));
        }
    }

    @Test
    void shouldBeAbleToSetAndReturnLongProperty() {
        Result result = session.run("CREATE (a {value:$value}) RETURN a.value", Values.parameters((Object[])new Object[]{"value", 1L}));
        for (Record record : result.list()) {
            Value value = record.get("a.value");
            MatcherAssert.assertThat((Object)value.hasType(session.typeSystem().INTEGER()), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)value.asLong(), (Matcher)CoreMatchers.equalTo((Object)1L));
        }
    }

    @Test
    void shouldBeAbleToSetAndReturnDoubleProperty() {
        Result result = session.run("CREATE (a {value:$value}) RETURN a.value", Values.parameters((Object[])new Object[]{"value", 6.28}));
        for (Record record : result.list()) {
            Value value = record.get("a.value");
            MatcherAssert.assertThat((Object)value.hasType(session.typeSystem().FLOAT()), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)value.asDouble(), (Matcher)CoreMatchers.equalTo((Object)6.28));
        }
    }

    @Test
    void shouldBeAbleToSetAndReturnBytesProperty() {
        ParametersIT.testBytesProperty(new byte[0]);
        for (int i = 0; i < 16; ++i) {
            int length = (int)Math.pow(2.0, i);
            ParametersIT.testBytesProperty(ParametersIT.randomByteArray(length));
            ParametersIT.testBytesProperty(ParametersIT.randomByteArray(length - 1));
        }
    }

    @Test
    void shouldBeAbleToSetAndReturnStringProperty() {
        ParametersIT.testStringProperty("");
        ParametersIT.testStringProperty("\u03c0\u22483.14");
        ParametersIT.testStringProperty("Mj\u00f6lnir");
        ParametersIT.testStringProperty("*** Hello World! ***");
    }

    @Test
    void shouldBeAbleToSetAndReturnBooleanArrayProperty() {
        boolean[] arrayValue = new boolean[]{true, true, true};
        Result result = session.run("CREATE (a {value:$value}) RETURN a.value", Values.parameters((Object[])new Object[]{"value", arrayValue}));
        for (Record record : result.list()) {
            Value value = record.get("a.value");
            MatcherAssert.assertThat((Object)value.hasType(session.typeSystem().LIST()), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)value.size(), (Matcher)CoreMatchers.equalTo((Object)3));
            for (Value item : value.asList(Values.ofValue())) {
                MatcherAssert.assertThat((Object)item.hasType(session.typeSystem().BOOLEAN()), (Matcher)CoreMatchers.equalTo((Object)true));
                MatcherAssert.assertThat((Object)item.asBoolean(), (Matcher)CoreMatchers.equalTo((Object)true));
            }
        }
    }

    @Test
    void shouldBeAbleToSetAndReturnIntegerArrayProperty() {
        int[] arrayValue = new int[]{42, 42, 42};
        Result result = session.run("CREATE (a {value:$value}) RETURN a.value", Values.parameters((Object[])new Object[]{"value", arrayValue}));
        for (Record record : result.list()) {
            Value value = record.get("a.value");
            MatcherAssert.assertThat((Object)value.hasType(session.typeSystem().LIST()), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)value.size(), (Matcher)CoreMatchers.equalTo((Object)3));
            for (Value item : value.asList(Values.ofValue())) {
                MatcherAssert.assertThat((Object)item.hasType(session.typeSystem().INTEGER()), (Matcher)CoreMatchers.equalTo((Object)true));
                MatcherAssert.assertThat((Object)item.asLong(), (Matcher)CoreMatchers.equalTo((Object)42L));
            }
        }
    }

    @Test
    void shouldBeAbleToSetAndReturnDoubleArrayProperty() {
        double[] arrayValue = new double[]{6.28, 6.28, 6.28};
        Result result = session.run("CREATE (a {value:$value}) RETURN a.value", Values.parameters((Object[])new Object[]{"value", arrayValue}));
        for (Record record : result.list()) {
            Value value = record.get("a.value");
            MatcherAssert.assertThat((Object)value.hasType(session.typeSystem().LIST()), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)value.size(), (Matcher)CoreMatchers.equalTo((Object)3));
            for (Value item : value.asList(Values.ofValue())) {
                MatcherAssert.assertThat((Object)item.hasType(session.typeSystem().FLOAT()), (Matcher)CoreMatchers.equalTo((Object)true));
                MatcherAssert.assertThat((Object)item.asDouble(), (Matcher)CoreMatchers.equalTo((Object)6.28));
            }
        }
    }

    @Test
    void shouldBeAbleToSetAndReturnStringArrayProperty() {
        ParametersIT.testStringArrayContaining("cat");
        ParametersIT.testStringArrayContaining("Mj\u00f6lnir");
    }

    private static void testStringArrayContaining(String str) {
        String[] arrayValue = new String[]{str, str, str};
        Result result = session.run("CREATE (a {value:$value}) RETURN a.value", Values.parameters((Object[])new Object[]{"value", arrayValue}));
        for (Record record : result.list()) {
            Value value = record.get("a.value");
            MatcherAssert.assertThat((Object)value.hasType(session.typeSystem().LIST()), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)value.size(), (Matcher)CoreMatchers.equalTo((Object)3));
            for (Value item : value.asList(Values.ofValue())) {
                MatcherAssert.assertThat((Object)item.hasType(session.typeSystem().STRING()), (Matcher)CoreMatchers.equalTo((Object)true));
                MatcherAssert.assertThat((Object)item.asString(), (Matcher)CoreMatchers.equalTo((Object)str));
            }
        }
    }

    @Test
    void shouldHandleLargeString() {
        char[] bigStr = new char[10240];
        for (int i = 0; i < bigStr.length; i += 4) {
            bigStr[i] = 97;
            bigStr[i + 1] = 98;
            bigStr[i + 2] = 99;
            bigStr[i + 3] = 100;
        }
        String bigString = new String(bigStr);
        Value val = session.run("RETURN $p AS p", Values.parameters((Object[])new Object[]{"p", bigString})).peek().get("p");
        MatcherAssert.assertThat((Object)val.asString(), (Matcher)CoreMatchers.equalTo((Object)bigString));
    }

    @Test
    void shouldBeAbleToSetAndReturnBooleanPropertyWithinMap() {
        Result result = session.run("CREATE (a {value:$value.v}) RETURN a.value", Values.parameters((Object[])new Object[]{"value", Values.parameters((Object[])new Object[]{"v", true})}));
        for (Record record : result.list()) {
            Value value = record.get("a.value");
            MatcherAssert.assertThat((Object)value.hasType(session.typeSystem().BOOLEAN()), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)value.asBoolean(), (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    @Test
    void shouldBeAbleToSetAndReturnIntegerPropertyWithinMap() {
        Result result = session.run("CREATE (a {value:$value.v}) RETURN a.value", Values.parameters((Object[])new Object[]{"value", Values.parameters((Object[])new Object[]{"v", 42})}));
        for (Record record : result.list()) {
            Value value = record.get("a.value");
            MatcherAssert.assertThat((Object)value.hasType(session.typeSystem().INTEGER()), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)value.asLong(), (Matcher)CoreMatchers.equalTo((Object)42L));
        }
    }

    @Test
    void shouldBeAbleToSetAndReturnDoublePropertyWithinMap() {
        Result result = session.run("CREATE (a {value:$value.v}) RETURN a.value", Values.parameters((Object[])new Object[]{"value", Values.parameters((Object[])new Object[]{"v", 6.28})}));
        for (Record record : result.list()) {
            Value value = record.get("a.value");
            MatcherAssert.assertThat((Object)value.hasType(session.typeSystem().FLOAT()), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)value.asDouble(), (Matcher)CoreMatchers.equalTo((Object)6.28));
        }
    }

    @Test
    void shouldBeAbleToSetAndReturnStringPropertyWithinMap() {
        Result result = session.run("CREATE (a {value:$value.v}) RETURN a.value", Values.parameters((Object[])new Object[]{"value", Values.parameters((Object[])new Object[]{"v", "Mj\u00f6lnir"})}));
        for (Record record : result.list()) {
            Value value = record.get("a.value");
            MatcherAssert.assertThat((Object)value.hasType(session.typeSystem().STRING()), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)value.asString(), (Matcher)CoreMatchers.equalTo((Object)"Mj\u00f6lnir"));
        }
    }

    @Test
    void settingInvalidParameterTypeShouldThrowHelpfulError() {
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> session.run("anything", Values.parameters((Object[])new Object[]{"k", new Object()})));
        Assertions.assertEquals((Object)"Unable to convert java.lang.Object to Neo4j Value.", (Object)e.getMessage());
    }

    @Test
    void settingInvalidParameterTypeDirectlyShouldThrowHelpfulError() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> session.run("anything", (Value)ValueFactory.emptyNodeValue()));
        Assertions.assertEquals((Object)"The parameters should be provided as Map type. Unsupported parameters type: NODE", (Object)e.getMessage());
    }

    @Test
    void shouldNotBePossibleToUseNodeAsParameterInMapValue() {
        NodeValue node = ValueFactory.emptyNodeValue();
        HashMap<String, NodeValue> params = new HashMap<String, NodeValue>();
        params.put("a", node);
        MapValue mapValue = new MapValue(params);
        ParametersIT.expectIOExceptionWithMessage((Value)mapValue, "Unknown type: NODE");
    }

    @Test
    void shouldNotBePossibleToUseRelationshipAsParameterViaMapValue() {
        RelationshipValue relationship = ValueFactory.emptyRelationshipValue();
        HashMap<String, RelationshipValue> params = new HashMap<String, RelationshipValue>();
        params.put("a", relationship);
        MapValue mapValue = new MapValue(params);
        ParametersIT.expectIOExceptionWithMessage((Value)mapValue, "Unknown type: RELATIONSHIP");
    }

    @Test
    void shouldNotBePossibleToUsePathAsParameterViaMapValue() {
        PathValue path = ValueFactory.filledPathValue();
        HashMap<String, PathValue> params = new HashMap<String, PathValue>();
        params.put("a", path);
        MapValue mapValue = new MapValue(params);
        ParametersIT.expectIOExceptionWithMessage((Value)mapValue, "Unknown type: PATH");
    }

    @Test
    void shouldSendAndReceiveLongString() {
        String string = TestUtil.randomString(1000000);
        ParametersIT.testSendAndReceiveValue(string);
    }

    @Test
    void shouldSendAndReceiveLongListOfLongs() {
        List longs = ThreadLocalRandom.current().longs(1000000L).boxed().collect(Collectors.toList());
        ParametersIT.testSendAndReceiveValue(longs);
    }

    @Test
    void shouldSendAndReceiveLongArrayOfBytes() {
        byte[] bytes = new byte[1000000];
        ThreadLocalRandom.current().nextBytes(bytes);
        ParametersIT.testSendAndReceiveValue(bytes);
    }

    @Test
    void shouldAcceptStreamsAsQueryParameters() {
        Stream<Integer> stream = Stream.of(1, 2, 3, 4, 5, 42);
        Result result = session.run("RETURN $value", Collections.singletonMap("value", stream));
        Value receivedValue = result.single().get(0);
        Assertions.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 42), (Object)receivedValue.asList(Values.ofInteger()));
    }

    private static void testBytesProperty(byte[] array) {
        Result result = session.run("CREATE (a {value:$value}) RETURN a.value", Values.parameters((Object[])new Object[]{"value", array}));
        for (Record record : result.list()) {
            Value value = record.get("a.value");
            MatcherAssert.assertThat((Object)value.hasType(session.typeSystem().BYTES()), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)value.asByteArray(), (Matcher)CoreMatchers.equalTo((Object)array));
        }
    }

    private static void testStringProperty(String string) {
        Result result = session.run("CREATE (a {value:$value}) RETURN a.value", Values.parameters((Object[])new Object[]{"value", string}));
        for (Record record : result.list()) {
            Value value = record.get("a.value");
            MatcherAssert.assertThat((Object)value.hasType(session.typeSystem().STRING()), (Matcher)CoreMatchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)value.asString(), (Matcher)CoreMatchers.equalTo((Object)string));
        }
    }

    private static byte[] randomByteArray(int length) {
        byte[] result = new byte[length];
        ThreadLocalRandom.current().nextBytes(result);
        return result;
    }

    private static void expectIOExceptionWithMessage(Value value, String message) {
        ServiceUnavailableException e = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> session.run("RETURN {a}", value).consume());
        Throwable cause = e.getCause();
        MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(IOException.class));
        MatcherAssert.assertThat((Object)cause.getMessage(), (Matcher)CoreMatchers.equalTo((Object)message));
    }

    private static void testSendAndReceiveValue(Object value) {
        Result result = session.run("RETURN $value", Collections.singletonMap("value", value));
        Object receivedValue = result.single().get(0).asObject();
        Assertions.assertArrayEquals((Object[])new Object[]{value}, (Object[])new Object[]{receivedValue});
    }
}

