/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.util.List;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.QueryRunner;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;

public interface NestedQueries {
    public static final String OUTER_QUERY = "UNWIND range(1, 10000) AS x RETURN x";
    public static final String INNER_QUERY = "UNWIND range(1, 10) AS y RETURN y";
    public static final int EXPECTED_RECORDS = 110000;

    public Session newSession(AccessMode var1);

    @Test
    default public void shouldAllowNestedQueriesInTransactionConsumedAsIterators() throws Exception {
        try (Session session = this.newSession(AccessMode.READ);
             Transaction tx = session.beginTransaction();){
            this.testNestedQueriesConsumedAsIterators((QueryRunner)tx);
            tx.commit();
        }
    }

    @Test
    default public void shouldAllowNestedQueriesInTransactionConsumedAsLists() throws Exception {
        try (Session session = this.newSession(AccessMode.READ);
             Transaction tx = session.beginTransaction();){
            this.testNestedQueriesConsumedAsLists((QueryRunner)tx);
            tx.commit();
        }
    }

    @Test
    default public void shouldAllowNestedQueriesInTransactionConsumedAsIteratorAndList() throws Exception {
        try (Session session = this.newSession(AccessMode.READ);
             Transaction tx = session.beginTransaction();){
            this.testNestedQueriesConsumedAsIteratorAndList((QueryRunner)tx);
            tx.commit();
        }
    }

    @Test
    default public void shouldAllowNestedQueriesInSessionConsumedAsIterators() throws Exception {
        try (Session session = this.newSession(AccessMode.READ);){
            this.testNestedQueriesConsumedAsIterators((QueryRunner)session);
        }
    }

    @Test
    default public void shouldAllowNestedQueriesInSessionConsumedAsLists() throws Exception {
        try (Session session = this.newSession(AccessMode.READ);){
            this.testNestedQueriesConsumedAsLists((QueryRunner)session);
        }
    }

    @Test
    default public void shouldAllowNestedQueriesInSessionConsumedAsIteratorAndList() throws Exception {
        try (Session session = this.newSession(AccessMode.READ);){
            this.testNestedQueriesConsumedAsIteratorAndList((QueryRunner)session);
        }
    }

    default public void testNestedQueriesConsumedAsIterators(QueryRunner queryRunner) throws Exception {
        int recordsSeen = 0;
        Result result1 = queryRunner.run(OUTER_QUERY);
        Thread.sleep(1000L);
        while (result1.hasNext()) {
            Record record1 = result1.next();
            Assert.assertFalse((boolean)record1.get("x").isNull());
            ++recordsSeen;
            Result result2 = queryRunner.run(INNER_QUERY);
            while (result2.hasNext()) {
                Record record2 = result2.next();
                Assert.assertFalse((boolean)record2.get("y").isNull());
                ++recordsSeen;
            }
        }
        Assert.assertEquals((long)110000L, (long)recordsSeen);
    }

    default public void testNestedQueriesConsumedAsLists(QueryRunner queryRunner) throws Exception {
        int recordsSeen = 0;
        Result result1 = queryRunner.run(OUTER_QUERY);
        Thread.sleep(1000L);
        List records1 = result1.list();
        for (Record record1 : records1) {
            Assert.assertFalse((boolean)record1.get("x").isNull());
            ++recordsSeen;
            Result result2 = queryRunner.run(INNER_QUERY);
            List records2 = result2.list();
            for (Record record2 : records2) {
                Assert.assertFalse((boolean)record2.get("y").isNull());
                ++recordsSeen;
            }
        }
        Assert.assertEquals((long)110000L, (long)recordsSeen);
    }

    default public void testNestedQueriesConsumedAsIteratorAndList(QueryRunner queryRunner) throws Exception {
        int recordsSeen = 0;
        Result result1 = queryRunner.run(OUTER_QUERY);
        Thread.sleep(1000L);
        while (result1.hasNext()) {
            Record record1 = result1.next();
            Assert.assertFalse((boolean)record1.get("x").isNull());
            ++recordsSeen;
            Result result2 = queryRunner.run(INNER_QUERY);
            List records2 = result2.list();
            for (Record record2 : records2) {
                Assert.assertFalse((boolean)record2.get("y").isNull());
                ++recordsSeen;
            }
        }
        Assert.assertEquals((long)110000L, (long)recordsSeen);
    }
}

