/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.net.URI;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;

@ParallelizableIT
class DirectDriverIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();
    private Driver driver;

    DirectDriverIT() {
    }

    @AfterEach
    void closeDriver() {
        if (this.driver != null) {
            this.driver.close();
        }
    }

    @Test
    void shouldAllowIPv6Address() {
        URI uri = URI.create("bolt://[::1]:" + neo4j.boltPort());
        BoltServerAddress address = new BoltServerAddress(uri);
        this.driver = GraphDatabase.driver((URI)uri, (AuthToken)neo4j.authToken());
        MatcherAssert.assertThat((Object)this.driver, (Matcher)Matchers.is(org.neo4j.driver.internal.util.Matchers.directDriverWithAddress(address)));
    }

    @Test
    void shouldRejectInvalidAddress() {
        URI uri = URI.create("*");
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> GraphDatabase.driver((URI)uri, (AuthToken)neo4j.authToken()));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)IsEqual.equalTo((Object)"Scheme must not be null"));
    }

    @Test
    void shouldRegisterSingleServer() {
        URI uri = neo4j.uri();
        BoltServerAddress address = new BoltServerAddress(uri);
        this.driver = GraphDatabase.driver((URI)uri, (AuthToken)neo4j.authToken());
        MatcherAssert.assertThat((Object)this.driver, (Matcher)Matchers.is(org.neo4j.driver.internal.util.Matchers.directDriverWithAddress(address)));
    }

    @Test
    void shouldConnectIPv6Uri() {
        try (Driver driver = GraphDatabase.driver((String)("bolt://[::1]:" + neo4j.boltPort()), (AuthToken)neo4j.authToken());
             Session session = driver.session();){
            Result result = session.run("RETURN 1");
            MatcherAssert.assertThat((Object)result.single().get(0).asInt(), (Matcher)CoreMatchers.equalTo((Object)1));
        }
    }
}

