/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.DefaultDomainNameResolver;
import org.neo4j.driver.internal.DomainNameResolver;
import org.neo4j.driver.internal.RevocationStrategy;
import org.neo4j.driver.internal.async.connection.BootstrapFactory;
import org.neo4j.driver.internal.async.connection.ChannelConnectorImpl;
import org.neo4j.driver.internal.async.inbound.ConnectTimeoutHandler;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.security.SecurityPlanImpl;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.FakeClock;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.TestUtil;

@ParallelizableIT
class ChannelConnectorImplIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();
    private Bootstrap bootstrap;

    ChannelConnectorImplIT() {
    }

    @BeforeEach
    void setUp() {
        this.bootstrap = BootstrapFactory.newBootstrap((int)1);
    }

    @AfterEach
    void tearDown() {
        if (this.bootstrap != null) {
            this.bootstrap.config().group().shutdownGracefully().syncUninterruptibly();
        }
    }

    @Test
    void shouldConnect() throws Exception {
        ChannelConnectorImpl connector = this.newConnector(neo4j.authToken());
        ChannelFuture channelFuture = connector.connect(neo4j.address(), this.bootstrap);
        Assertions.assertTrue((boolean)channelFuture.await(10L, TimeUnit.SECONDS));
        Channel channel = channelFuture.channel();
        Assertions.assertNull((Object)channelFuture.get());
        Assertions.assertTrue((boolean)channel.isActive());
    }

    @Test
    void shouldSetupHandlers() throws Exception {
        ChannelConnectorImpl connector = this.newConnector(neo4j.authToken(), ChannelConnectorImplIT.trustAllCertificates(), 10000);
        ChannelFuture channelFuture = connector.connect(neo4j.address(), this.bootstrap);
        Assertions.assertTrue((boolean)channelFuture.await(10L, TimeUnit.SECONDS));
        Channel channel = channelFuture.channel();
        ChannelPipeline pipeline = channel.pipeline();
        Assertions.assertTrue((boolean)channel.isActive());
        Assertions.assertNotNull((Object)pipeline.get(SslHandler.class));
        Assertions.assertNull((Object)pipeline.get(ConnectTimeoutHandler.class));
    }

    @Test
    void shouldFailToConnectToWrongAddress() throws Exception {
        ChannelConnectorImpl connector = this.newConnector(neo4j.authToken());
        ChannelFuture channelFuture = connector.connect(new BoltServerAddress("wrong-localhost"), this.bootstrap);
        Assertions.assertTrue((boolean)channelFuture.await(10L, TimeUnit.SECONDS));
        Channel channel = channelFuture.channel();
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> channelFuture.get());
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(ServiceUnavailableException.class));
        MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.startsWith((String)"Unable to connect"));
        Assertions.assertFalse((boolean)channel.isActive());
    }

    @Test
    void shouldFailToConnectWithWrongCredentials() throws Exception {
        AuthToken authToken = AuthTokens.basic((String)"neo4j", (String)"wrong-password");
        ChannelConnectorImpl connector = this.newConnector(authToken);
        ChannelFuture channelFuture = connector.connect(neo4j.address(), this.bootstrap);
        Assertions.assertTrue((boolean)channelFuture.await(10L, TimeUnit.SECONDS));
        Channel channel = channelFuture.channel();
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> channelFuture.get());
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(AuthenticationException.class));
        Assertions.assertFalse((boolean)channel.isActive());
    }

    @Test
    void shouldEnforceConnectTimeout() throws Exception {
        ChannelConnectorImpl connector = this.newConnector(neo4j.authToken(), 1000);
        ChannelFuture channelFuture = connector.connect(new BoltServerAddress("10.0.0.0"), this.bootstrap);
        Assertions.assertThrows(ServiceUnavailableException.class, () -> TestUtil.await(channelFuture));
    }

    @Test
    void shouldFailWhenProtocolNegotiationTakesTooLong() throws Exception {
        this.testReadTimeoutOnConnect(SecurityPlanImpl.insecure());
    }

    @Test
    void shouldFailWhenTLSHandshakeTakesTooLong() throws Exception {
        this.testReadTimeoutOnConnect(ChannelConnectorImplIT.trustAllCertificates());
    }

    @Test
    void shouldThrowServiceUnavailableExceptionOnFailureDuringConnect() throws Exception {
        ServerSocket server = new ServerSocket(0);
        BoltServerAddress address = new BoltServerAddress("localhost", server.getLocalPort());
        CompletableFuture.runAsync(() -> {
            try {
                Socket socket = server.accept();
                socket.close();
                server.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        ChannelConnectorImpl connector = this.newConnector(neo4j.authToken());
        ChannelFuture channelFuture = connector.connect(address, this.bootstrap);
        Assertions.assertThrows(ServiceUnavailableException.class, () -> TestUtil.await(channelFuture));
    }

    private void testReadTimeoutOnConnect(SecurityPlan securityPlan) throws IOException {
        try (ServerSocket server = new ServerSocket(0);){
            int timeoutMillis = 1000;
            BoltServerAddress address = new BoltServerAddress("localhost", server.getLocalPort());
            ChannelConnectorImpl connector = this.newConnector(neo4j.authToken(), securityPlan, timeoutMillis);
            ChannelFuture channelFuture = connector.connect(address, this.bootstrap);
            ServiceUnavailableException e = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> TestUtil.await(channelFuture));
            Assertions.assertEquals((Object)e.getMessage(), (Object)("Unable to establish connection in " + timeoutMillis + "ms"));
        }
    }

    private ChannelConnectorImpl newConnector(AuthToken authToken) throws Exception {
        return this.newConnector(authToken, Integer.MAX_VALUE);
    }

    private ChannelConnectorImpl newConnector(AuthToken authToken, int connectTimeoutMillis) throws Exception {
        return this.newConnector(authToken, ChannelConnectorImplIT.trustAllCertificates(), connectTimeoutMillis);
    }

    private ChannelConnectorImpl newConnector(AuthToken authToken, SecurityPlan securityPlan, int connectTimeoutMillis) {
        ConnectionSettings settings = new ConnectionSettings(authToken, "test", connectTimeoutMillis);
        return new ChannelConnectorImpl(settings, securityPlan, DevNullLogging.DEV_NULL_LOGGING, (Clock)new FakeClock(), RoutingContext.EMPTY, (DomainNameResolver)DefaultDomainNameResolver.getInstance());
    }

    private static SecurityPlan trustAllCertificates() throws GeneralSecurityException {
        return SecurityPlanImpl.forAllCertificates((boolean)false, (RevocationStrategy)RevocationStrategy.NO_CHECKS);
    }
}

