/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.InternalNode;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.internal.InternalRelationship;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.util.TestUtil;

class TransactionConfigTest {
    TransactionConfigTest() {
    }

    @Test
    void emptyConfigShouldHaveNoTimeout() {
        Assertions.assertNull((Object)TransactionConfig.empty().timeout());
    }

    @Test
    void emptyConfigShouldHaveNoMetadata() {
        Assertions.assertEquals(Collections.emptyMap(), (Object)TransactionConfig.empty().metadata());
    }

    @Test
    void shouldDisallowNullTimeout() {
        Assertions.assertThrows(NullPointerException.class, () -> TransactionConfig.builder().withTimeout(null));
    }

    @Test
    void shouldDisallowZeroTimeout() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> TransactionConfig.builder().withTimeout(Duration.ZERO));
    }

    @Test
    void shouldDisallowNegativeTimeout() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> TransactionConfig.builder().withTimeout(Duration.ofSeconds(-1L)));
    }

    @Test
    void shouldDisallowNullMetadata() {
        Assertions.assertThrows(NullPointerException.class, () -> TransactionConfig.builder().withMetadata(null));
    }

    @Test
    void shouldDisallowMetadataWithIllegalValues() {
        Assertions.assertThrows(ClientException.class, () -> TransactionConfig.builder().withMetadata(Collections.singletonMap("key", new InternalNode(1L))));
        Assertions.assertThrows(ClientException.class, () -> TransactionConfig.builder().withMetadata(Collections.singletonMap("key", new InternalRelationship(1L, 1L, 1L, ""))));
        Assertions.assertThrows(ClientException.class, () -> TransactionConfig.builder().withMetadata(Collections.singletonMap("key", new InternalPath(new Entity[]{new InternalNode(1L)}))));
    }

    @Test
    void shouldHaveTimeout() {
        TransactionConfig config = TransactionConfig.builder().withTimeout(Duration.ofSeconds(3L)).build();
        Assertions.assertEquals((Object)Duration.ofSeconds(3L), (Object)config.timeout());
    }

    @Test
    void shouldHaveMetadata() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key1", "value1");
        map.put("key2", true);
        map.put("key3", 42);
        TransactionConfig config = TransactionConfig.builder().withMetadata(map).build();
        Map metadata = config.metadata();
        Assertions.assertEquals((int)3, (int)metadata.size());
        Assertions.assertEquals((Object)Values.value((String)"value1"), metadata.get("key1"));
        Assertions.assertEquals((Object)Values.value((boolean)true), metadata.get("key2"));
        Assertions.assertEquals((Object)Values.value((int)42), metadata.get("key3"));
    }

    @Test
    void shouldNotModifyMetadataAfterItIsSuppliedToBuilder() {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("key1", "value1");
        metadata.put("key2", true);
        metadata.put("key3", 42);
        TransactionConfig.Builder builder = TransactionConfig.builder().withMetadata(metadata);
        metadata.put("key4", "what?");
        TransactionConfig config = builder.build();
        Assertions.assertEquals((int)3, (int)config.metadata().size());
    }

    @Test
    void shouldSerialize() throws Exception {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("key1", "value1");
        metadata.put("key2", true);
        metadata.put("key3", 42);
        TransactionConfig config = TransactionConfig.builder().withTimeout(Duration.ofMillis(12345L)).withMetadata(metadata).build();
        TransactionConfig verify = TestUtil.serializeAndReadBack(config, TransactionConfig.class);
        Assertions.assertEquals((Object)config.timeout(), (Object)verify.timeout());
        Assertions.assertEquals((Object)config.metadata(), (Object)verify.metadata());
    }
}

