/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.tools;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import mds.Mds;
import mds.MdsException;
import mds.data.TREE;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor_r.Conglom;
import mds.data.descriptor_s.NODE;
import mds.data.descriptor_s.Nid;
import mds.mdsip.MdsIp;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class DecompileTree {
    private TREE tree = null;
    private Document document = null;
    public String error = null;

    public static final void main(String[] args) {
        String filename;
        if (args.length < 1) {
            System.out.println("Usage: java DecompileTree <provider> <treeName> [<shot>]");
            System.exit(0);
        }
        String provider = args[0];
        String expt = args[1];
        int shot = -1;
        if (args.length > 1) {
            try {
                shot = Integer.parseInt(args[2]);
            }
            catch (Exception exc) {
                System.err.println("Invalid shot number");
                System.exit(-1);
            }
        }
        Properties properties = System.getProperties();
        String full = properties.getProperty("full");
        boolean isFull = true;
        if (full != null && full.equals("no")) {
            isFull = false;
        }
        if ((filename = properties.getProperty("out")) == null) {
            filename = args[1] + "@" + args[0];
        }
        try {
            System.exit(new DecompileTree().decompile(provider, expt, shot, filename, isFull));
        }
        catch (MdsException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public final int decompile(String provider, String expt, int shot, String filename, boolean isFull) throws MdsException {
        int result;
        try (TREE subtree = new TREE((Mds)new MdsIp(provider), expt, shot, TREE.READONLY);){
            result = this.decompile(subtree, filename, isFull);
        }
        return result;
    }

    public int decompile(TREE tree_in, Component parent, boolean isFull) {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new FileNameExtensionFilter("XML file", "xml"));
        fc.setFileFilter(new FileNameExtensionFilter("XML document", "xml"));
        int returnVal = fc.showSaveDialog(parent);
        if (returnVal != 0) {
            return 0;
        }
        return this.decompile(tree_in, fc.getSelectedFile().getAbsolutePath(), isFull);
    }

    public final int decompile(TREE dtree, String filename, boolean isFull) {
        this.tree = dtree;
        if (!filename.contains(".")) {
            filename = filename + ".xml";
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
        }
        catch (Exception e) {
            this.error = "Cannot instantiate a new Document: " + e;
            System.err.println(this.error);
            this.document = null;
            return -1;
        }
        Element etree = this.document.createElement("tree");
        Nid topNid = this.tree.getTop();
        try {
            Nid[] sons;
            for (Nid son : sons = topNid.getNciChildrenNids().toArray()) {
                Element docSon = this.document.createElement("node");
                etree.appendChild(docSon);
                this.recDecompile(son, docSon, false, isFull);
            }
        }
        catch (MdsException e) {
            this.error = "Error setting sons: " + (Object)((Object)e);
            System.err.println(this.error);
        }
        try {
            Nid[] members;
            for (Nid member : members = topNid.getNciMemberNids().toArray()) {
                Element docMember = null;
                try {
                    byte usage = member.getNciUsage();
                    docMember = usage == 3 ? this.document.createElement("device") : (usage == 12 ? this.document.createElement("compound_data") : this.document.createElement("member"));
                }
                catch (Exception e) {
                    this.error = e.toString();
                    System.err.println(this.error);
                }
                etree.appendChild(docMember);
                this.recDecompile(member, docMember, false, isFull);
            }
        }
        catch (Exception e) {
            this.error = "Error setting members: " + e;
            System.err.println(this.error);
        }
        TransformerFactory transFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transFactory.newTransformer();
            DOMSource source = new DOMSource(etree);
            File newXML = new File(filename);
            try (FileOutputStream os = new FileOutputStream(newXML);){
                StreamResult result = new StreamResult(os);
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(source, result);
            }
        }
        catch (Exception e) {
            this.error = e.toString();
            System.err.println(this.error);
        }
        return 0;
    }

    private void recDecompile(Nid nid, Element node, boolean isDeviceField, boolean isFull) {
        try {
            String[] tags;
            NODE.Flags flags;
            Nid prevNid = this.tree.getDefaultNid();
            nid.setDefault();
            try {
                flags = new NODE.Flags(nid.getNciFlags());
            }
            catch (MdsException exc) {
                this.error = "Error getting info for " + nid.getNciFullPath() + ": " + (Object)((Object)exc);
                System.err.println(this.error);
                return;
            }
            try {
                tags = nid.getTags();
            }
            catch (Exception exc) {
                tags = new String[]{};
            }
            if (isDeviceField) {
                int i;
                Descriptor data = null;
                String name = nid.getNciNodeName();
                if (name.endsWith("_GAIN")) {
                    System.out.println("TACON: " + name);
                }
                if (flags.isSetup() || isFull || name.endsWith("_GAIN")) {
                    try {
                        data = nid.getRecord();
                    }
                    catch (MdsException mdsException) {
                        // empty catch block
                    }
                }
                Vector<Nid> subtreeNodes = new Vector<Nid>();
                try {
                    Nid[] sons;
                    for (Nid son : sons = nid.getNciChildrenNids().toArray()) {
                        try {
                            if (son.getNciConglomerateElt() != 1) continue;
                            subtreeNodes.addElement(son);
                        }
                        catch (MdsException mdsException) {
                            // empty catch block
                        }
                    }
                }
                catch (MdsException sons) {
                    // empty catch block
                }
                Vector<Nid> subtreeMembers = new Vector<Nid>();
                try {
                    Nid[] members;
                    for (Nid member : members = nid.getNciMemberNids().toArray()) {
                        try {
                            if (member.getNciConglomerateElt() != 1) continue;
                            subtreeMembers.addElement(member);
                        }
                        catch (MdsException mdsException) {
                            // empty catch block
                        }
                    }
                }
                catch (MdsException members) {
                    // empty catch block
                }
                if (!flags.isOn() && flags.isParentOn() || flags.isOn() && !flags.isParentOn() || flags.isSetup() && data != null || tags.length > 0 || subtreeNodes.size() > 0 || subtreeMembers.size() > 0 || isFull || name.endsWith("_GAIN")) {
                    Element fieldNode = this.document.createElement("field");
                    node.appendChild(fieldNode);
                    short conglomerateElt = nid.getNciConglomerateElt();
                    Nid deviceNid = new Nid(nid, -conglomerateElt + 1);
                    String devicePath = deviceNid.getNciFullPath();
                    String fieldPath = nid.getNciFullPath();
                    if (fieldPath.startsWith(devicePath)) {
                        fieldNode.setAttribute("NAME", fieldPath.substring(devicePath.length(), fieldPath.length()));
                        if (!flags.isOn() && flags.isParentOn()) {
                            fieldNode.setAttribute("STATE", "OFF");
                        }
                        if (flags.isOn() && !flags.isParentOn()) {
                            fieldNode.setAttribute("STATE", "ON");
                        }
                        if (tags.length > 0) {
                            String tagList = "";
                            for (int i2 = 0; i2 < tags.length; ++i2) {
                                tagList = tagList + (i2 == tags.length - 1 ? tags[i2] : tags[i2] + ",");
                            }
                            fieldNode.setAttribute("TAGS", tagList);
                        }
                        if (data != null) {
                            Element dataNode = this.document.createElement("data");
                            Text dataText = this.document.createTextNode(data.toString());
                            dataNode.appendChild(dataText);
                            fieldNode.appendChild(dataNode);
                        }
                    }
                }
                for (i = 0; i < subtreeNodes.size(); ++i) {
                    Element currNode = this.document.createElement("node");
                    this.recDecompile((Nid)subtreeNodes.elementAt(i), currNode, false, isFull);
                }
                for (i = 0; i < subtreeMembers.size(); ++i) {
                    Element currNode = this.document.createElement("member");
                    this.recDecompile((Nid)subtreeMembers.elementAt(i), currNode, false, isFull);
                }
            } else {
                short conglomerateElt;
                node.setAttribute("NAME", nid.getNciNodeName());
                byte usage = nid.getNciUsage();
                if (usage == 3 || usage == 12) {
                    Conglom deviceData = null;
                    try {
                        deviceData = (Conglom)nid.getRecord();
                        String model = deviceData.getModel().toString();
                        node.setAttribute("MODEL", model.substring(1, model.length() - 1));
                    }
                    catch (Exception exc) {
                        System.err.println("Error reading device data: " + exc);
                    }
                }
                if ((conglomerateElt = nid.getNciConglomerateElt()) > 1) {
                    Nid deviceNid = new Nid(nid, -conglomerateElt + 1);
                    try {
                        node.setAttribute("DEVICE", deviceNid.getNciFullPath());
                        node.setAttribute("OFFSET_NID", "" + conglomerateElt);
                    }
                    catch (Exception exc) {
                        System.err.println("Error getting device info: " + exc);
                    }
                }
                try {
                    tags = nid.getTags();
                }
                catch (Exception exc) {
                    System.err.println("Error getting tags: " + exc);
                    tags = new String[]{};
                }
                if (tags.length > 0) {
                    String tagList = "";
                    for (int i = 0; i < tags.length; ++i) {
                        tagList = tagList + (i == tags.length - 1 ? tags[i] : tags[i] + ",");
                    }
                    node.setAttribute("TAGS", tagList);
                }
                if (!flags.isOn() && flags.isParentOn()) {
                    node.setAttribute("STATE", "OFF");
                }
                if (flags.isOn() && !flags.isParentOn()) {
                    node.setAttribute("STATE", "ON");
                }
                String flagsStr = "";
                if (flags.isWriteOnce()) {
                    flagsStr = flagsStr + (flagsStr.length() > 0 ? ",WRITE_ONCE" : "WRITE_ONCE");
                }
                if (flags.isCompressible()) {
                    flagsStr = flagsStr + (flagsStr.length() > 0 ? ",COMPRESSIBLE" : "COMPRESSIBLE");
                }
                if (flags.isCompressOnPut()) {
                    flagsStr = flagsStr + (flagsStr.length() > 0 ? ",COMPRESS_ON_PUT" : "COMPRESS_ON_PUT");
                }
                if (flags.isNoWriteModel()) {
                    flagsStr = flagsStr + (flagsStr.length() > 0 ? ",NO_WRITE_MODEL" : "NO_WRITE_MODEL");
                }
                if (flags.isNoWriteShot()) {
                    flagsStr = flagsStr + (flagsStr.length() > 0 ? ",NO_WRITE_SHOT" : "NO_WRITE_SHOT");
                }
                if (flagsStr.length() > 0) {
                    node.setAttribute("FLAGS", flagsStr);
                }
                if (usage != 1 && usage != 3 && usage != 12) {
                    Descriptor data;
                    String usageStr;
                    switch (usage) {
                        default: {
                            usageStr = "ANY";
                            break;
                        }
                        case 2: {
                            usageStr = "ACTION";
                            break;
                        }
                        case 4: {
                            usageStr = "DISPATCH";
                            break;
                        }
                        case 5: {
                            usageStr = "NUMERIC";
                            break;
                        }
                        case 6: {
                            usageStr = "SIGNAL";
                            break;
                        }
                        case 7: {
                            usageStr = "TASK";
                            break;
                        }
                        case 8: {
                            usageStr = "TEXT";
                            break;
                        }
                        case 9: {
                            usageStr = "WINDOW";
                            break;
                        }
                        case 10: {
                            usageStr = "AXIS";
                            break;
                        }
                        case 11: {
                            usageStr = "SUBTREE";
                        }
                    }
                    node.setAttribute("USAGE", usageStr);
                    try {
                        data = nid.getRecord();
                    }
                    catch (Exception exc) {
                        data = null;
                    }
                    if (data != null) {
                        Element dataNode = this.document.createElement("data");
                        Text dataText = this.document.createTextNode(data.decompile());
                        dataNode.appendChild(dataText);
                        node.appendChild(dataNode);
                    }
                }
                if (usage != 11) {
                    if (usage == 3 || usage == 12) {
                        Nid[] nids;
                        for (Nid n : nids = nid.getNciConglomerateNids().toArray()) {
                            this.recDecompile(n, node, true, isFull);
                        }
                    } else {
                        try {
                            Nid[] sons;
                            for (Nid son : sons = nid.getNciChildrenNids().toArray()) {
                                Element docSon = this.document.createElement("node");
                                node.appendChild(docSon);
                                this.recDecompile(son, docSon, false, isFull);
                            }
                        }
                        catch (MdsException sons) {
                            // empty catch block
                        }
                        try {
                            Nid[] members;
                            for (Nid member : members = nid.getNciMemberNids().toArray()) {
                                byte cusage = member.getNciUsage();
                                Element docMember = cusage == 3 ? this.document.createElement(cusage == 3 ? "device" : "compound_data") : (cusage == 12 ? this.document.createElement("compound_data") : this.document.createElement("member"));
                                node.appendChild(docMember);
                                this.recDecompile(member, docMember, false, isFull);
                            }
                        }
                        catch (MdsException mdsException) {
                            // empty catch block
                        }
                    }
                }
            }
            prevNid.setDefault();
        }
        catch (Exception exc) {
            System.err.println(exc);
        }
    }
}

