/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.tools;

import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mds.Mds;
import mds.MdsException;
import mds.data.TREE;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor_s.Nid;
import mds.data.descriptor_s.Path;
import mds.mdsip.MdsIp;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CompileTree
extends Thread {
    String filepath;
    String provider;
    String experiment;
    Vector<String> newNames = new Vector();
    Vector<String> renamedDevices = new Vector();
    Vector<String> renamedFieldNids = new Vector();
    int shot;
    Vector<Nid> subtreeNids = new Vector();
    TREE tree;
    Vector<String> unresolvedExprV = new Vector();
    Vector<Nid> unresolvedNidV = new Vector();

    public static void main(String[] args) {
        int shot = -1;
        if (args.length < 1) {
            System.err.println("Usage: java CompileTree <file> <provider> <experiment> [<shot>]");
            System.exit(0);
        }
        String filepath = args[0];
        String provider = args[1];
        String experiment = args[2];
        if (args.length > 3) {
            try {
                shot = Integer.parseInt(args[3]);
            }
            catch (Exception exc) {
                System.err.println("Error Parsing shot number");
                System.exit(0);
            }
        }
        new CompileTree(filepath, provider, experiment, shot).start();
    }

    CompileTree(String filepath, String provider, String experiment, int shot) {
        this.filepath = filepath;
        this.provider = provider;
        this.experiment = experiment;
        this.shot = shot;
    }

    void recCompile(Element node) {
        String type = node.getNodeName();
        String name = node.getAttribute("NAME");
        String usageStr = node.getAttribute("USAGE");
        Nid nid = null;
        try {
            Nid parentNid = this.tree.getDefaultNid();
            if (type.equals("data")) {
                block50: {
                    boolean isDeviceField = node.getNodeName().equals("field");
                    Text dataNode = (Text)node.getFirstChild();
                    if (dataNode != null) {
                        String dataStr = dataNode.getData();
                        Descriptor data = null;
                        this.unresolvedExprV.addElement(dataStr);
                        this.unresolvedNidV.addElement(this.tree.getDefaultNid());
                        try {
                            nid = this.tree.getDefaultNid();
                            if (isDeviceField) {
                                Descriptor oldData;
                                try {
                                    oldData = nid.getRecord();
                                }
                                catch (Exception exc) {
                                    oldData = null;
                                }
                                if (oldData == null || !dataStr.equals(oldData.toString())) {
                                    nid.putRecord(data);
                                }
                                break block50;
                            }
                            nid.putRecord(data);
                        }
                        catch (Exception exc) {
                            System.err.println("Error writing data to nid " + nid + ": " + exc);
                        }
                    }
                }
                return;
            }
            String originalDevice = node.getAttribute("DEVICE");
            String deviceOffsetStr = node.getAttribute("OFFSET_NID");
            if (originalDevice != null && deviceOffsetStr != null && !originalDevice.equals("") && !deviceOffsetStr.equals("")) {
                String newName;
                try {
                    newName = parentNid.getNciFullPath();
                }
                catch (Exception exc) {
                    System.err.println("Error getting renamed path: " + exc);
                    return;
                }
                newName = type.equals("node") ? newName + "." + name : newName + ":" + name;
                this.newNames.addElement(newName);
                this.renamedDevices.addElement(originalDevice);
                this.renamedFieldNids.addElement(deviceOffsetStr);
                return;
            }
            if (type.equals("node")) {
                try {
                    if (name.length() > 12) {
                        name = name.substring(0, 12);
                    }
                    nid = this.tree.addNode(name, (byte)1);
                    if (usageStr != null && usageStr.equals("SUBTREE")) {
                        this.subtreeNids.addElement(nid);
                    }
                }
                catch (Exception e) {
                    System.err.println("Error adding member " + name + " : " + e);
                    nid = null;
                }
            } else if (type.equals("member")) {
                int usage = usageStr.equals("ACTION") ? 2 : (usageStr.equals("NUMERIC") ? 5 : (usageStr.equals("SIGNAL") ? 6 : (usageStr.equals("TASK") ? 7 : (usageStr.equals("TEXT") ? 8 : (usageStr.equals("WINDOW") ? 9 : (usageStr.equals("AXIS") ? 10 : (usageStr.equals("DISPATCH") ? 4 : 0)))))));
                try {
                    if (name.length() > 12) {
                        name = name.substring(0, 12);
                    }
                    nid = this.tree.addNode(":" + name, (byte)usage);
                }
                catch (Exception e) {
                    System.err.println("Error adding member " + name + " : " + e);
                    nid = null;
                }
            } else if (type.equals("device")) {
                String model = node.getAttribute("MODEL");
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                    nid = this.tree.addConglom(name.trim(), model);
                }
                catch (MdsException e) {}
            } else if (type.equals("field")) {
                try {
                    nid = new Path(name).toNid();
                }
                catch (Exception e) {
                    System.err.println("WARNING: device field  " + name + " not found in model : " + e);
                    nid = null;
                }
            }
            if (nid != null) {
                String stateStr;
                String flagsStr;
                nid.setDefault();
                String tagsStr = node.getAttribute("TAGS");
                if (tagsStr != null && tagsStr.length() > 0) {
                    int i = 0;
                    StringTokenizer st = new StringTokenizer(tagsStr, ", ");
                    String[] tags = new String[st.countTokens()];
                    while (st.hasMoreTokens()) {
                        tags[i++] = st.nextToken();
                    }
                    try {
                        nid.setTags(tags);
                    }
                    catch (Exception exc) {
                        System.err.println("Error adding tags " + tagsStr + " : " + exc);
                    }
                }
                if ((flagsStr = node.getAttribute("FLAGS")) != null && flagsStr.length() > 0) {
                    int flags = 0;
                    StringTokenizer st = new StringTokenizer(flagsStr, ", ");
                    while (st.hasMoreTokens()) {
                        String flag = st.nextToken();
                        if (flag.equals("WRITE_ONCE")) {
                            flags |= 0x80;
                        }
                        if (flag.equals("COMPRESSIBLE")) {
                            flags |= 0x100;
                        }
                        if (flag.equals("COMPRESS_ON_PUT")) {
                            flags |= 0x400;
                        }
                        if (flag.equals("NO_WRITE_MODEL")) {
                            flags |= 0x800;
                        }
                        if (!flag.equals("NO_WRITE_SHOT")) continue;
                        flags |= 0x1000;
                    }
                    try {
                        nid.setFlags(flags);
                    }
                    catch (Exception e) {
                        System.err.println("Error setting flags to node " + name + " : " + e);
                    }
                }
                if ((stateStr = node.getAttribute("STATE")) != null && stateStr.length() > 0) {
                    try {
                        if (stateStr.equals("ON")) {
                            nid.setOn(true);
                        }
                        if (stateStr.equals("OFF")) {
                            nid.setOn(false);
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Error setting state of node " + name + " : " + e);
                    }
                }
                NodeList nodes = node.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node currNode = nodes.item(i);
                    if (currNode.getNodeType() != 1) continue;
                    this.recCompile((Element)currNode);
                }
            }
            parentNid.setDefault();
        }
        catch (Exception e) {
            System.err.println("Internal error in recCompile: " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        int i;
        try {
            this.tree = new TREE((Mds)new MdsIp(this.provider), this.experiment, this.shot, TREE.NEW);
        }
        catch (Exception e) {
            System.err.println("Error opening tree " + this.experiment + " : " + e);
            System.exit(0);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(this.filepath);
            Element rootNode = document.getDocumentElement();
            NodeList nodes = rootNode.getChildNodes();
            for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
                Node currNode = nodes.item(i2);
                if (currNode.getNodeType() != 1) continue;
                this.recCompile((Element)currNode);
            }
        }
        catch (SAXParseException e) {
            System.err.println("\n** Parsing error, line " + e.getLineNumber() + ", uri " + e.getSystemId());
            System.err.println("   " + e.getMessage());
            Exception x = e.getException();
            if (x != null) {
                x.printStackTrace();
            } else {
                e.printStackTrace();
            }
        }
        catch (SAXException se) {
            Exception e = se.getException();
            if (e != null) {
                e.printStackTrace();
            } else {
                se.printStackTrace();
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (i = 0; i < this.newNames.size(); ++i) {
            String newName = this.newNames.elementAt(i);
            String deviceName = this.renamedDevices.elementAt(i);
            String offsetStr = this.renamedFieldNids.elementAt(i);
            try {
                int deviceOffset = Integer.parseInt(offsetStr);
                Nid deviceNid = new Path(deviceName).toNid();
                Nid renamedNid = new Nid(deviceNid, deviceOffset);
                renamedNid.setPath(newName);
                continue;
            }
            catch (Exception e) {
                System.err.println("Error renaming node of " + deviceName + " to " + newName + " : " + e);
            }
        }
        for (i = 0; i < this.unresolvedNidV.size(); ++i) {
            Descriptor data = null;
            try {
                this.unresolvedNidV.elementAt(i).setDefault();
                data = this.tree.getMds().getDescriptor(this.unresolvedExprV.elementAt(i), new Descriptor[0]);
            }
            catch (Exception e) {
                System.err.println("Error parsing expression " + this.unresolvedExprV.elementAt(i) + " : " + e);
            }
            try {
                this.unresolvedNidV.elementAt(i).putRecord(data);
                continue;
            }
            catch (Exception e) {
                System.err.println("Error writing data to nid " + this.unresolvedNidV.elementAt(i) + ": " + e);
            }
        }
        for (i = 0; i < this.subtreeNids.size(); ++i) {
            try {
                this.subtreeNids.elementAt(i).setSubtree();
                continue;
            }
            catch (Exception e) {
                System.err.println("Error setting subtree: " + e);
            }
        }
        try {
            this.tree.writeTree();
            this.tree.close();
        }
        catch (Exception e) {
            System.err.println("Error closeing tree: " + e);
        }
    }
}

