/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import mds.data.TREE;
import mds.jtraverser.MdsView;
import mds.jtraverser.TreeManager;
import mds.jtraverser.TreeView;
import mds.mdsip.MdsIp;

public final class jTraverserFacade
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String TitleNoTree = "jTraverser - no tree open";
    private final List<JMenuItem> jmenus = new ArrayList<JMenuItem>(5);
    private final TreeManager treeman;
    private TreeManager.ExtrasMenu extras;

    public jTraverserFacade(String server, String exp_name, String shot_name, String access, String path) {
        JOptionPane.setRootFrame(this);
        this.setTitle(TitleNoTree);
        TREE.MODE mode = TREE.READONLY;
        if (access != null && !access.isEmpty()) {
            if ("-normal".startsWith(access = access.toLowerCase())) {
                mode = TREE.NORMAL;
            } else if ("-edit".startsWith(access)) {
                mode = TREE.EDITABLE;
            }
        }
        this.treeman = new TreeManager(this);
        this.getContentPane().add(this.treeman);
        JMenuBar menu_bar = new JMenuBar();
        this.setJMenuBar(menu_bar);
        JMenu jmenu = new JMenu("File");
        menu_bar.add(jmenu);
        jmenu.addMenuListener(new MenuChecker(jmenu, new TreeManager.FileMenu(this.treeman, jmenu, -1)));
        this.jmenus.add(jmenu);
        jmenu = new JMenu("Display");
        menu_bar.add(jmenu);
        jmenu.addMenuListener(new MenuChecker(jmenu, new TreeManager.DisplayMenu(this.treeman, jmenu, -1)));
        this.jmenus.add(jmenu);
        jmenu.setEnabled(false);
        jmenu = new JMenu("Modify");
        menu_bar.add(jmenu);
        jmenu.addMenuListener(new MenuChecker(jmenu, new TreeManager.ModifyMenu(this.treeman, jmenu, -1)));
        this.jmenus.add(jmenu);
        jmenu.setEnabled(false);
        jmenu = new JMenu("Edit");
        menu_bar.add(jmenu);
        jmenu.addMenuListener(new MenuChecker(jmenu, new TreeManager.EditMenu(this.treeman, jmenu, -1)));
        this.jmenus.add(jmenu);
        jmenu.setEnabled(false);
        jmenu = new JMenu("Extras");
        menu_bar.add(jmenu);
        this.extras = new TreeManager.ExtrasMenu(this.treeman, jmenu);
        jmenu.addMenuListener(new MenuChecker(jmenu, this.extras));
        this.jmenus.add(jmenu);
        jmenu.setEnabled(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                try {
                    jTraverserFacade.this.treeman.quit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        });
        this.pack();
        this.setVisible(true);
        try {
            MdsView mdsview = server == null || server.isEmpty() && this.treeman.getCurrentMdsView() != null ? this.treeman.getCurrentMdsView() : this.treeman.openMds(new MdsIp.Provider(server));
            if (exp_name != null && mdsview != null) {
                if (path != null) {
                    this.treeman.setTreePathEnv(exp_name, path);
                }
                mdsview.openTree(exp_name.toUpperCase(), shot_name == null || shot_name.equalsIgnoreCase("model") ? -1 : Integer.parseInt(shot_name), mode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Component add(Component component) {
        return this.getContentPane().add(component);
    }

    void reportChange(MdsView mdsview) {
        TreeView treeview;
        if (mdsview != null && (treeview = mdsview.getCurrentTreeView()) != null) {
            this.setTitle(new StringBuilder(256).append("jTraverser - ").append(treeview).append(" on ").append(mdsview).toString());
            this.jmenus.get(1).setEnabled(true);
            this.jmenus.get(2).setEnabled(!treeview.isReadOnly());
            this.jmenus.get(3).setEnabled(treeview.isEditable());
            this.jmenus.get(4).setEnabled(true);
            return;
        }
        this.setTitle(TitleNoTree);
        for (JMenuItem jm : this.jmenus.subList(1, 4)) {
            jm.setEnabled(false);
        }
        this.extras.checkSupport();
    }

    private class MenuChecker
    implements MenuListener {
        private final JMenu jmenu;
        private final TreeManager.Menu menu;

        public MenuChecker(JMenu jmenu, TreeManager.Menu menu) {
            this.jmenu = jmenu;
            this.menu = menu;
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            if (this.jmenu.isEnabled()) {
                this.menu.checkSupport();
            }
        }
    }
}

