/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.editor.usage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mds.MdsException;
import mds.data.CTX;
import mds.data.descriptor.Descriptor;
import mds.jtraverser.editor.Editor;
import mds.jtraverser.editor.ExprEditor;
import mds.jtraverser.editor.ParameterEditor;

public class TextEditor
extends Editor
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected final int mode_idx_usr;
    protected final Window window;
    protected final JComboBox<String> combo;
    protected final JPanel editor;
    protected final String name;
    private final boolean allowparams;
    protected int mode_idx = 0;
    protected int curr_mode_idx = 0;
    protected Editor data_edit;

    public TextEditor(boolean editable, CTX ctx, Window window) {
        this(null, editable, ctx, window);
    }

    public TextEditor(Descriptor<?> data, boolean editable, CTX ctx, Window window) {
        this(data, editable, ctx, window, "Text", new String[0]);
    }

    protected TextEditor(Descriptor<?> data, boolean editable, CTX ctx, Window window, String name, boolean allowparams, String ... modes) {
        super(data, editable, ctx, 0);
        this.allowparams = allowparams;
        this.name = name;
        this.window = window;
        this.editor = new JPanel(new BorderLayout());
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(new String[]{"No Data", "Expression"});
        if (allowparams) {
            model.addElement("With Parameter");
        }
        this.mode_idx_usr = model.getSize();
        for (String mode : modes) {
            model.addElement(mode);
        }
        this.combo = new JComboBox<String>(model);
        JLabel label = new JLabel(name + ":");
        label.setHorizontalAlignment(0);
        JPanel jp = new JPanel(new FlowLayout(1, 8, 2));
        jp.add(label);
        jp.add(this.combo);
        this.setLayout(new BorderLayout());
        this.add((Component)jp, "First");
        this.add((Component)this.editor, "Center");
        this.combo.addActionListener(this);
        if (data != null) {
            this.setData(data);
        }
    }

    public TextEditor(Descriptor<?> data, boolean editable, CTX ctx, Window window, String name, String ... modes) {
        this(data, editable, ctx, window, name, true, modes);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int idx = this.combo.getSelectedIndex();
        if (idx == this.curr_mode_idx) {
            return;
        }
        this.setMode(idx);
    }

    protected final void addEditor() {
        if (this.addExtraEditor()) {
            return;
        }
        if (this.curr_mode_idx == 0) {
            return;
        }
        if (this.allowparams && this.curr_mode_idx == 2) {
            this.data_edit = new ParameterEditor(this.data, this.editable, this.ctx, Editor.addLabel("Expression", new ExprEditor(this.editable, this.ctx, this.getClass() == TextEditor.class, true)));
            this.editor.add((Component)this.data_edit, "Center");
            return;
        }
        this.curr_mode_idx = 1;
        this.data_edit = Editor.addLabel("Expression", new ExprEditor(this.data, this.editable, this.ctx));
        this.editor.add((Component)this.data_edit, "Center");
    }

    protected boolean addExtraEditor() {
        return false;
    }

    protected final void checkData() {
        if (this.checkUsrData()) {
            return;
        }
        this.mode_idx = Editor.isNoData(this.data) ? 0 : (this.allowparams && ParameterEditor.hasParams(this.data) ? 2 : 1);
    }

    protected boolean checkUsrData() {
        return false;
    }

    @Override
    public final Descriptor<?> getData() throws MdsException {
        if (this.curr_mode_idx == 0) {
            return null;
        }
        if (this.curr_mode_idx < this.mode_idx_usr) {
            return this.data_edit.getData();
        }
        return this.getUsrData();
    }

    protected Descriptor<?> getUsrData() throws MdsException {
        return this.data_edit.getData();
    }

    @Override
    public void interrupt() {
        for (Component component : this.editor.getComponents()) {
            if (!(component instanceof Editor)) continue;
            ((Editor)component).interrupt();
        }
    }

    @Override
    public final boolean isNull() {
        return this.curr_mode_idx == 0;
    }

    protected final void refresh() {
        if (!(this.window instanceof Frame)) {
            this.window.invalidate();
            this.editor.invalidate();
            this.editor.repaint();
        }
        this.window.pack();
        this.window.repaint();
    }

    @Override
    public final void reset(boolean hard) {
        super.reset(hard);
        this.combo.setSelectedIndex(this.mode_idx);
        if (hard) {
            this.setMode(this.mode_idx);
        }
    }

    @Override
    public final void setData(Descriptor<?> data) {
        this.data = data;
        this.combo.setEnabled(this.editable || !Editor.isNoData(data));
        this.checkData();
        if (this.curr_mode_idx != this.mode_idx) {
            this.setMode(this.mode_idx);
        } else if (this.curr_mode_idx > 0) {
            if (this.curr_mode_idx < this.mode_idx_usr) {
                this.data_edit.setData(data);
            } else {
                this.setUsrData();
            }
        }
    }

    protected final void setMode(int idx) {
        this.interrupt();
        this.editor.removeAll();
        this.curr_mode_idx = idx;
        this.combo.setSelectedIndex(this.curr_mode_idx);
        this.addEditor();
        if (this.curr_mode_idx < this.mode_idx_usr) {
            this.data_edit.setData(this.data);
        } else {
            this.setUsrData();
        }
        this.refresh();
    }

    protected void setUsrData() {
        this.data_edit.setData(this.data);
    }
}

